/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Component;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Link;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Node;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeader;
import java.util.HashMap;
import java.util.Map;

final class HeaderNode
extends Node {
    private final CppHeader m_header;
    private final Map<Node, Link> m_links = new HashMap<Node, Link>();
    private final Module m_module;

    HeaderNode(CppHeader header, Module module) {
        assert (header != null) : "Parameter 'header' of method 'HeaderNode' must not be null";
        this.m_header = header;
        this.m_module = module;
    }

    @Override
    CppHeader getSource() {
        return this.m_header;
    }

    @Override
    Module getModule() {
        return this.m_module;
    }

    @Override
    protected void buildComponent(Component component) {
        component.addHeader(this);
        Module myModule = this.getModule();
        for (Link link : this.getOutgoing()) {
            Node target = link.getTo();
            if (myModule != null && target.getModule() != null && target.getModule() != myModule || component.contains(target) || target.getComponent() != null) continue;
            target.buildComponent(component);
        }
        for (Link link : this.getIncoming()) {
            HeaderNode from = link.getFrom();
            if (((Node)from).getModule() != myModule || component.contains(from) || from.getComponent() != null) continue;
            ((Node)from).buildComponent(component);
        }
    }

    void addLinkTo(Node target, NamedElement decl) {
        assert (target != null) : "Parameter 'target' of method 'addLinkTo' must not be null";
        assert (decl != null) : "Parameter 'decl' of method 'addLinkTo' must not be null";
        Link link = this.m_links.get(target);
        if (link == null) {
            link = new Link(this, target);
            this.m_links.put(target, link);
        }
        link.addDeclaration(decl);
    }

    public String toString() {
        return this.m_header.getName();
    }
}

