/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.IJsonFileManager;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

abstract class JsonFile
implements IJsonFileManager.IJsonFile {
    private final Path m_path;
    private final DocumentContext m_documentContext;

    JsonFile(Path path, IJsonFileManager manager) throws IOException {
        assert (path != null) : "Parameter 'path' of method 'JsonFile' must not be null";
        assert (manager != null) : "Parameter 'manager' of method 'JsonFile' must not be null";
        this.m_path = path.normalize();
        manager.put(this.m_path, this);
        String json = Files.readString(this.m_path, StandardCharsets.UTF_8);
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        this.m_documentContext = JsonPath.parse((String)json, (Configuration)conf);
    }

    @Override
    public final Path getPath() {
        return this.m_path;
    }

    @Override
    public final DocumentContext getDocumentContext() {
        return this.m_documentContext;
    }
}

