/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices;

import com.hello2morrow.sonargraph.api.WebMethodType;
import com.hello2morrow.sonargraph.api.WebProperty;
import com.hello2morrow.sonargraph.api.java.IAnnotationAccess;
import com.hello2morrow.sonargraph.api.java.IAnnotationValueAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class SpringDetector {
    protected static final String SPRING_FRAMEWORK_ANNOTATION_PACKAGE = "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:";
    protected static final String REQUEST_MAPPING_ANNOTATION = "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:RequestMapping:RequestMapping";
    protected static final String[] METHOD_ANNOTATIONS = new String[]{"Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:RequestMapping:RequestMapping", "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:GetMapping:GetMapping", "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:PostMapping:PostMapping", "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:PutMapping:PutMapping", "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:PatchMapping:PatchMapping", "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:DeleteMapping:DeleteMapping"};
    protected static final String FEIGN_CLIENT_ANNOTATION = "Workspace:External [Java]:[Unknown]:org:springframework:cloud:openfeign:FeignClient:FeignClient";
    protected static final String ANNOTATION_POSTFIX = "Mapping";

    static IAnnotationAccess findAnnotation(List<IAnnotationAccess> annotations, IJavaTypeAccess annotationType) {
        assert (annotations != null) : "Parameter 'annotations' of method 'findAnnotation' must not be null";
        assert (annotationType != null) : "Parameter 'annotationType' of method 'findAnnotation' must not be null";
        return annotations.stream().filter(a -> a.getAnnotationClass().equals(annotationType)).findFirst().orElse(null);
    }

    public static IAnnotationAccess findAnnotation(List<IAnnotationAccess> annotations, String annotationFqName) {
        assert (annotations != null) : "Parameter 'annotations' of method 'findAnnotation' must not be null";
        assert (annotationFqName != null && annotationFqName.length() > 0) : "Parameter 'annotationFqName' of method 'findAnnotation' must not be empty";
        return annotations.stream().filter(a -> a.getAnnotationClass().getFullyQualifiedName().equals(annotationFqName)).findFirst().orElse(null);
    }

    SpringDetector() {
    }

    protected List<String> getValueFromAnnotation(IAnnotationAccess annotation, List<String> valueNames) {
        assert (annotation != null) : "Parameter 'annotation' of method 'getPathFromRequestMapping' must not be null";
        assert (valueNames != null) : "Parameter 'valueNames' of method 'getValueFromAnnotation' must not be null";
        ArrayList<String> result = new ArrayList<String>();
        IAnnotationValueAccess value = null;
        for (String next : valueNames) {
            value = annotation.getValue(next);
            if (value != null) break;
        }
        if (value == null) {
            return Arrays.asList("");
        }
        List values = value.getValueList();
        if (values == null) {
            result.add(value.getStringValue());
        } else {
            values.forEach(v -> {
                boolean bl = result.add(v.getStringValue());
            });
        }
        return result;
    }

    protected List<String> extractMethodFromRequestMapping(IAnnotationAccess annotation) {
        assert (annotation != null) : "Parameter 'annotation' of method 'extractMethodFromRequestMapping' must not be null";
        String annotationName = annotation.getAnnotationClass().getShortName();
        if (!annotationName.startsWith("Request")) {
            assert (annotationName.endsWith(ANNOTATION_POSTFIX)) : "Annotation '" + annotationName + "' does not end with '...Request'";
            String methodName = annotationName.substring(0, annotationName.length() - ANNOTATION_POSTFIX.length()).toUpperCase();
            return Arrays.asList(methodName);
        }
        IAnnotationValueAccess method = annotation.getValue(WebProperty.HTTP_METHOD.getStandardName());
        if (method == null) {
            return Collections.emptyList();
        }
        String name = method.getEnumContantName();
        if (name != null) {
            return Arrays.asList(name);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (IAnnotationValueAccess val : method.getValueList()) {
            String enumName = val.getEnumContantName();
            if (enumName == null) continue;
            result.add(enumName);
        }
        if (result.isEmpty()) {
            result = new ArrayList(WebMethodType.asList());
            result.add("PATCH");
        }
        return result;
    }
}

