/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.duplicate;

import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.DuplicateOccurrenceDto;
import java.util.List;

public final class DuplicateDto<T extends DuplicateOccurrenceDto<?>>
implements Comparable<DuplicateDto<?>> {
    private final String m_name;
    private final int m_totalDuplicateLines;
    private final List<T> m_occurrences;

    public DuplicateDto(String name, int totalDuplicateLines, List<T> occurrences) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'DuplicateDto' must not be empty";
        assert (occurrences != null && !occurrences.isEmpty()) : "Parameter 'occurrences' of method 'DuplicateDto' must not be empty";
        this.m_name = name;
        this.m_totalDuplicateLines = totalDuplicateLines;
        this.m_occurrences = occurrences;
    }

    public String getName() {
        return this.m_name;
    }

    public List<T> getOccurrences() {
        return this.m_occurrences;
    }

    public int getTotalDuplicateLines() {
        return this.m_totalDuplicateLines;
    }

    public String toString() {
        return "DuplicateDto [m_name=" + this.m_name + ", m_totalDuplicateLines=" + this.m_totalDuplicateLines + ", m_occurrences=" + String.valueOf(this.m_occurrences) + "]";
    }

    @Override
    public int compareTo(DuplicateDto<?> other) {
        int compareDuplicateLines;
        assert (other != null) : "Parameter 'other' of method 'compareTo' must not be null";
        int compareOccurrences = Integer.compare(this.m_occurrences.size(), other.m_occurrences.size());
        if (compareOccurrences != 0) {
            return compareOccurrences;
        }
        if (this.m_totalDuplicateLines != -1 && other.m_totalDuplicateLines != -1 && (compareDuplicateLines = Integer.compare(this.m_totalDuplicateLines, other.m_totalDuplicateLines)) != 0) {
            return compareDuplicateLines;
        }
        return 0;
    }
}

