/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;

public final class SoftwareSystemFile
extends FilePath
implements IModifiableFile,
ISoftwareSystemDefinitionElement {
    public static final String NAME = "system.sonargraph";
    private final IModifiablePathListener m_listener;
    private boolean m_needsSave;
    private String m_fileId;

    public static void checkSoftwareSystemFile(TFile file, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'checkSoftwareSystemFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'checkSoftwareSystemFile' must not be null";
        if (!file.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, file.getAbsolutePath(), new Object[0]);
        } else if (!file.isFile()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_FILE, file.getAbsolutePath(), new Object[0]);
        } else if (!CoreFileType.SOFTWARE_SYSTEM.endsWith(file.getName())) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.UNEXPECTED_FILE_EXTENSION, "Not a system file:" + file.getAbsolutePath(), new Object[0]);
        }
    }

    public SoftwareSystemFile(NamedElement parent, TFile file, long timestamp, String fileId, IModifiablePathListener listener) {
        super(parent, file, timestamp);
        assert (listener != null) : "Parameter 'listener' of method 'SoftwareSystemFile' must not be null";
        this.m_listener = listener;
        this.m_fileId = fileId;
        this.m_listener.created(this);
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.SOFTWARE_SYSTEM;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public String getImageResourceName() {
        return "SoftwareSystem";
    }

    @Override
    public String getPresentationKind() {
        return "System";
    }

    @Override
    public boolean needsSave() {
        return this.m_needsSave;
    }

    @Override
    public void setNeedsSave(boolean needsSave) {
        this.m_needsSave = needsSave;
        if (needsSave) {
            this.m_listener.modified(this);
        } else {
            this.m_listener.saved(this);
        }
    }

    @Override
    public void reallocate() {
        this.resetFile();
        this.getFile();
    }

    @Override
    public void createNewFileId() {
    }

    @Override
    public String getIdentifyingPath() {
        return FileUtility.calculateRelativePath((TFile)this.getFile(), (TFile)this.getBaseDirectory().getDirectoryFile());
    }

    @Override
    public String getFileId() {
        return this.m_fileId;
    }

    public void setFileId(String fileId) {
        assert (fileId != null && fileId.length() > 0) : "Parameter 'fileId' of method 'setFileId' must not be empty";
        this.m_fileId = fileId;
    }

    @Override
    public boolean existsOnDisk() {
        return true;
    }

    @Override
    public void resetTimestamp() {
        this.setTimestamp(this.getFile().lastModified());
    }
}

