/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.graphview;

import com.hello2morrow.sonargraph.core.model.graphview.GraphViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class GraphViewState {
    private final Map<GraphViewNode, String> m_expandedNodes = new LinkedHashMap<GraphViewNode, String>();
    private final Map<GraphViewNode, String> m_selectedNodes = new LinkedHashMap<GraphViewNode, String>();
    private final Map<StrictPair<GraphViewNode, GraphViewNode>, GraphViewDependencyDescriptor> m_selectedDependencies = new LinkedHashMap<StrictPair<GraphViewNode, GraphViewNode>, GraphViewDependencyDescriptor>();

    public void process(GraphViewNode node) {
        String previous;
        assert (node != null) : "Parameter 'node' of method 'process' must not be null";
        if (node.isExpanded()) {
            previous = this.m_expandedNodes.put(node, node.getRelativePath());
            assert (previous == null) : "'previous' of method 'process' must  be null";
        }
        if (node.isSelected()) {
            previous = this.m_selectedNodes.put(node, node.getRelativePath());
            assert (previous == null) : "'previous' of method 'process' must  be null";
        }
        for (GraphViewNode.GraphViewDependency nextOut : node.getOutgoingDependencies()) {
            if (!nextOut.isSelected()) continue;
            this.m_selectedDependencies.put((StrictPair<GraphViewNode, GraphViewNode>)new StrictPair((Object)nextOut.getFrom(), (Object)nextOut.getTo()), new GraphViewDependencyDescriptor(nextOut.getFrom().getRelativePath(), nextOut.getTo().getRelativePath()));
        }
    }

    public Map<GraphViewNode, String> getExpandedNodes() {
        return Collections.unmodifiableMap(this.m_expandedNodes);
    }

    public Map<GraphViewNode, String> getSelectedNodes() {
        return Collections.unmodifiableMap(this.m_selectedNodes);
    }

    public Map<StrictPair<GraphViewNode, GraphViewNode>, GraphViewDependencyDescriptor> getSelectedDependencies() {
        return Collections.unmodifiableMap(this.m_selectedDependencies);
    }

    public boolean isEmpty() {
        return this.m_expandedNodes.isEmpty() && this.m_selectedNodes.isEmpty() && this.m_selectedDependencies.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_expandedNodes.hashCode();
        result = 31 * result + this.m_selectedNodes.hashCode();
        result = 31 * result + this.m_selectedDependencies.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GraphViewState other = (GraphViewState)obj;
        return this.m_expandedNodes.equals(other.m_expandedNodes) && this.m_selectedNodes.equals(other.m_selectedNodes) && this.m_selectedDependencies.equals(other.m_selectedDependencies);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : this.m_expandedNodes.values()) {
            builder.append("Expanded node: ").append(string).append("\n");
        }
        for (String string : this.m_selectedNodes.values()) {
            builder.append("Selected node: ").append(string).append("\n");
        }
        for (GraphViewDependencyDescriptor graphViewDependencyDescriptor : this.m_selectedDependencies.values()) {
            builder.append("Selected dependency: ").append(graphViewDependencyDescriptor).append("\n");
        }
        return builder.toString();
    }
}

