/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteDependenciesOperation
extends ArchitecturalViewOperation {
    private final List<ArchitecturalViewDependencyDescriptor> m_dependencies;

    public DeleteDependenciesOperation(NamedElement parent, PresentationMode presentationMode, List<ArchitecturalViewDependencyDescriptor> dependencies) {
        super(parent, presentationMode);
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'DeleteDependenciesOperation' must not be empty";
        this.m_dependencies = new ArrayList<ArchitecturalViewDependencyDescriptor>(dependencies);
    }

    private DeleteDependenciesOperation(NamedElement parent, DeleteDependenciesOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'DeleteDependenciesOperation' must not be null";
        this.m_dependencies = new ArrayList<ArchitecturalViewDependencyDescriptor>(copyOf.m_dependencies.size());
        copyOf.m_dependencies.forEach(d -> {
            boolean bl = this.m_dependencies.add(d.copy());
        });
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new DeleteDependenciesOperation(parent, this);
    }

    @Override
    public String getImageResourceName() {
        return "Delete";
    }

    @Override
    public boolean containsRefactoring() {
        return true;
    }

    @Override
    public String getShortName() {
        return "Delete dependencies";
    }

    public List<ArchitecturalViewDependencyDescriptor> getDependencies() {
        return Collections.unmodifiableList(this.m_dependencies);
    }

    @Override
    public String getInformation() {
        int numberOfParserDependencies = 0;
        for (ArchitecturalViewDependencyDescriptor next : this.m_dependencies) {
            int nextNumberOfParserDependencies = next.getNumberOfParserDependencies();
            if (nextNumberOfParserDependencies <= 0) continue;
            numberOfParserDependencies += nextNumberOfParserDependencies;
        }
        if (numberOfParserDependencies > 0) {
            return super.getInformation() + " Delete " + numberOfParserDependencies + (numberOfParserDependencies == 1 ? " parser dependency" : " parser dependencies") + " (refactoring)";
        }
        return super.getInformation() + " Delete " + this.m_dependencies.size() + (this.m_dependencies.size() == 1 ? " dependency" : " dependencies");
    }

    @Property
    public List<String> getInformationDeletedDependency() {
        ArrayList<String> info = new ArrayList<String>(this.m_dependencies.size());
        for (ArchitecturalViewDependencyDescriptor next : this.m_dependencies) {
            int nextNumberOfParserDependencies = next.getNumberOfParserDependencies();
            info.add(next.getFrom() + " -> " + next.getTo() + (String)(nextNumberOfParserDependencies != -1 ? " [" + nextNumberOfParserDependencies + "]" : ""));
        }
        return info;
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        executor.deleteDependencies(this, this.m_dependencies);
    }

    @Override
    public void reset() {
        for (ArchitecturalViewDependencyDescriptor next : this.m_dependencies) {
            next.setNumberOfParserDependencies(-1);
        }
        super.reset();
    }
}

