/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetNode;
import java.util.Collection;
import java.util.List;

final class FeedbackArcSetSimpleCycle {
    private final List<FeedbackArcSetNode.Edge> m_edges;

    FeedbackArcSetSimpleCycle(List<FeedbackArcSetNode.Edge> edges) {
        assert (edges != null && edges.size() >= 2) : "Parameter 'adges' of method 'FeedbackArcSetSimpleCycle' must contain at least 2 edges";
        this.m_edges = edges;
    }

    Collection<FeedbackArcSetNode.Edge> getEdges() {
        return this.m_edges;
    }

    int getNumberOfEdges() {
        return this.m_edges.size();
    }

    int getMinEdgeWeight() {
        int minWeight = Integer.MAX_VALUE;
        for (FeedbackArcSetNode.Edge nextEdge : this.m_edges) {
            int nextWeight = nextEdge.getWeight();
            assert (nextWeight >= 0);
            minWeight = Math.min(nextWeight, minWeight);
        }
        return minWeight;
    }

    int getWeight() {
        int weigth = 0;
        for (FeedbackArcSetNode.Edge nextEdge : this.m_edges) {
            int nextWeight = nextEdge.getWeight();
            assert (nextWeight >= 0);
            weigth += nextWeight;
        }
        return weigth;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Min weight: ").append(this.getMinEdgeWeight()).append(", edges: ").append(this.m_edges.size()).append(", weight: ").append(this.getWeight());
        return builder.toString();
    }
}

