/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.script.internal;

import com.hello2morrow.sonargraph.core.controller.system.script.internal.SonargraphGroovyClassLoader;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.script.AutomatedScriptCompilationError;
import com.hello2morrow.sonargraph.core.model.script.AutomatedScriptRuntimeError;
import com.hello2morrow.sonargraph.core.model.script.FullGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IScriptApi;
import com.hello2morrow.sonargraph.core.model.script.ManualScriptCompilationError;
import com.hello2morrow.sonargraph.core.model.script.ManualScriptRuntimeError;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import de.schlichtherle.truezip.file.TFile;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.transform.ThreadInterrupt;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphGroovyShell {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphGroovyShell.class);
    private static final String SONARGRAPH_FULL_SCRIPT_PACKAGE = "com.hello2morrow";
    private static final String TAB = "    ";
    private final SonargraphGroovyClassLoader m_sonargraphGroovyClassLoader;
    private final ScriptOutputStreamProvider m_outputStreamProvider;
    private final TFile m_baseDirForScriptOutput;

    public SonargraphGroovyShell(TFile baseDirForScriptOutput, AggregatingClassLoader aggregatingClassLoader, ScriptOutputStreamProvider outputStreamProvider) {
        assert (baseDirForScriptOutput != null) : "Parameter 'baseDirForScriptOutput' of method 'SonargraphGroovyShell' must not be null";
        assert (aggregatingClassLoader != null) : "Parameter 'aggregatingClassLoader' of method 'SonargraphGroovyShell' must not be null";
        assert (outputStreamProvider != null) : "Parameter 'outputStreamProvider' of method 'SonargraphGroovyShell' must not be null";
        this.m_baseDirForScriptOutput = baseDirForScriptOutput;
        this.m_sonargraphGroovyClassLoader = new SonargraphGroovyClassLoader(aggregatingClassLoader);
        this.m_outputStreamProvider = outputStreamProvider;
    }

    public ScriptOutputStreamProvider getOutputStreamProvider() {
        return this.m_outputStreamProvider;
    }

    public void reset(IGroovyScript script, boolean isAutomated, NamedElement issueTarget) {
        assert (script != null) : "Parameter 'script' of method 'reset' must not be null";
        assert (issueTarget != null) : "Parameter 'issueTarget' of method 'reset' must not be null";
        if (isAutomated) {
            issueTarget.removeIssues(CoreIssueId.AUTOMATED_SCRIPT_COMPILATION_ERROR, CoreIssueId.AUTOMATED_SCRIPT_RUNTIME_ERROR);
        } else {
            issueTarget.removeIssues(CoreIssueId.MANUAL_SCRIPT_COMPILATION_ERROR, CoreIssueId.MANUAL_SCRIPT_RUNTIME_ERROR);
        }
        script.setIsExecutable(false);
    }

    /*
     * Unable to fully structure code
     */
    public void compile(IGroovyScript script, IScriptApi scriptApi, IRunConfiguration runConfiguration, boolean isAutomated, NamedElement issueTarget) {
        block18: {
            block17: {
                if (!SonargraphGroovyShell.$assertionsDisabled && script == null) {
                    throw new AssertionError((Object)"Parameter 'script' of method 'compile' must not be null");
                }
                if (!SonargraphGroovyShell.$assertionsDisabled && scriptApi == null) {
                    throw new AssertionError((Object)"Parameter 'name' of method 'compile' must not be null");
                }
                if (!SonargraphGroovyShell.$assertionsDisabled && runConfiguration == null) {
                    throw new AssertionError((Object)"Parameter 'runConfiguration' of method 'compile' must not be null");
                }
                if (!SonargraphGroovyShell.$assertionsDisabled && issueTarget == null) {
                    throw new AssertionError((Object)"Parameter 'issueTarget' of method 'compile' must not be null");
                }
                this.reset(script, isAutomated, issueTarget);
                compilerConfiguration = new CompilerConfiguration();
                compilerConfiguration.setSourceEncoding("UTF-8");
                compilerConfiguration.setDebug(true);
                compilerConfiguration.setTargetBytecode("11");
                importCustomizer = new ImportCustomizer();
                starImports = scriptApi.getStarImports();
                if (!starImports.isEmpty()) {
                    importCustomizer.addStarImports(starImports.toArray(new String[starImports.size()]));
                }
                if (!(imports = scriptApi.getImports()).isEmpty()) {
                    importCustomizer.addImports(imports.toArray(new String[imports.size()]));
                }
                customizers = new ArrayList<Object>(3);
                customizers.add(importCustomizer);
                customizers.add(new ASTTransformationCustomizer(ThreadInterrupt.class));
                compilerConfiguration.addCompilationCustomizers(customizers.toArray(new CompilationCustomizer[0]));
                script.setScriptApiAndClassLoader(scriptApi, (ClassLoader)this.m_sonargraphGroovyClassLoader);
                binding = new Binding();
                for (Map.Entry<String, StrictPair<Object, Class<?>>> nextEntry : scriptApi.getRoots().entrySet()) {
                    binding.setVariable(nextEntry.getKey(), nextEntry.getValue().getFirst());
                }
                for (Map.Entry<String, Object> parameterValue : runConfiguration.getAllParameters().entrySet()) {
                    if (IRunConfiguration.PREDEFINED.contains(parameterValue.getKey())) continue;
                    binding.setVariable(this.createParameterName(parameterValue.getKey()), parameterValue.getValue());
                }
                try {
                    SonargraphGroovyShell.LOGGER.debug("Parsing content of Groovy script {}", (Object)script.getIdentifyingPath());
                    groovyShell = new GroovyShell((ClassLoader)this.m_sonargraphGroovyClassLoader, binding, compilerConfiguration);
                    script.setCompiledScript(groovyShell.parse(script.getSource(), script.getIdentifyingPath()));
                    script.setIsExecutable(true);
                }
                catch (MultipleCompilationErrorsException exception) {
                    errorCollector = exception.getErrorCollector();
                    warnings = errorCollector.getWarnings();
                    if (warnings == null) break block17;
                    ** for (next : warnings)
                }
lbl-1000:
                // 1 sources

                {
                    SonargraphGroovyShell.LOGGER.warn(next.toString());
                    continue;
                }
            }
            if ((errors = errorCollector.getErrors()) == null) break block18;
            for (E next : errors) {
                if (next instanceof SyntaxErrorMessage) {
                    nextSyntaxErrorMessage = (SyntaxErrorMessage)next;
                    syntaxException = nextSyntaxErrorMessage.getCause();
                    SonargraphGroovyShell.LOGGER.debug("Adding GroovyCompilationError to Groovy script {}, caused by SyntaxErrorMessage {}", (Object)script.getIdentifyingPath(), (Object)nextSyntaxErrorMessage);
                    if (isAutomated) {
                        issueTarget.addIssue(new AutomatedScriptCompilationError(issueTarget, syntaxException.getMessage(), syntaxException.getLine(), syntaxException.getStartColumn() - 1));
                        continue;
                    }
                    issueTarget.addIssue(new ManualScriptCompilationError(issueTarget, syntaxException.getMessage(), syntaxException.getLine(), syntaxException.getStartColumn() - 1));
                    continue;
                }
                if (!(next instanceof ExceptionMessage)) continue;
                nextExceptionMessage = (ExceptionMessage)next;
                if (isAutomated) {
                    issueTarget.addIssue(new AutomatedScriptCompilationError(issueTarget, nextExceptionMessage.getCause().getMessage(), 1, 1));
                    continue;
                }
                issueTarget.addIssue(new ManualScriptCompilationError(issueTarget, nextExceptionMessage.getCause().getMessage(), 1, 1));
            }
            break block18;
            catch (Throwable exception) {
                SonargraphGroovyShell.LOGGER.debug("Adding GroovyCompilationError to Groovy script {}, caused by {}", (Object)script.getIdentifyingPath(), (Object)exception.getMessage());
                if (isAutomated) {
                    issueTarget.addIssue(new AutomatedScriptCompilationError(issueTarget, ExceptionUtility.collectFirstAndLast((Throwable)exception), -1, -1));
                }
                issueTarget.addIssue(new ManualScriptCompilationError(issueTarget, ExceptionUtility.collectFirstAndLast((Throwable)exception), -1, -1));
            }
        }
    }

    private void handleExecutionErrors(IGroovyScript script, boolean isAutomated, NamedElement issueTarget, long start, Throwable throwable, Writer writer) throws IOException {
        assert (script != null) : "Parameter 'script' of method 'handleExecutionErrors' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'handleExecutionErrors' must not be null";
        assert (issueTarget != null) : "Parameter 'issueTarget' of method 'handleExecutionErrors' must not be null";
        assert (writer != null) : "Parameter 'writer' of method 'handleExecutionErrors' must not be null";
        long duration = System.currentTimeMillis() - start;
        if (throwable instanceof TimeoutException) {
            script.setStatus(IGroovyScript.Status.TIMED_OUT);
            writer.write(StringUtility.LINE_SEPARATOR + "Script '" + script.getIdentifyingPath() + "' timed out after " + duration + " ms." + StringUtility.LINE_SEPARATOR);
            if (isAutomated) {
                issueTarget.addIssue(new AutomatedScriptRuntimeError(issueTarget, "Script timed out after " + duration + " ms"));
            }
        } else if (throwable instanceof InterruptedException) {
            if (!isAutomated) {
                script.setStatus(IGroovyScript.Status.INTERRUPTED);
            }
            writer.write(StringUtility.LINE_SEPARATOR + "Script '" + script.getIdentifyingPath() + "' has been interrupted after " + duration + " ms." + StringUtility.LINE_SEPARATOR);
        } else {
            script.setStatus(IGroovyScript.Status.RUNTIME_ERROR);
            writer.write(StringUtility.LINE_SEPARATOR + "Script '" + script.getIdentifyingPath() + "' has been aborted after " + duration + " ms due to:" + StringUtility.LINE_SEPARATOR);
            boolean addedError = false;
            writer.write(throwable.getClass().getCanonicalName());
            writer.write(":" + StringUtility.LINE_SEPARATOR);
            String message = throwable.getMessage();
            writer.write(message != null ? message : throwable.getClass().getName());
            writer.write(StringUtility.LINE_SEPARATOR);
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                if (!(ste.getClassName().startsWith("org.codehaus.groovy") || ste.getClassName().startsWith("sun.reflect") || ste.getClassName().startsWith("java.lang.reflect") || ste.getClassName().startsWith("java.util.concurrent.Executors") || ste.getClassName().startsWith("java.util.concurrent.FutureTask") || ste.getClassName().startsWith("java.util.concurrent.ThreadPoolExecutor") || ste.getClassName().startsWith("java.lang.Thread"))) {
                    if (ste.getClassName().startsWith(SonargraphGroovyShell.class.getCanonicalName())) break;
                    if (ste.getClassName().startsWith(script.getCompiledScript().getClass().getName())) {
                        int lineNumber = ste.getLineNumber();
                        String description = throwable.toString();
                        issueTarget.addIssue(isAutomated ? new AutomatedScriptRuntimeError(issueTarget, description, lineNumber) : new ManualScriptRuntimeError(issueTarget, description, lineNumber));
                        writer.write(ste.getClassName() + "(" + script.getIdentifyingPath() + ":" + lineNumber + ")");
                        addedError = true;
                    } else {
                        writer.write(ste.toString());
                    }
                    writer.write(StringUtility.LINE_SEPARATOR);
                }
                ++n2;
            }
            if (!addedError) {
                issueTarget.addIssue(isAutomated ? new AutomatedScriptRuntimeError(issueTarget, throwable.toString()) : new ManualScriptRuntimeError(issueTarget, throwable.toString()));
            }
            writer.write(StringUtility.LINE_SEPARATOR);
        }
        writer.flush();
    }

    public void run(IGroovyScript script, IRunConfiguration runConfiguration, boolean isAutomated, NamedElement issueTarget) {
        assert (script != null) : "Parameter 'script' of method 'runScript' must not be null";
        assert (script.isExecutable()) : "Not an executable script: " + script.getIdentifyingPath();
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'run' must not be null";
        assert (issueTarget != null) : "Parameter 'issueTarget' of method 'run' must not be null";
        try {
            OutputStreamWriter writer;
            Object var11_15;
            long start = System.currentTimeMillis();
            String output = runConfiguration.getOutput();
            String outputPath = output != null && !output.isEmpty() ? (!FileUtility.isNormalizedPathAbsolute((String)output) ? new TFile((File)this.m_baseDirForScriptOutput, FileUtility.convertPathToUniversalForm((String)output)).getNormalizedAbsolutePath() : new TFile(FileUtility.convertPathToUniversalForm((String)output)).getNormalizedAbsolutePath()) : null;
            OperationResultWithOutcome<OutputStream> scriptOutputResult = this.m_outputStreamProvider.beforeScriptExecution(script.getIdentifyingPath(), runConfiguration.getRunConfigurationName(), isAutomated, outputPath);
            if (scriptOutputResult.isFailure()) {
                if (scriptOutputResult.getOutcome() != null) {
                    try {
                        Throwable throwable = null;
                        var11_15 = null;
                        try {
                            writer = new OutputStreamWriter((OutputStream)scriptOutputResult.getOutcome());
                            try {
                                this.writeScriptExecutionPreamble(script, runConfiguration, writer);
                                writer.write(scriptOutputResult.toString());
                                writer.write(StringUtility.LINE_SEPARATOR);
                                this.writeScriptExecutionPostamble(script, runConfiguration, isAutomated, writer);
                            }
                            finally {
                                if (writer != null) {
                                    ((Writer)writer).close();
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.error("Failed to write output for script '" + script.getIdentifyingPath() + "'");
                    }
                }
                issueTarget.addIssue(isAutomated ? new AutomatedScriptRuntimeError(issueTarget, scriptOutputResult.toString()) : new ManualScriptRuntimeError(issueTarget, scriptOutputResult.toString()));
                script.setStatus(IGroovyScript.Status.RUNTIME_ERROR);
            }
            script.getCompiledScript().getBinding().setProperty("out", scriptOutputResult.getOutcome());
            try {
                Throwable ex = null;
                var11_15 = null;
                try {
                    writer = new OutputStreamWriter((OutputStream)scriptOutputResult.getOutcome());
                    try {
                        this.writeScriptExecutionPreamble(script, runConfiguration, writer);
                        try {
                            script.setStatus(IGroovyScript.Status.EXECUTING);
                            script.getCompiledScript().run();
                            script.setStatus(IGroovyScript.Status.FINISHED_NORMALLY);
                            writer.write(StringUtility.LINE_SEPARATOR + "[" + Iso8601DateFormat.formatDateAndTime((Date)new Date()) + "] Finished script '" + script.getIdentifyingPath());
                            writer.write("', using run configuration '" + runConfiguration.getRunConfigurationName() + "'");
                            writer.write(" in " + (System.currentTimeMillis() - start) + " ms." + StringUtility.LINE_SEPARATOR);
                            ((Writer)writer).flush();
                        }
                        catch (Throwable t) {
                            this.handleExecutionErrors(script, isAutomated, issueTarget, start, t, writer);
                        }
                        this.writeScriptExecutionPostamble(script, runConfiguration, isAutomated, writer);
                    }
                    finally {
                        if (writer != null) {
                            ((Writer)writer).close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (ex == null) {
                        ex = throwable;
                    } else if (ex != throwable) {
                        ex.addSuppressed(throwable);
                    }
                    throw ex;
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close script output", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("Unhandled exception during execution of script '" + script.getName() + "'", throwable);
            script.setStatus(IGroovyScript.Status.RUNTIME_ERROR);
            if (isAutomated) {
                issueTarget.addIssue(new AutomatedScriptRuntimeError(issueTarget, "Unexpected error during script execution: " + ExceptionUtility.collectFirstAndLast((Throwable)throwable)));
            }
            issueTarget.addIssue(new ManualScriptRuntimeError(issueTarget, "Unexpected error during script execution: " + ExceptionUtility.collectFirstAndLast((Throwable)throwable)));
        }
    }

    private void writeScriptExecutionPostamble(IGroovyScript script, IRunConfiguration runConfiguration, boolean isAutomated, Writer writer) throws IOException {
        assert (script != null) : "Parameter 'script' of method 'writeScriptExecutionPostamble' must not be null";
        assert (writer != null) : "Parameter 'writer' of method 'writeScriptExecutionPostamble' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'writeScriptExecutionPostamble' must not be null";
        writer.flush();
        this.m_outputStreamProvider.afterScriptExecution(script.getIdentifyingPath(), runConfiguration.getRunConfigurationName(), isAutomated);
        writer.write(StringUtility.LINE_SEPARATOR);
        writer.flush();
    }

    private void writeScriptExecutionPreamble(IGroovyScript script, IRunConfiguration runConfiguration, Writer writer) throws IOException {
        writer.write("[" + Iso8601DateFormat.formatDateAndTime((Date)new Date()) + "] Starting script '" + script.getIdentifyingPath());
        writer.write("', using run configuration '" + runConfiguration.getRunConfigurationName() + "' with parameters:" + StringUtility.LINE_SEPARATOR);
        writer.write(runConfiguration.getParameterInfo().replace(StringUtility.LINE_SEPARATOR, StringUtility.LINE_SEPARATOR) + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR);
        writer.flush();
    }

    public FullGroovyScript getFullScript(IGroovyScript script, IScriptApi scriptApi, String source, int offset) {
        assert (script != null) : "Parameter 'script' of method 'getFullScript' must not be null";
        assert (scriptApi != null) : "Parameter 'scriptApi' of method 'getFullScript' must not be null";
        assert (source != null) : "Parameter 'source' of method 'getFullScript' must not be null";
        StringBuilder fullSource = new StringBuilder();
        String additionalPackageParts = script.getIdentifyingPath().replace(".", "");
        int pos = additionalPackageParts.lastIndexOf("/");
        additionalPackageParts = pos != -1 ? additionalPackageParts.substring(0, pos).replace('/', '.').toLowerCase() : "";
        String packageName = SONARGRAPH_FULL_SCRIPT_PACKAGE + additionalPackageParts;
        String scriptName = FileUtility.removeExtension((String)script.getShortName());
        fullSource.append("package ").append(packageName).append("\n\n");
        for (String string : scriptApi.getStarImports()) {
            fullSource.append("import ").append(string).append(".*\n");
        }
        for (String string : scriptApi.getImports()) {
            fullSource.append("import ").append(string).append("\n");
        }
        fullSource.append("\n");
        for (Map.Entry entry : scriptApi.getRoots().entrySet()) {
            fullSource.append(TAB).append("@groovy.transform.Field").append(" ").append(((Class)((StrictPair)entry.getValue()).getSecond()).getSimpleName()).append(" ").append((String)entry.getKey()).append("\n");
        }
        for (ParameterDefinition parameterDefinition : script.getScriptContent().getParameterDefinitions()) {
            fullSource.append(TAB).append("@groovy.transform.Field").append(" ").append(parameterDefinition.getType().getPresentationName()).append(" ").append(this.createParameterName(parameterDefinition.getName())).append("\n");
        }
        fullSource.append("\n");
        fullSource.append("//// Start source ////\n\n");
        int n = fullSource.length();
        fullSource.append(source);
        fullSource.append("\n\n");
        fullSource.append("//// End source ////\n\n");
        return new FullGroovyScript(scriptApi, packageName, scriptName, fullSource.toString(), n, offset + n);
    }

    private String createParameterName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createParameterName' must not be empty";
        return "parameter" + StringUtility.firstCharacterCase((String)name, (boolean)false);
    }
}

