/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.script.internal;

import com.hello2morrow.sonargraph.core.model.element.BlockedFromGroovyScript;
import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

final class SonargraphGroovyClassLoader
extends AggregatingClassLoader {
    private static final Set<String> s_packageBlacklist;
    private static final Set<String> s_packagePrefixBlacklist;

    static {
        s_packagePrefixBlacklist = new HashSet<String>();
        s_packagePrefixBlacklist.add("com.hello2morrow.sonargraph.core.command");
        s_packagePrefixBlacklist.add("com.hello2morrow.sonargraph.core.controllerinterface");
        s_packagePrefixBlacklist.add("com.hello2morrow.sonargraph.core.foundation");
        s_packagePrefixBlacklist.add("com.hello2morrow.sonargraph.core.persistence");
        s_packageBlacklist = new HashSet<String>();
        s_packageBlacklist.add("com.hello2morrow.sonargraph.core.application");
    }

    SonargraphGroovyClassLoader(AggregatingClassLoader aggregatingClassLoader) {
        super(aggregatingClassLoader);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Annotation[] clazzAnnotations;
        Class clazz = super.loadClass(name);
        Annotation[] annotationArray = clazzAnnotations = clazz.getAnnotations();
        int n = clazzAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof BlockedFromGroovyScript) {
                throw new ClassNotFoundException(name);
            }
            ++n2;
        }
        Package p = clazz.getPackage();
        if (p != null) {
            if (s_packageBlacklist.contains(p.getName())) {
                throw new ClassNotFoundException(name);
            }
            for (String next : s_packagePrefixBlacklist) {
                if (!p.getName().startsWith(next)) continue;
                throw new ClassNotFoundException(name);
            }
        }
        return clazz;
    }
}

