/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.graphview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewRepresentation;
import java.util.List;

public final class GraphViewElementResolver {
    private GraphViewElementResolver() {
    }

    public static <T> T resolve(String relativePath, Class<T> clazz, GraphViewRepresentation representation, boolean all) {
        assert (relativePath != null) : "Parameter 'relativePath' of method 'resolve' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'resolve' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'resolve' must not be null";
        if (relativePath.isEmpty() && clazz.isAssignableFrom(GraphViewRepresentation.class)) {
            return (T)representation;
        }
        List<String> split = Element.splitDescriptor(relativePath);
        if (!split.isEmpty()) {
            GraphViewElement current = representation;
            int i = 0;
            while (i < split.size()) {
                String nextPathPart = split.get(i);
                if ((current = current.resolveByRelativePathPart(nextPathPart, all)) == null) {
                    return null;
                }
                ++i;
            }
            assert (current != null) : "'current' of method 'resolve' must not be null";
            if (clazz.isAssignableFrom(current.getClass())) {
                return (T)current;
            }
        }
        return null;
    }
}

