/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class ArchitecturalViewNodesInfo {
    private final Set<ArtifactNode> m_artifacts = new LinkedHashSet<ArtifactNode>();
    private final Set<AssignableNode> m_assignables = new LinkedHashSet<AssignableNode>();
    private final Set<ArchitecturalViewNode> m_nodes = new LinkedHashSet<ArchitecturalViewNode>();
    private final Set<String> m_relativePaths = new LinkedHashSet<String>();
    private final ExplorationViewRepresentation m_representation;

    ArchitecturalViewNodesInfo() {
        this.m_representation = null;
    }

    ArchitecturalViewNodesInfo(ExplorationViewRepresentation representation, Set<ArchitecturalViewNode> nodes) {
        boolean success;
        assert (representation != null) : "Parameter 'representation' of method 'ArchitecturalViewNodesInfo' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'ArchitecturalViewNodesInfo' must not be null";
        this.m_representation = representation;
        for (ArchitecturalViewNode architecturalViewNode : nodes) {
            if (architecturalViewNode instanceof ArtifactNode) {
                boolean success2 = this.m_artifacts.add((ArtifactNode)architecturalViewNode);
                assert (success2) : "Artifact node '" + String.valueOf(architecturalViewNode) + "' already added: " + architecturalViewNode.getElementInfo();
                continue;
            }
            if (architecturalViewNode instanceof AssignableNode && ((AssignableNode)architecturalViewNode).isAssignable()) {
                boolean success2 = this.m_assignables.add((AssignableNode)architecturalViewNode);
                assert (success2) : "Artifact node '" + String.valueOf(architecturalViewNode) + "' already added: " + architecturalViewNode.getElementInfo();
                continue;
            }
            this.m_artifacts.clear();
            this.m_assignables.clear();
            break;
        }
        for (ArtifactNode artifactNode : this.m_artifacts) {
            this.m_nodes.add(artifactNode);
            String relativePath = artifactNode.getRelativePath();
            success = this.m_relativePaths.add(relativePath);
            assert (success) : "Relative path '" + relativePath + "' already added: " + artifactNode.getElementInfo();
        }
        for (AssignableNode assignableNode : this.m_assignables) {
            this.m_nodes.add(assignableNode);
            String relativePath = assignableNode.getRelativePath();
            success = this.m_relativePaths.add(relativePath);
            assert (success) : "Relative path '" + relativePath + "' already added: " + assignableNode.getElementInfo();
        }
    }

    boolean isValid() {
        return this.m_representation != null;
    }

    ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    int getNumberOfNodes() {
        return this.m_nodes.size();
    }

    int getNumberOfArtifacts() {
        return this.m_artifacts.size();
    }

    int getNumberOfAssignables() {
        return this.m_assignables.size();
    }

    Set<ArchitecturalViewNode> getNodes() {
        return Collections.unmodifiableSet(this.m_nodes);
    }

    Set<ArtifactNode> getArtifacts() {
        return new LinkedHashSet<ArtifactNode>(this.m_artifacts);
    }

    Set<AssignableNode> getAssignables() {
        return Collections.unmodifiableSet(this.m_assignables);
    }

    List<String> getRelativePaths() {
        return new ArrayList<String>(this.m_relativePaths);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" (representation: ").append(this.m_representation != null ? this.m_representation.getName() : "NONE").append(", elements: ").append(this.m_nodes.size()).append(")");
        for (String string : this.m_relativePaths) {
            builder.append("\n").append("Relative path: ").append(string);
        }
        for (ArtifactNode artifactNode : this.m_artifacts) {
            builder.append("\n").append("Artifact: ").append(artifactNode.getElementInfo());
        }
        for (AssignableNode assignableNode : this.m_assignables) {
            builder.append("\n").append("Assignable ").append(assignableNode.getElementInfo());
        }
        return builder.toString();
    }
}

