/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewArchitectureIssueProcessor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElementHasAssignedElementsIssue;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElementHasNoAssignedElementsIssue;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitecturalViewArchitectureCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewArchitectureCheck.class);

    private ArchitecturalViewArchitectureCheck() {
    }

    private static boolean isHidden(ArtifactNode from, ArtifactNode anchor, ArtifactNode target) {
        assert (from != null) : "Parameter 'from' of method 'isHidden' must not be null";
        assert (anchor != null) : "Parameter 'parent' of method 'isHiddenFrom' must not be null";
        assert (target != null) : "Parameter 'target' of method 'isHiddenFrom' must not be null";
        assert (anchor == target || target.hasAsParent(anchor, false));
        if (anchor == target || from == anchor && target.getParent() == anchor) {
            return false;
        }
        ArtifactNode node = target;
        while (node != anchor) {
            if (node.getVisibility().contains(ArtifactVisibility.HIDDEN)) {
                return true;
            }
            node = node.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
        }
        return false;
    }

    private static boolean isLocal(ArtifactNode anchor, ArtifactNode source) {
        assert (anchor != null) : "Parameter 'anchor' of method 'isLocal' must not be null";
        assert (source != null) : "Parameter 'source' of method 'isLocal' must not be null";
        assert (anchor == source || source.hasAsParent(anchor, false));
        if (anchor == source) {
            return false;
        }
        ArtifactNode node = source;
        while (node != anchor) {
            if (node.getVisibility().contains(ArtifactVisibility.LOCAL)) {
                return true;
            }
            node = node.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
        }
        return false;
    }

    private static String checkUsingStereotypes(ArtifactNode from, ArtifactNode to) {
        String violationMessage = null;
        ArchitecturalViewElement commonParent = from.getParent(ArchitecturalViewElement.class, new Class[0]);
        while (!to.hasAsParent(commonParent, false)) {
            commonParent = commonParent.getParent(ArchitecturalViewElement.class, new Class[0]);
            assert (commonParent != null);
        }
        ArtifactNode fromAnchor = null;
        ArtifactPropertiesNode toAnchor = null;
        int fromIndex = -1;
        int toIndex = -1;
        int index = 0;
        for (ArtifactNode artifactNode : commonParent.getChildren(ArtifactNode.class)) {
            if (artifactNode == from || from.hasAsParent(artifactNode, false)) {
                fromAnchor = artifactNode;
                fromIndex = index;
            } else if (artifactNode == to || to.hasAsParent(artifactNode, false)) {
                toAnchor = artifactNode;
                toIndex = index;
            }
            if (fromAnchor != null && toAnchor != null) break;
            ++index;
        }
        assert (fromAnchor != null && toAnchor != null && fromAnchor != toAnchor);
        assert (fromIndex >= 0 && toIndex >= 0 && fromIndex != toIndex);
        if (ArchitecturalViewArchitectureCheck.isLocal(fromAnchor, from)) {
            violationMessage = String.format("'%s' cannot access '%s' because '%s' is <local>", from.getName(), to.getName(), from.getName());
        } else if (ArchitecturalViewArchitectureCheck.isHidden(from, toAnchor, to)) {
            violationMessage = String.format("'%s' cannot access '%s' because it is <hidden>", from.getName(), to.getName());
        } else if (!toAnchor.isPublic() || toIndex < fromIndex) {
            switch (fromAnchor.getOutgoingDependencyMode()) {
                case RELAXED: {
                    if (toIndex >= fromIndex) break;
                    violationMessage = String.format("'%s' cannot access '%s' because it is defined above it", fromAnchor.getName(), toAnchor.getName());
                    break;
                }
                case RESTRICTED: {
                    violationMessage = String.format("'%s' cannot access '%s'", fromAnchor.getName(), toAnchor.getName());
                    break;
                }
                case STRICT: {
                    if (toIndex - fromIndex == 1) break;
                    violationMessage = String.format("'%s' cannot access '%s' because it not directly beneath it", fromAnchor.getName(), toAnchor.getName());
                    break;
                }
            }
        }
        return violationMessage;
    }

    private static boolean checkUsingAllowedDependencies(ArtifactNode from, ArtifactNode to) {
        assert (from != null) : "Parameter 'from' of method 'checkUsingAllowedDependencies' must not be null";
        assert (to != null) : "Parameter 'to' of method 'checkUsingAllowedDependencies' must not be null";
        do {
            for (ArtifactNode target : from.getAllowed()) {
                if (target == to) {
                    return true;
                }
                if (!to.hasAsParent(target, false) || ArchitecturalViewArchitectureCheck.isHidden(target, target, to)) continue;
                return true;
            }
        } while (!from.getVisibility().contains(ArtifactVisibility.LOCAL) && (from = from.getParent(ArtifactNode.class, ParentMode.ONLY_DIRECT_PARENT)) != null);
        return false;
    }

    private static String checkArtifactDependency(ArtifactNode from, ArtifactNode to) {
        assert (from != null) : "Parameter 'from' of method 'checkArtifactDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'checkArtifactDependency' must not be null";
        assert (from != to) : "No self reference expected for: " + String.valueOf(from);
        Object violationMessage = null;
        LOGGER.debug(String.format("Checking %s -> %s", from.getName(), to.getName()));
        if (to.hasAsParent(from, false)) {
            if (ArchitecturalViewArchitectureCheck.isHidden(from, from, to)) {
                violationMessage = String.format("'%s' cannot access '%s' because it is <hidden>", from.getName(), to.getName());
            }
        } else if (from.hasAsParent(to, false)) {
            violationMessage = "Nested artifact '" + from.getName() + "' cannot access parent artifact '" + to.getName() + "'";
        } else if (!ArchitecturalViewArchitectureCheck.checkUsingAllowedDependencies(from, to)) {
            violationMessage = ArchitecturalViewArchitectureCheck.checkUsingStereotypes(from, to);
        }
        if (violationMessage != null) {
            LOGGER.debug("Violation: " + violationMessage);
        }
        return violationMessage;
    }

    private static void collectToArtifacts(ExplorationViewRepresentation representation, ArtifactNode fromArtifact, ProgrammingElementAggregatingNode node, Map<ArtifactNode, List<ParserDependency>> toArtifactToParserDependencies, ParserDependencyEndPoints endPoints) {
        assert (representation != null) : "Parameter 'representation' of method 'collectToArtifacts' must not be null";
        assert (fromArtifact != null) : "Parameter 'fromArtifact' of method 'collectToArtifacts' must not be null";
        assert (node != null) : "Parameter 'node' of method 'collectToArtifacts' must not be null";
        assert (!node.isExternal()) : "Node is external";
        assert (toArtifactToParserDependencies != null) : "Parameter 'toArtifactToParserDependencies' of method 'collectToArtifacts' must not be null";
        assert (endPoints != null) : "Parameter 'endPoints' of method 'collectToArtifacts' must not be null";
        for (ProgrammingElement nextProgrammingElement : node.getRelevantProgrammingElements()) {
            Iterator<ParserDependency> iter = nextProgrammingElement.getDependencyIterator();
            while (iter.hasNext()) {
                ArtifactNode nextToArtifact;
                ParserDependency nextParserDependency = iter.next();
                if (representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded() && (nextToArtifact = representation.getArtifactNode(endPoints.getTo())) != null && nextToArtifact != fromArtifact) {
                    List<ParserDependency> deps = toArtifactToParserDependencies.get(nextToArtifact);
                    if (deps == null) {
                        deps = new ArrayList<ParserDependency>();
                        toArtifactToParserDependencies.put(nextToArtifact, deps);
                    }
                    deps.add(nextParserDependency);
                }
                endPoints.reset();
            }
        }
    }

    private static void checkAssignmentMode(ArtifactNode artifact, boolean recursively) {
        assert (artifact != null) : "Parameter 'artifact' of method 'checkAssignmentMode' must not be null";
        artifact.removeIssues(CoreIssueId.ARCHITECTURAL_VIEW_ELEMENT_HAS_NO_ASSIGNED_ELEMENTS, CoreIssueId.ARCHITECTURAL_VIEW_ELEMENT_HAS_ASSIGNED_ELEMENTS);
        ArtifactAssignmentMode assignmentMode = artifact.getAssignmentMode();
        switch (assignmentMode) {
            case DEPRECATED: {
                if (!artifact.hasAssignedElement(true)) break;
                artifact.addIssue(new ArchitecturalViewElementHasAssignedElementsIssue(artifact, "Marked as '" + assignmentMode.getPresentationName() + "' and has assigned elements"));
                break;
            }
            case STANDARD: {
                if (artifact.hasAssignedElement(true)) break;
                artifact.addIssue(new ArchitecturalViewElementHasNoAssignedElementsIssue(artifact, "Marked as '" + assignmentMode.getPresentationName() + "' and has no assigned elements"));
                break;
            }
            case OPTIONAL: {
                break;
            }
            default: {
                assert (false) : "Unhandled assignment mode: " + String.valueOf(assignmentMode);
                break;
            }
        }
        if (recursively) {
            artifact.getChildren(ArtifactNode.class).forEach(c -> ArchitecturalViewArchitectureCheck.checkAssignmentMode(c, recursively));
        }
    }

    static void checkAssignmentMode(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        LOGGER.debug("Check assignment mode");
        List<ArtifactNode> topLevelArtifactNodes = representation.getChildren(ArtifactNode.class);
        if (!topLevelArtifactNodes.isEmpty()) {
            topLevelArtifactNodes.forEach(a -> ArchitecturalViewArchitectureCheck.checkAssignmentMode(a, true));
        }
        LOGGER.debug("Check assignment mode - done");
    }

    private static void checkArtifact(ExplorationViewRepresentation representation, ArtifactNode artifact, ParserDependencyEndPoints endPoints) {
        assert (representation != null) : "Parameter 'representation' of method 'checkArtifact' must not be null";
        assert (artifact != null) : "Parameter 'artifact' of method 'checkArtifact' must not be null";
        assert (endPoints != null) : "Parameter 'endPoints' of method 'checkArtifact' must not be null";
        ArchitecturalViewArchitectureCheck.checkAssignmentMode(artifact, false);
        THashMap toArtifactToParserDependencies = new THashMap();
        for (ProgrammingElementAggregatingNode programmingElementAggregatingNode : artifact.getChildren(ArtifactNode.EXCLUDE_ARTIFACT_NODES, ProgrammingElementAggregatingNode.class)) {
            if (programmingElementAggregatingNode.isExternal()) continue;
            ArchitecturalViewArchitectureCheck.collectToArtifacts(representation, artifact, programmingElementAggregatingNode, (Map<ArtifactNode, List<ParserDependency>>)toArtifactToParserDependencies, endPoints);
        }
        for (Map.Entry entry : toArtifactToParserDependencies.entrySet()) {
            ArchitecturalViewNode currentTo;
            ArtifactNode nextToArtifact = (ArtifactNode)entry.getKey();
            List nextParserDependencies = (List)entry.getValue();
            String violationMessage = ArchitecturalViewArchitectureCheck.checkArtifactDependency(artifact, nextToArtifact);
            if (violationMessage != null) {
                if (!representation.addArchitectureViolation(nextParserDependencies, violationMessage)) continue;
                ArchitecturalViewNode current = artifact;
                while (current != null && !current.hasViolation()) {
                    current.setHasViolation(true);
                    current = current.getNodeParent();
                }
                for (ParserDependency nextParserDependency : nextParserDependencies) {
                    ProgrammingElement nextTo = nextParserDependency.getTo();
                    ArchitecturalViewNode nextToLeafNode = representation.getLeafNode(nextTo);
                    assert (nextToLeafNode != null) : "'nextToLeafNode' of method 'checkArtifact' must not be null";
                    currentTo = nextToLeafNode;
                    while (currentTo != null && !currentTo.hasIncomingViolation()) {
                        currentTo.setHasIncomingViolation(true);
                        currentTo = currentTo.getNodeParent();
                    }
                }
                continue;
            }
            if (!nextToArtifact.hasHiddenElements()) continue;
            for (ParserDependency next : nextParserDependencies) {
                ArchitecturalViewNode nextToLeafNode = representation.getLeafNode(next.getTo());
                assert (nextToLeafNode != null) : "Parameter 'nextToLeafNode' of method 'checkArtifact' must not be null";
                if (!nextToLeafNode.isHidden() || !representation.addArchitectureViolation(Collections.singletonList(next), String.format("'%s' may not be accessed because it is <hidden>", nextToLeafNode.getName()))) continue;
                ArchitecturalViewNode nextFromLeafNode = representation.getLeafNode(next.getFrom());
                assert (nextFromLeafNode != null) : "Parameter 'nextFromLeafNode' of method 'checkArtifact' must not be null";
                ArchitecturalViewNode currentFrom = nextFromLeafNode;
                while (currentFrom != null && !currentFrom.hasViolation()) {
                    currentFrom.setHasViolation(true);
                    currentFrom = currentFrom.getNodeParent();
                }
                currentTo = nextToLeafNode;
                while (currentTo != null && !currentTo.hasIncomingViolation()) {
                    currentTo.setHasIncomingViolation(true);
                    currentTo = currentTo.getNodeParent();
                }
            }
        }
        artifact.getChildren(ArtifactNode.class).forEach(c -> ArchitecturalViewArchitectureCheck.checkArtifact(representation, c, endPoints));
    }

    private static void checkInArchitectureModellingOperation(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'checkInArchitectureModellingOperation' must not be null";
        representation.clearDependencyInfo(false);
        List<ArtifactNode> topLevelArtifactNodes = representation.getChildren(ArtifactNode.class);
        if (!topLevelArtifactNodes.isEmpty()) {
            LOGGER.debug("Reset artifacts in modelling mode");
            ResetArchitectureViolationsVisitor visitor = new ResetArchitectureViolationsVisitor();
            topLevelArtifactNodes.forEach(a -> a.accept(visitor));
            LOGGER.debug("Check artifacts in modelling mode");
            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
            topLevelArtifactNodes.forEach(a -> ArchitecturalViewArchitectureCheck.checkArtifact(representation, a, endPoints));
        }
    }

    private static void checkArchitectureViolationsInNonArchitectureModellingOperation(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'checkArchitectureViolationsInNonArchitectureModellingOperation' must not be null";
        ArchitecturalViewArchitectureIssueProcessor processor = new ArchitecturalViewArchitectureIssueProcessor(representation);
        processor.process(representation.getCurrentModel(), representation.getBasedOnArchitectureFile(), representation.getStructureMode().isLogical(), representation.getRepresentationInfo());
    }

    static void check(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        LOGGER.debug("Check architecture");
        switch (representation.getOperationMode()) {
            case ARCHITECTURAL_MODELLING_LOGICAL: 
            case ARCHITECTURAL_MODELLING_PHYSICAL: {
                ArchitecturalViewArchitectureCheck.checkInArchitectureModellingOperation(representation);
                break;
            }
            case SYSTEM_EXPLORATION_LOGICAL: 
            case SYSTEM_EXPLORATION_PHYSICAL: 
            case ARCHITECTURE_EXPLORATION_LOGICAL: 
            case ARCHITECTURE_EXPLORATION_PHYSICAL: {
                ArchitecturalViewArchitectureCheck.checkArchitectureViolationsInNonArchitectureModellingOperation(representation);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)representation.getOperationMode());
                break;
            }
        }
        LOGGER.debug("Check architecture done");
    }

    static class ResetArchitectureViolationsVisitor
    extends ArchitecturalViewVisitor
    implements ArchitecturalViewNode.IVisitor {
        ResetArchitectureViolationsVisitor() {
        }

        @Override
        public final void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            element.setHasViolation(false);
            element.setHasIncomingViolation(false);
            element.setHasDeprecation(false);
            super.visitArchitecturalViewElement(element);
        }
    }
}

