/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.BasicSystemInfoDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.CycleGroupIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.DeleteRefactoringDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.DependencyIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.DuplicateCodeBlockIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.FixResolutionDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.IgnoreResolutionDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.LinedBasedIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.MetricDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.MoveRefactoringDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.MoveRenameRefactoringDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.NamedElementIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.RenameRefactoringDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.ThresholdIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.ToDoResolutionDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.WorkspaceDiffProcessor;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IReportExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssuesDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.WorkspaceDiff;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DiffProcess {
    private final SoftwareSystem m_softwareSystem;
    private final Set<SonargraphFeature> m_availableFeatures;

    public DiffProcess(SoftwareSystem softwareSystem, Set<SonargraphFeature> availableFeatures) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'DiffProcessingExecution' must not be null";
        assert (availableFeatures != null && !availableFeatures.isEmpty()) : "Parameter 'availableFeatures' of method 'DiffProcessingExecution' must not be empty";
        this.m_softwareSystem = softwareSystem;
        this.m_availableFeatures = availableFeatures;
    }

    public void execute(IWorkerContext workerContext, AnalyzerResult analyzerResult, ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, BaselineType baselineType, TFile baselineReport) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'execute' must not be null";
        assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'execute' must not be null";
        assert (baselineSystem != null) : "Parameter 'baselineSystem' of method 'execute' must not be null";
        assert (baselineSystemInfoProcessor != null) : "Parameter 'baselineSystemInfoProcessor' of method 'execute' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'execute' must not be null";
        assert (baselineReport != null) : "Parameter 'baselineReport' of method 'execute' must not be null";
        IReportExtension reportExtension = this.m_softwareSystem.getExtension(IReportExtension.class);
        IReport currentSystemReport = reportExtension.createReportObjectForBasicSystemInfo(workerContext);
        workerContext.working("Create basic system diff", true);
        SoftwareSystemDiff systemDiff = new SoftwareSystemDiff(analyzerResult, baselineReport, baselineSystem.getTimestamp(), baselineSystem.getContextInfo(), baselineType);
        BasicSystemInfoDiffProcessor basicDiffProcessor = new BasicSystemInfoDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem, currentSystemReport);
        basicDiffProcessor.process(systemDiff);
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        MetricsDiff metricDiff = new MetricsDiff(systemDiff);
        systemDiff.addChild(metricDiff);
        MetricDiffProcessor metricDiffProcessor = new MetricDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem, currentSystemReport);
        metricDiffProcessor.process(metricDiff);
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        WorkspaceDiff workspaceDiff = new WorkspaceDiff((NamedElement)systemDiff, this.m_softwareSystem.getUniqueExistingChild(Workspace.class));
        systemDiff.addChild(workspaceDiff);
        WorkspaceDiffProcessor workspaceDiffProcessor = new WorkspaceDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        workspaceDiffProcessor.process(workspaceDiff);
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        workerContext.working("Create issues diff", true);
        workerContext.beginBlockOfWork(6);
        IssuesDiff issuesDiff = new IssuesDiff(systemDiff);
        systemDiff.addChild(issuesDiff);
        THashMap namedElementToFqNameCache = new THashMap();
        IIssueFilter issueFilter = new IIssueFilter(){

            @Override
            public boolean accept(Issue issue) {
                if (!$assertionsDisabled && issue == null) {
                    throw new AssertionError((Object)"Parameter 'issue' of method 'accept' must not be null");
                }
                return !CoreIssueId.QUALITY_GATE_NOT_CHECKED_AGAINST_BASELINE.equals(issue.getId());
            }
        };
        LinkedHashSet<Issue> allCurrentIssues = new LinkedHashSet<Issue>(this.m_softwareSystem.getCurrentModel().getIssueList(issueFilter).getIssues());
        LinkedHashSet<IIssue> allBaselineIssues = new LinkedHashSet<IIssue>(baselineSystemInfoProcessor.getIssues(i -> !CoreIssueId.QUALITY_GATE_NOT_CHECKED_AGAINST_BASELINE.getStandardName().equals(i.getName())));
        LinedBasedIssueDiffProcessor lineBasedIssueDiffProcessor = new LinedBasedIssueDiffProcessor(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, this.m_softwareSystem, allCurrentIssues, (Map<NamedElement, String>)namedElementToFqNameCache);
        lineBasedIssueDiffProcessor.process(issuesDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        NamedElementIssueDiffProcessor namedElementIssueDiffProcessor = new NamedElementIssueDiffProcessor(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, this.m_softwareSystem, allCurrentIssues, (Map<NamedElement, String>)namedElementToFqNameCache);
        namedElementIssueDiffProcessor.process(issuesDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        DependencyIssueDiffProcessor dependencyIssueDiffProcessor = new DependencyIssueDiffProcessor(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, this.m_softwareSystem, allCurrentIssues, (Map<NamedElement, String>)namedElementToFqNameCache);
        dependencyIssueDiffProcessor.process(issuesDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        ThresholdIssueDiffProcessor thresholdDiffProcessor = new ThresholdIssueDiffProcessor(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, this.m_softwareSystem, allCurrentIssues, (Map<NamedElement, String>)namedElementToFqNameCache);
        thresholdDiffProcessor.process(issuesDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        CycleGroupIssueDiffProcessor cycleGroupIssueDiffProcessor = new CycleGroupIssueDiffProcessor(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, this.m_softwareSystem, allCurrentIssues, (Map<NamedElement, String>)namedElementToFqNameCache);
        cycleGroupIssueDiffProcessor.process(issuesDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        if (this.m_availableFeatures.contains((Object)SonargraphFeature.DUPLICATE_CODE)) {
            DuplicateCodeBlockIssueDiffProcessor duplicateIssueDiffProcessor = new DuplicateCodeBlockIssueDiffProcessor(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, this.m_softwareSystem, allCurrentIssues, (Map<NamedElement, String>)namedElementToFqNameCache);
            duplicateIssueDiffProcessor.process(issuesDiff);
        }
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        workerContext.endStep();
        workerContext.working("Create resolutions diff", true);
        if (this.m_availableFeatures.contains((Object)SonargraphFeature.VIRTUAL_MODELS)) {
            this.createResolutionsDiff(workerContext, baselineSystem, baselineSystemInfoProcessor, systemDiff);
            if (workerContext.hasBeenCanceled()) {
                return;
            }
        }
        workerContext.endStep();
        analyzerResult.addChild(systemDiff);
    }

    private void createResolutionsDiff(IWorkerContext workerContext, ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystemDiff systemDiff) {
        workerContext.beginBlockOfWork(7);
        ResolutionsDiff resolutionsDiff = new ResolutionsDiff(systemDiff);
        systemDiff.addChild(resolutionsDiff);
        IgnoreResolutionDiffProcessor ignoreResolutionProcessor = new IgnoreResolutionDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        ignoreResolutionProcessor.process(resolutionsDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        FixResolutionDiffProcessor fixResolutionProcessor = new FixResolutionDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        fixResolutionProcessor.process(resolutionsDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        ToDoResolutionDiffProcessor todoResolutionProcessor = new ToDoResolutionDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        todoResolutionProcessor.process(resolutionsDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        DeleteRefactoringDiffProcessor deleteRefactoringProcessor = new DeleteRefactoringDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        deleteRefactoringProcessor.process(resolutionsDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        MoveRefactoringDiffProcessor moveRefactoringProcessor = new MoveRefactoringDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        moveRefactoringProcessor.process(resolutionsDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        RenameRefactoringDiffProcessor renameRefactoringProcessor = new RenameRefactoringDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        renameRefactoringProcessor.process(resolutionsDiff);
        workerContext.workItemCompleted();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        MoveRenameRefactoringDiffProcessor moveRenameRefactoringProcessor = new MoveRenameRefactoringDiffProcessor(baselineSystem, baselineSystemInfoProcessor, this.m_softwareSystem);
        moveRenameRefactoringProcessor.process(resolutionsDiff);
        workerContext.workItemCompleted();
    }

    public static IDiffElement findDiffFor(SoftwareSystemDiff diff, Element element) {
        assert (diff != null) : "Parameter 'diff' of method 'findDiffFor' must not be null";
        assert (element != null) : "Parameter 'element' of method 'findDiffFor' must not be null";
        if (element instanceof Module || element instanceof RootDirectoryPath) {
            return DiffProcess.handleRootOrModule(diff, element);
        }
        if (element instanceof Issue) {
            return DiffProcess.handleIssue(diff, element);
        }
        if (element instanceof DuplicateCodeBlockOccurrence) {
            return DiffProcess.handleDuplicateCodeBlockOccurrence(diff, element);
        }
        if (element instanceof DuplicateCodeBlock) {
            return DiffProcess.handleDuplicateCodeBlock(diff, element);
        }
        if (element instanceof Resolution) {
            return DiffProcess.handleResolution(diff, element);
        }
        if (element instanceof CycleGroup) {
            return DiffProcess.handleCycleGroup(diff, element);
        }
        if (element instanceof NamedElementProxy) {
            return DiffProcess.handleCyclicElement(diff, element);
        }
        return null;
    }

    private static IDiffElement handleDuplicateCodeBlock(SoftwareSystemDiff diff, Element element) {
        IssuesDiff issuesDiff = diff.getUniqueExistingChild(IssuesDiff.class);
        for (DuplicateCodeBlockIssueDiff next : issuesDiff.getChildren(DuplicateCodeBlockIssueDiff.class)) {
            if (next.getCurrent() == null || ((DuplicateCodeBlockIssue)next.getCurrent()).getAffectedElement() != element) continue;
            return next;
        }
        return null;
    }

    private static IDiffElement handleResolution(SoftwareSystemDiff diff, Element element) {
        ResolutionsDiff resolutionsDiff = diff.getUniqueExistingChild(ResolutionsDiff.class);
        for (ResolutionDefinitionDiff next : resolutionsDiff.getChildren(ResolutionDefinitionDiff.class)) {
            if (next.getCurrent() != element) continue;
            return next;
        }
        return null;
    }

    private static IDiffElement handleCycleGroup(SoftwareSystemDiff diff, Element element) {
        IssuesDiff issuesDiff = diff.getUniqueExistingChild(IssuesDiff.class);
        for (CycleGroupIssueDiff next : issuesDiff.getChildren(CycleGroupIssueDiff.class)) {
            if (next.getCurrent() == null || ((CycleGroupIssue)next.getCurrent()).getAffectedElement() != element) continue;
            return next;
        }
        return null;
    }

    private static IDiffElement handleCyclicElement(SoftwareSystemDiff diff, Element element) {
        IssuesDiff issuesDiff = diff.getUniqueExistingChild(IssuesDiff.class);
        NamedElement proxiedElement = ((NamedElementProxy)element).getElement();
        for (CycleGroupIssueDiff next : issuesDiff.getChildren(CycleGroupIssueDiff.class)) {
            for (CyclicElementDiff nextCyclicDiff : next.getChildren(CyclicElementDiff.class)) {
                if (nextCyclicDiff.getCurrent() != proxiedElement) continue;
                return nextCyclicDiff;
            }
        }
        return null;
    }

    private static IDiffElement handleDuplicateCodeBlockOccurrence(SoftwareSystemDiff diff, Element element) {
        DuplicateCodeBlockOccurrence occ = (DuplicateCodeBlockOccurrence)element;
        IssuesDiff issuesDiff = diff.getUniqueExistingChild(IssuesDiff.class);
        for (DuplicateCodeBlockIssueDiff next : issuesDiff.getChildren(DuplicateCodeBlockIssueDiff.class)) {
            if (next.getCurrent() == null || ((DuplicateCodeBlockIssue)next.getCurrent()).getAffectedElement() != occ.getParent()) continue;
            for (DuplicateCodeBlockOccurrenceDiff occDiff : next.getChildren(DuplicateCodeBlockOccurrenceDiff.class)) {
                if (occDiff.getCurrent() != element) continue;
                return occDiff;
            }
        }
        return null;
    }

    private static IDiffElement handleRootOrModule(SoftwareSystemDiff diff, Element element) {
        WorkspaceDiff workspaceDiff = diff.getUniqueExistingChild(WorkspaceDiff.class);
        for (IDiffElement next : workspaceDiff.getChildrenRecursively(IDiffElement.class, new Class[0])) {
            if (next.getCurrentElement() != element) continue;
            return next;
        }
        return null;
    }

    private static IDiffElement handleIssue(SoftwareSystemDiff diff, Element element) {
        IssuesDiff issuesDiff = diff.getUniqueExistingChild(IssuesDiff.class);
        for (IIssueDiff next : issuesDiff.getChildren(IIssueDiff.class)) {
            if (next.getCurrent() != element) continue;
            return next;
        }
        return null;
    }
}

