/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.duplicate;

import com.hello2morrow.sonargraph.core.controller.system.analysis.SizeComputationUtility;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DuplicateCodeMetricsAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.DUPLICATE_CODE_METRICS;
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateCodeMetricsJob.class);
    private final IMetricDescriptor m_numberOfDuplicatedLines;
    private final IMetricDescriptor m_numberOfDuplicateBlocks;
    private final IMetricDescriptor m_numberOfDuplicateBlocksIgnored;
    private final IMetricDescriptor m_numberOfDuplicateBlocksFixed;
    private final IMetricDescriptor m_redundancy;
    private final IMetricDescriptor m_redundancyIgnored;
    private final IMetricDescriptor m_redundancyFixed;

    public DuplicateCodeMetricsAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider metricProvider = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_numberOfDuplicatedLines = this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_DUPLICATED_LINES, CoreMetricLevel.SYSTEM, null);
        this.m_numberOfDuplicateBlocks = this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_DUPLICATES, CoreMetricLevel.SYSTEM, null);
        this.m_numberOfDuplicateBlocksIgnored = this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_IGNORED_DUPLICATES, CoreMetricLevel.SYSTEM, null);
        this.m_numberOfDuplicateBlocksFixed = this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_DUPLICATES_FIXED, CoreMetricLevel.SYSTEM, null);
        this.m_redundancy = this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_REDUNDANCY, CoreMetricLevel.SYSTEM, null);
        this.m_redundancyIgnored = this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_REDUNDANCY_IGNORED, CoreMetricLevel.SYSTEM, null);
        this.m_redundancyFixed = this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_REDUNDANCY_FIXED, CoreMetricLevel.SYSTEM, null);
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        if (result.getMetricValue(this.getSoftwareSystem(), this.m_redundancy) == null) {
            throw new RestoreException("Missing expected metric value for redundancy.");
        }
        super.resultSuccessfullyRestored(result);
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        DuplicateCodeMetricsJob job = new DuplicateCodeMetricsJob(this.getGroup(), result, this.getController(), this.getRequiredResults());
        job.start();
    }

    private final class DuplicateCodeMetricsJob
    extends AnalyzerJob {
        private DuplicateCodeMetricsJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Collection<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void internalRun() {
            float redundancyFixed;
            float redundancyIgnored;
            float redundancy;
            List<AnalyzerResult> requiredResults = this.getRequiredResults();
            assert (requiredResults.size() == 1) : "Only 1 required result expected";
            AnalyzerResult requiredResult = requiredResults.get(0);
            VirtualModel virtualModel = DuplicateCodeMetricsAdapter.this.getCurrentModel();
            int duplicates = 0;
            int duplicatesIgnored = 0;
            int duplicatesFixed = 0;
            int duplicatedLines = 0;
            THashMap sourceFileToOccurrences = new THashMap();
            THashMap sourceFileToIgnoredOccurrences = new THashMap();
            THashMap sourceFileToToBeFixedOccurrences = new THashMap();
            for (DuplicateCodeBlock block : requiredResult.getChildren(DuplicateCodeBlock.class)) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                Issue issue = virtualModel.getElementIssue(block, CoreIssueId.DUPLICATE_CODE_BLOCK);
                assert (issue != null) : "Missing issue for duplicate code block: " + String.valueOf(block);
                ++duplicates;
                this.collectOccurrences(block, (Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToOccurrences);
                if (issue.isIgnored()) {
                    ++duplicatesIgnored;
                    this.collectOccurrences(block, (Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToIgnoredOccurrences);
                } else if (issue.getResolution() != null) {
                    ++duplicatesFixed;
                    this.collectOccurrences(block, (Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToToBeFixedOccurrences);
                }
                duplicatedLines += block.getDuplicatedLineCount();
            }
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            DuplicateCodeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, duplicatedLines, DuplicateCodeMetricsAdapter.this.m_numberOfDuplicatedLines);
            DuplicateCodeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, duplicates, DuplicateCodeMetricsAdapter.this.m_numberOfDuplicateBlocks);
            DuplicateCodeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, duplicatesIgnored, DuplicateCodeMetricsAdapter.this.m_numberOfDuplicateBlocksIgnored);
            DuplicateCodeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, duplicatesFixed, DuplicateCodeMetricsAdapter.this.m_numberOfDuplicateBlocksFixed);
            int linesOfCodeReferenceForRedundancy = this.calculateReferenceValueForRedundancy(softwareSystem);
            if (linesOfCodeReferenceForRedundancy > 0) {
                int totalLinesInvolvedInDuplicates = this.computeDuplicatedLines((Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToOccurrences);
                redundancy = this.computePercentage(totalLinesInvolvedInDuplicates, linesOfCodeReferenceForRedundancy);
                int totalLinesInvolvedInDuplicatesIgnored = this.computeDuplicatedLines((Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToIgnoredOccurrences);
                redundancyIgnored = this.computePercentage(totalLinesInvolvedInDuplicatesIgnored, linesOfCodeReferenceForRedundancy);
                int totalLinesInvolvedInDuplicatesFixed = this.computeDuplicatedLines((Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToToBeFixedOccurrences);
                redundancyFixed = this.computePercentage(totalLinesInvolvedInDuplicatesFixed, linesOfCodeReferenceForRedundancy);
            } else {
                redundancy = 0.0f;
                redundancyIgnored = 0.0f;
                redundancyFixed = 0.0f;
            }
            DuplicateCodeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, Float.valueOf(redundancy), DuplicateCodeMetricsAdapter.this.m_redundancy);
            DuplicateCodeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, Float.valueOf(redundancyIgnored), DuplicateCodeMetricsAdapter.this.m_redundancyIgnored);
            DuplicateCodeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, Float.valueOf(redundancyFixed), DuplicateCodeMetricsAdapter.this.m_redundancyFixed);
        }

        private int computeDuplicatedLines(Map<SourceFile, List<DuplicateCodeBlockOccurrence>> sourceFileToOccurrences) {
            assert (sourceFileToOccurrences != null) : "Parameter 'sourceFileToOccurrences' of method 'computeDuplicatedLines' must not be null";
            int duplicatedLines = 0;
            for (Map.Entry<SourceFile, List<DuplicateCodeBlockOccurrence>> next : sourceFileToOccurrences.entrySet()) {
                SourceFile source = next.getKey();
                List<DuplicateCodeBlockOccurrence> occurrences = next.getValue();
                if (occurrences.size() == 1) {
                    duplicatedLines += occurrences.get(0).getBlockSize();
                    continue;
                }
                int totalLines = source.getTotalLines();
                if (totalLines <= 0) {
                    LOGGER.warn("Number of total lines is {} for source {}", (Object)totalLines, (Object)source.getFullyQualifiedName());
                    continue;
                }
                BitSet lines = new BitSet(totalLines);
                for (DuplicateCodeBlockOccurrence nextOcc : occurrences) {
                    lines.set(nextOcc.getBlockBegin() - 1, nextOcc.getBlockEnd() - 1, true);
                }
                duplicatedLines += lines.cardinality();
            }
            return duplicatedLines;
        }

        private void collectOccurrences(DuplicateCodeBlock block, Map<SourceFile, List<DuplicateCodeBlockOccurrence>> sourceFileToOccurrences) {
            assert (block != null) : "Parameter 'block' of method 'collectOccurrences' must not be null";
            assert (sourceFileToOccurrences != null) : "Parameter 'sourceFileToOccurrences' of method 'collectOccurrences' must not be null";
            for (DuplicateCodeBlockOccurrence next : block.getChildren(DuplicateCodeBlockOccurrence.class)) {
                SourceFile source = next.getSourceFile();
                List<DuplicateCodeBlockOccurrence> occurrences = sourceFileToOccurrences.get(source);
                if (occurrences == null) {
                    occurrences = new ArrayList<DuplicateCodeBlockOccurrence>(2);
                    sourceFileToOccurrences.put(source, occurrences);
                }
                occurrences.add(next);
            }
        }

        private float computePercentage(int value, int reference) {
            assert (reference > 0) : "reference must be > 0, but is " + reference;
            return (float)value * 100.0f / (float)reference;
        }

        private int calculateReferenceValueForRedundancy(SoftwareSystem softwareSystem) {
            THashSet fullyAnalyzedSources = new THashSet();
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                for (IComponent nextComponent : nextModule.getChildrenRecursively(IComponent.class, IComponent.class)) {
                    if (nextComponent.isExcluded() || nextComponent.ignoreIssues()) continue;
                    fullyAnalyzedSources.addAll(SizeComputationUtility.getInternalNotExcludedSourceFiles(nextComponent));
                }
            }
            int totalLines = 0;
            int commentLines = 0;
            int codeCommentLines = 0;
            for (SourceFile next : fullyAnalyzedSources) {
                totalLines += next.getTotalLines();
                commentLines += next.getCommentLines();
                codeCommentLines += next.getCodeCommentLines();
            }
            int linesOfCodeReferenceForRedundancy = totalLines - commentLines + codeCommentLines;
            return linesOfCodeReferenceForRedundancy;
        }
    }
}

