/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.architecture;

import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import java.util.EnumSet;
import java.util.Set;

public final class AccessResult {
    private final boolean m_isPossible;
    private final EnumSet<CoreParserDependencyType> m_dependencyRestrictions;

    public AccessResult(boolean possible) {
        this.m_isPossible = possible;
        this.m_dependencyRestrictions = EnumSet.noneOf(CoreParserDependencyType.class);
    }

    public AccessResult(Set<CoreParserDependencyType> allowedDependencies) {
        this.m_isPossible = true;
        assert (allowedDependencies != null && !allowedDependencies.isEmpty()) : "Parameter 'dependencyRestrictions' of method 'CheckResult' must not be empty";
        this.m_dependencyRestrictions = EnumSet.allOf(CoreParserDependencyType.class);
        this.m_dependencyRestrictions.removeAll(allowedDependencies);
    }

    public boolean isPossible() {
        return this.m_isPossible;
    }

    public EnumSet<CoreParserDependencyType> getDependencyRestrictions() {
        return EnumSet.copyOf(this.m_dependencyRestrictions);
    }
}

