/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.NotificationExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.system.Notification;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.set.hash.THashSet;
import java.util.Set;

final class SizeCheck {
    private static final float THRESHOLD_LANGUAGE_SIZE = 95.0f;
    private final LanguageProviderAccessor m_accessor;
    private final ILicenseProvider m_licenseProvider;
    private final NotificationExtension m_notificationExtension;

    SizeCheck(LanguageProviderAccessor accessor, ILicenseProvider licenseProvider, NotificationExtension notificationExtension) {
        assert (accessor != null) : "Parameter 'accessor' of method 'SizeCheck' must not be null";
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'SizeCheck' must not be null";
        assert (notificationExtension != null) : "Parameter 'notificationExtension' of method 'SizeCheck' must not be null";
        this.m_accessor = accessor;
        this.m_licenseProvider = licenseProvider;
        this.m_notificationExtension = notificationExtension;
    }

    void performSizeCheck(SoftwareSystem softwareSystem, IFilePathListener filePathListener, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'performSizeCheck' must not be null";
        assert (result != null) : "Parameter 'result' of method 'performSizeCheck' must not be null";
        this.m_notificationExtension.clear(Notification.Source.MODEL);
        this.m_licenseProvider.resetAdditionalLicenseInfo();
        THashSet cleared = filePathListener != null ? new THashSet() : null;
        for (LanguageProvider nextLanguageProvider : this.m_accessor.getLanguageProviders(softwareSystem.getUsedLanguages())) {
            Language nextLanguage = nextLanguageProvider.getLanguage();
            int licensedSize = this.m_licenseProvider.getLicensedSize(nextLanguage);
            if (licensedSize == 0) continue;
            int usedSize = this.m_accessor.getUsedSize(nextLanguage);
            if (usedSize > licensedSize) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.USED_LANGUAGE_SIZE_IS_GREATER_THAN_LICENSED_LIMIT, CoreResourceProviderAdapter.getInstance().getString("core.message.license.sizeExceeded", new Object[]{usedSize, licensedSize, nextLanguage.getPresentationName(), nextLanguage.getSizeUnit()}), new Object[0]);
                nextLanguageProvider.clear(softwareSystem, false);
                if (cleared == null) continue;
                cleared.add(nextLanguage);
                continue;
            }
            float percentage = NumberUtility.getPercentage((int)usedSize, (int)licensedSize);
            if (!(percentage >= 95.0f)) continue;
            String msg = CoreResourceProviderAdapter.getInstance().getString("core.message.license.sizeIsNearExhausted", new Object[]{Float.valueOf(percentage), nextLanguage.getSizeUnit()});
            this.m_notificationExtension.add(SoftwareSystemMessageCause.USED_LANGUAGE_SIZE_IS_APPROACHING_LICENSED_LIMIT.getPresentationName() + "." + StringUtility.LINE_SEPARATOR + msg, Severity.INFO, Notification.Source.MODEL, false);
            this.m_licenseProvider.addAdditionalLicenseInfo(SoftwareSystemMessageCause.USED_LANGUAGE_SIZE_IS_APPROACHING_LICENSED_LIMIT, msg);
        }
        if (cleared != null && !cleared.isEmpty()) {
            assert (filePathListener != null) : "'listener' of method 'performSizeCheck' must not be null";
            filePathListener.filesCleared((Set<Language>)cleared);
        }
    }
}

