/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IPluginConfigurationFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.AbstractUndoRedoProvider;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

final class PluginConfigurationUndoRedoProvider
extends AbstractUndoRedoProvider {
    private final IPluginConfigurationFileProvider m_provider;

    PluginConfigurationUndoRedoProvider(IPluginConfigurationFileProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'PluginConfigurationUndoRedoProvider' must not be null";
        this.m_provider = provider;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(PluginConfigurationFile.class);
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be null";
        return AnalyzerExecutionInfo.groups(Collections.singleton(AnalyzerGroup.PLUGINS));
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null && file instanceof PluginConfigurationFile) : "Unexpected class in method 'writeModifiableFileToStream': " + String.valueOf(file);
        assert (outputStream != null) : "Parameter 'outputStream' of method 'writeModifiableFileToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        this.m_provider.save((PluginConfigurationFile)file, outputStream, result);
    }

    @Override
    public OperationResultWithOutcome<? extends IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) throws IOException {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        String identifyingPath = dto.getCurrentStateFileEntry().getIdentifyingPath();
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restoring plugin configuration file '" + identifyingPath + "' from stream");
        PluginConfigurationFile toBeRestored = this.m_provider.findByIdentifyingPath(identifyingPath);
        assert (toBeRestored != null) : "Parameter 'toBeRestored' of method 'restoreModifiableFileFromStream' must not be null";
        this.m_provider.restoreFile(toBeRestored, inputStream, determinedModifications, (OperationResultWithOutcome<PluginConfigurationFile>)result);
        return result;
    }
}

