/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.plugin;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IPluginConfigurationExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import java.util.Map;

public final class ConfigurePluginCommand
extends SoftwareSystemBasedCommand<IConfigurePluginInteraction> {
    public ConfigurePluginCommand(ISoftwareSystemProvider provider, IConfigurePluginInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CONFIGURE_PLUGIN;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        ConfigurePluginData data = new ConfigurePluginData();
        if (((IConfigurePluginInteraction)this.getInteraction()).collect(data)) {
            OperationResult result = this.getSoftwareSystem().getExtension(IPluginConfigurationExtension.class).configurePlugin(workerContext, data.getPlugin(), data.getValues());
            ((IConfigurePluginInteraction)this.getInteraction()).processResult(result);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this == obj;
    }

    public static final class ConfigurePluginData
    implements ICommandInteractionData {
        private SonargraphPlugin m_plugin;
        private Map<SonargraphPluginAttribute, Object> m_values;

        ConfigurePluginData() {
        }

        public void setData(SonargraphPlugin plugin, Map<SonargraphPluginAttribute, Object> values) {
            assert (plugin != null) : "Parameter 'plugin' of method 'setPlugin' must not be null";
            assert (values != null) : "Parameter 'values' of method 'setData' must not be null";
            this.m_plugin = plugin;
            this.m_values = values;
        }

        SonargraphPlugin getPlugin() {
            assert (this.m_plugin != null) : "'m_plugin' of method 'getPlugin' must not be null";
            return this.m_plugin;
        }

        Map<SonargraphPluginAttribute, Object> getValues() {
            assert (this.m_values != null) : "'m_values' of method 'getValues' must not be null";
            return this.m_values;
        }
    }

    public static interface IConfigurePluginInteraction
    extends ICommandInteraction {
        public boolean collect(ConfigurePluginData var1);

        public void processResult(OperationResult var1);
    }
}

