/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class RenameElementCommand
extends ArchitecturalViewCommand<IRenameElementInteraction> {
    public RenameElementCommand(ISoftwareSystemProvider provider, IRenameElementInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.RENAME_ARCHITECTURAL_VIEW_ELEMENT;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        RenameElementData data = new RenameElementData();
        if (!((IRenameElementInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.renameElement(workerContext, data.getElement(), data.getName());
        ((IRenameElementInteraction)this.getInteraction()).processRenameElementResult(result);
    }

    public static interface IRenameElementInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(RenameElementData var1);

        public void processRenameElementResult(OperationResult var1);
    }

    public static final class RenameElementData
    implements IArchitecturalViewCommandInteractionData {
        private ArchitecturalViewElement m_element;
        private String m_name;

        RenameElementData() {
        }

        public final void set(ArchitecturalViewElement element, String name) {
            assert (element != null) : "Parameter 'element' of method 'setElement' must not be null";
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'set' must not be empty";
            this.m_element = element;
            this.m_name = name;
        }

        final ArchitecturalViewElement getElement() {
            assert (this.m_element != null) : "'m_element' of method 'getElement' must not be null";
            return this.m_element;
        }

        final String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "Parameter 'm_name' of method 'getName' must not be empty";
            return this.m_name;
        }
    }
}

