/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ProgressInfo;
import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.ResendFailedUploadsRequest;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.ServiceResponseWithOutcome;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.api.SystemInfo;
import com.hello2morrow.sonargraph.build.service.impl.CreateReportInteraction;
import com.hello2morrow.sonargraph.build.service.impl.IssueFinder;
import com.hello2morrow.sonargraph.build.service.impl.ReportUploader;
import com.hello2morrow.sonargraph.build.service.impl.SonargraphBuildReporter;
import com.hello2morrow.sonargraph.build.service.impl.SonargraphBuildSystemOpener;
import com.hello2morrow.sonargraph.build.service.impl.SonargraphBuildSystemRefresh;
import com.hello2morrow.sonargraph.build.service.impl.SonargraphEnterpriseReportUploader;
import com.hello2morrow.sonargraph.build.ui.BuildUserInterfaceAdapter;
import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.system.ApplyInstallationSpecificParametersCommand;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateDynamicSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateReportCommand;
import com.hello2morrow.sonargraph.core.command.system.OpenSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSnapshotCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SetModelCommand;
import com.hello2morrow.sonargraph.core.command.system.diff.SetBaselineCommand;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.LastScriptRunnerExecutionStatus;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.ISnapshotProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphBuildImpl
implements ISonargraphBuild {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphBuildImpl.class);
    private static final String SCRIPT_RUNNER_STATUS_MESSAGE_FORMAT = "%d of %d configured automated script executions have been terminated successfully.";
    private final ISoftwareSystemProvider m_systemProvider;
    private final ProgressInfo m_progressInfo;

    public SonargraphBuildImpl(ISoftwareSystemProvider systemProvider, ProgressInfo progressInfo) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'SonargraphBuildImpl' must not be null";
        assert (progressInfo != null) : "Parameter 'progressInfo' of method 'SonargraphBuildImpl' must not be null";
        this.m_systemProvider = systemProvider;
        this.m_progressInfo = progressInfo;
    }

    public ISonargraphBuild.Version getVersion() {
        Version v = this.m_systemProvider.getInstallation().getVersion();
        return new ISonargraphBuild.Version(v.getMajor(), v.getMinor(), v.getIncrement(), v.getBuild());
    }

    public ServiceResponse open(File systemDirectory) {
        return this.open(systemDirectory, null, null, null);
    }

    public ServiceResponse open(File systemDirectory, String workspaceProfile) {
        return this.open(systemDirectory, null, workspaceProfile, null);
    }

    public ServiceResponse open(File systemDirectory, String workspaceProfile, File qualityModelFile) {
        return this.open(systemDirectory, null, workspaceProfile, qualityModelFile);
    }

    public ServiceResponse open(File systemDirectory, SystemInfo systemInfo, String workspaceProfile, File qualityModelFile) {
        return this.open(systemDirectory, systemInfo, workspaceProfile, qualityModelFile, Collections.emptyMap());
    }

    private String getAbsolutePath(File file) {
        assert (file != null) : "Parameter 'file' of method 'getAbsolutePath' must not be null";
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            TFile tfile = new TFile(file);
            return tfile.getNormalizedAbsolutePath();
        }
    }

    private void logDynamicSystemInfo(DynamicSystemInfo dynamicSystem, StringBuilder info) {
        assert (dynamicSystem != null) : "Parameter 'dynamicSystem' of method 'logDynamicSystemInfo' must not be null";
        assert (info != null) : "Parameter 'info' of method 'logDynamicSystemInfo' must not be null";
        info.append("\nUsing dynamic system info:");
        for (ModuleInfo nextModuleInfo : dynamicSystem.getModules()) {
            File nextToCheck;
            String nextPath;
            info.append("\nModule '").append(nextModuleInfo.getName() + "'");
            for (RootPathInfo nextRootPathInfo : nextModuleInfo.getStandardRootPaths()) {
                nextPath = nextRootPathInfo.getPath();
                nextToCheck = new File(nextPath);
                if (nextToCheck.exists()) {
                    if (nextToCheck.canRead()) {
                        info.append("\nStandard root path '").append(nextPath).append("'");
                        continue;
                    }
                    info.append("\nStandard root path <cannot be read> '").append(nextPath).append("'");
                    continue;
                }
                info.append("\nStandard root path <does not exist> '").append(nextPath).append("'");
            }
            for (RootPathInfo nextRootPathInfo : nextModuleInfo.getNonStandardRootPaths()) {
                nextPath = nextRootPathInfo.getPath();
                nextToCheck = new File(nextPath);
                if (nextToCheck.exists()) {
                    if (nextToCheck.canRead()) {
                        info.append("\nNon-standard root path '").append(nextPath).append("'");
                        continue;
                    }
                    info.append("\nNon-standard root path <cannot be read> '").append(nextPath).append("'");
                    continue;
                }
                info.append("\nNon-standard root path <does not exist> '").append(nextPath).append("'");
            }
        }
    }

    private void logSystemInfo(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "'softwareSystem' must not be null";
        if (LOGGER.isDebugEnabled()) {
            List modules = ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(Module.class);
            LOGGER.debug("Successfully opened system '" + softwareSystem.getAbsolutePath() + "' with " + modules.size() + " module(s)");
            for (Module nextModule : modules) {
                LOGGER.debug("Module '" + nextModule.getName() + "' [" + String.valueOf(nextModule.getLanguage()) + "]");
                for (RootDirectoryPath nextRoot : nextModule.getChildren(RootDirectoryPath.class)) {
                    LOGGER.debug("Root directory (" + nextRoot.getClass().getName() + ") " + (nextRoot.exists() ? "'" : "' <does not exist> ") + nextRoot.getIdentifyingPath() + "' [" + nextRoot.getAbsolutePath() + "]");
                }
            }
        }
    }

    public ServiceResponse open(File systemDirectory, SystemInfo systemInfo, String workspaceProfile, File qualityModelFile, final Map<String, String> instSpecificParameterMap) {
        DynamicSystemInfo dynamicSystem;
        if (systemDirectory == null) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Mandatory parameter 'systemDirectory' is missing");
        }
        if (!(systemDirectory.exists() && systemDirectory.isDirectory() && systemDirectory.canRead())) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Parameter 'systemDirectory' is not valid. Directory '" + systemDirectory.getAbsolutePath() + "' does not exist or is not accessible.");
        }
        if (systemInfo != null && workspaceProfile != null && !workspaceProfile.isEmpty()) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Only one of 'systemInfo' or 'workspaceProfile' may be specified (or both might be 'null').");
        }
        if (qualityModelFile != null) {
            if (!(qualityModelFile.getName().startsWith("Sonargraph:") || qualityModelFile.exists() && qualityModelFile.canRead())) {
                return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Parameter 'qualityModelFile' is not valid. Path '" + qualityModelFile.getAbsolutePath() + "' does not exist or is not accessible.");
            }
            String extension = FileUtility.getExtension((String)qualityModelFile.getName());
            if (!CoreFileType.QUALITY_MODEL.hasExtension(extension)) {
                return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Parameter 'qualityModelFile' has an invalid file extension '" + extension + "'. Must be one of '" + StringUtility.concat((char)',', (String[])CoreFileType.QUALITY_MODEL.getExtensions()) + "'");
            }
        }
        assert (systemDirectory != null) : "Parameter 'systemDir' of method 'open' must not be null";
        assert (systemDirectory.isDirectory() && systemDirectory.exists()) : "System directory '" + systemDirectory.getAbsolutePath() + "' does not exist!";
        if (systemInfo != null) {
            OperationResult convertResult = new OperationResult("Convert system info");
            dynamicSystem = SonargraphBuildSystemOpener.convertSystemInfo(CreateDynamicSystemCommand.getAdditionalInfoProviders((ISoftwareSystemProvider)this.m_systemProvider), systemInfo, convertResult);
            if (convertResult.isFailure()) {
                return this.createResponseObject(convertResult, null);
            }
        } else {
            dynamicSystem = null;
        }
        if (!instSpecificParameterMap.isEmpty()) {
            final OperationResult applyInstParametersResult = new OperationResult("Apply installation specific parameters");
            ApplyInstallationSpecificParametersCommand applyInstParameters = new ApplyInstallationSpecificParametersCommand(this.m_systemProvider, new ApplyInstallationSpecificParametersCommand.IInteraction(){

                public boolean collect(ApplyInstallationSpecificParametersCommand.InteractionData data) {
                    data.setInstSpecificParameters(instSpecificParameterMap);
                    return true;
                }

                public void processResult(OperationResult result) {
                    applyInstParametersResult.addMessagesFromAndSetOutcome(result);
                }
            });
            BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)applyInstParameters, (IWorkerContext)DefaultWorkerContext.INSTANCE);
            if (applyInstParametersResult.isFailure()) {
                return this.createResponseObject(applyInstParametersResult, null);
            }
        }
        StringBuilder openMessage = new StringBuilder("Open software system from directory '").append(this.getAbsolutePath(systemDirectory)).append("'");
        if (qualityModelFile != null) {
            openMessage.append("\nUsing quality model ").append(this.getAbsolutePath(qualityModelFile) + "'");
        }
        if (workspaceProfile != null) {
            openMessage.append("\nUsing workspace profile '").append(workspaceProfile).append("'");
        }
        if (dynamicSystem != null) {
            this.logDynamicSystemInfo(dynamicSystem, openMessage);
        }
        OperationResult openResult = new OperationResult(openMessage.toString());
        OpenSoftwareSystemCommand open = SonargraphBuildSystemOpener.createOpenCommand(this.m_systemProvider, systemDirectory, workspaceProfile, qualityModelFile, dynamicSystem, openResult);
        SonargraphBuildReporter.reportProgress(this.m_progressInfo, openMessage.toString());
        BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)open, (IWorkerContext)DefaultWorkerContext.INSTANCE);
        if (openResult.isFailure()) {
            return new ServiceResponse(StatusCode.FAILED, openResult.toString());
        }
        if (!this.m_systemProvider.hasSoftwareSystem()) {
            return new ServiceResponse(StatusCode.FAILED, "Failed to open system. Please check the log for details.");
        }
        this.logSystemInfo(this.m_systemProvider.getSoftwareSystem());
        return this.createResponseObject(openResult, "Successfully opened software system.");
    }

    public ServiceResponse getScriptRunnerStatus() {
        if (!this.m_systemProvider.hasSoftwareSystem()) {
            return new ServiceResponse(StatusCode.FAILED, "No system available. Use 'open()' first.");
        }
        SoftwareSystem softwareSystem = this.m_systemProvider.getSoftwareSystem();
        Analyzers analyzers = ((Files)softwareSystem.getUniqueExistingChild(Files.class)).getAnalyzers();
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.SCRIPTS_AUTOMATED)) {
            return new ServiceResponse(StatusCode.OK, "Automated script execution is not licensed.");
        }
        Analyzer scriptRunner = (Analyzer)analyzers.getUniqueChild(new NamedElement.IFilter(){

            public boolean accept(NamedElement analyzer) {
                if (!(analyzer instanceof Analyzer)) {
                    return false;
                }
                return ((Analyzer)analyzer).getId() == CoreAnalyzerId.SCRIPT_RUNNER;
            }
        }, Analyzer.class);
        if (scriptRunner == null) {
            return new ServiceResponse(StatusCode.OK, "There are no automated script executions available.");
        }
        AnalyzerResult result = scriptRunner.getResult();
        if (result == null) {
            return new ServiceResponse(StatusCode.FAILED, "Scripts have not been executed. Use 'refresh()' first.");
        }
        LastScriptRunnerExecutionStatus status = (LastScriptRunnerExecutionStatus)result.getUniqueChild(LastScriptRunnerExecutionStatus.class);
        if (status == null) {
            return new ServiceResponse(StatusCode.OK, "No automated script executions configured.");
        }
        return new ServiceResponse(StatusCode.OK, String.format(SCRIPT_RUNNER_STATUS_MESSAGE_FORMAT, status.getNumberOfSuccessfulExecutions(), status.getNumberOfConfiguredScriptExecutions()));
    }

    public ServiceResponse close() {
        if (!this.m_systemProvider.hasSoftwareSystem() || this.m_systemProvider.getSoftwareSystem().getState() == SoftwareSystemState.CLOSED) {
            return new ServiceResponse(StatusCode.OK, "No software system to be closed");
        }
        CloseSoftwareSystemCommand close = new CloseSoftwareSystemCommand(this.m_systemProvider, new CloseSoftwareSystemCommand.ICloseInteraction(){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public boolean processSaveResult(OperationResult result) {
                return true;
            }

            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                return false;
            }

            public boolean closeSoftwareSystem() {
                return true;
            }
        });
        Result enabled = close.isEnabled();
        if (enabled.isSuccess()) {
            BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)close, (IWorkerContext)DefaultWorkerContext.INSTANCE);
            LOGGER.debug("Successfully closed system");
            return new ServiceResponse(StatusCode.OK, "Successfully closed system.");
        }
        return new ServiceResponse(StatusCode.FAILED, enabled.getErrorMessage());
    }

    public ServiceResponse refresh() {
        assert (this.m_systemProvider != null) : "ISoftwareSystemProvider has not been initialized";
        if (!this.m_systemProvider.hasSoftwareSystem()) {
            LOGGER.error("No software system available");
            return new ServiceResponse(StatusCode.FAILED, "Refresh failed: No open software system available!");
        }
        assert (this.m_systemProvider.hasSoftwareSystem()) : "No software system available";
        OperationResult refreshResult = new OperationResult("Refresh software system");
        RefreshSoftwareSystemCommand refresh = SonargraphBuildSystemRefresh.createRefreshCommand(this.m_systemProvider, this.m_progressInfo, refreshResult);
        SonargraphBuildReporter.reportProgress(this.m_progressInfo, "Parsing software system.");
        BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)refresh, SonargraphBuildReporter.createProgressWorkerContext(this.m_progressInfo));
        if (refreshResult.isSuccess()) {
            LOGGER.debug("Successfully finished refreshing software system! System state: {}", (Object)this.m_systemProvider.getSoftwareSystem().getState().getPresentationName());
        } else {
            LOGGER.error("Refresh of software system failed");
        }
        return this.createResponseObject(refreshResult, null);
    }

    private ServiceResponse createResponseObject(OperationResult result, String additionalSuccessInfo) {
        assert (result != null) : "Parameter 'result' of method 'createResponseObject' must not be null";
        Optional<String> exceptionMessages = BuildUserInterfaceAdapter.getInstance().getExceptionMessagesForLastCommandExecution();
        if (result.isFailure()) {
            return new ServiceResponse(StatusCode.FAILED, result.toString());
        }
        if (exceptionMessages.isPresent()) {
            return new ServiceResponse(StatusCode.FAILED, result.getDescription() + " failed. Received the following exceptions:" + StringUtility.LINE_SEPARATOR + exceptionMessages.get());
        }
        if (result.containsError()) {
            return new ServiceResponse(StatusCode.ERRORS_EXIST, result.toString());
        }
        if (result.containsWarning()) {
            return new ServiceResponse(StatusCode.WARNINGS_EXIST, result.toString());
        }
        StringBuilder statusMessage = new StringBuilder("Operation successfully completed.");
        if (additionalSuccessInfo != null && !additionalSuccessInfo.isEmpty()) {
            statusMessage.append(" ").append(additionalSuccessInfo);
        }
        return new ServiceResponse(StatusCode.OK, statusMessage.toString());
    }

    private ServiceResponseWithOutcome<File> createResponseForSystemCreation(OperationResultWithOutcome<TFile> result, String additionalSuccessInfo) {
        ServiceResponseWithOutcome serviceResponse;
        assert (result != null) : "Parameter 'result' of method 'createResponseObject' must not be null";
        Optional<String> exceptionMessages = BuildUserInterfaceAdapter.getInstance().getExceptionMessagesForLastCommandExecution();
        if (result.isFailure()) {
            serviceResponse = new ServiceResponseWithOutcome(StatusCode.FAILED, result.toString());
        } else if (exceptionMessages.isPresent()) {
            serviceResponse = new ServiceResponseWithOutcome(StatusCode.FAILED, result.getDescription() + " failed. Received the following exceptions:" + StringUtility.LINE_SEPARATOR + exceptionMessages.get());
        } else if (result.containsWarning()) {
            serviceResponse = new ServiceResponseWithOutcome(StatusCode.WARNINGS_EXIST, result.toString());
            serviceResponse.setOutcome((Object)((File)result.getOutcome()));
        } else {
            StringBuilder statusMessage = new StringBuilder("Operation successfully completed.");
            if (additionalSuccessInfo != null) {
                statusMessage.append(" ").append(additionalSuccessInfo);
            }
            serviceResponse = new ServiceResponseWithOutcome(StatusCode.OK, statusMessage.toString());
            serviceResponse.setOutcome((Object)((File)result.getOutcome()));
        }
        return serviceResponse;
    }

    public ServiceResponse createReport(ReportRequest reportRequest) {
        assert (reportRequest != null) : "Parameter 'reportRequest' of method 'createReport' must not be null";
        File reportDirectory = reportRequest.getActualReportDirectory();
        if (reportDirectory == null) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Mandatory parameter 'reportDirectory' is missing!");
        }
        if (reportRequest.getActualReportType() == null) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Mandatory parameter 'type' is missing!");
        }
        Set formats = reportRequest.getActualReportFormats();
        if (formats == null || formats.isEmpty()) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Mandatory parameter 'formats' is missing or empty!");
        }
        TFile baselineXmlReportFile = null;
        String baselineXmlReportFileAsString = reportRequest.getBaselineReportPath();
        boolean systemDiffLicensed = CommandRegistry.getInstance().getLicenseHandler().isFeatureAvailable(SonargraphFeature.ARCHITECTURE);
        if (baselineXmlReportFileAsString != null && !baselineXmlReportFileAsString.isEmpty()) {
            baselineXmlReportFile = new TFile(baselineXmlReportFileAsString);
            if (systemDiffLicensed) {
                SonargraphBuildReporter.reportProgress(this.m_progressInfo, "Comparing against baseline " + baselineXmlReportFileAsString);
                OperationResult baselineResult = this.setBaseline(baselineXmlReportFile);
                if (baselineResult.isFailure()) {
                    return new ServiceResponse(StatusCode.FAILED, "Failed to apply baseline report.");
                }
            } else {
                SonargraphBuildReporter.reportProgress(this.m_progressInfo, "Comparing against baseline report is not licensed!");
            }
        }
        assert (reportDirectory != null) : "Parameter 'reportDirectory' of method 'createReport' must not be null";
        assert (formats != null && formats.size() > 0) : "Parameter 'formats' of method 'createReport' must not be empty";
        OperationResult reportResult = new OperationResult("Create report");
        Set<IReport.Format> convertedFormats = this.convertFormats(formats);
        CreateReportInteraction interaction = new CreateReportInteraction(convertedFormats, reportRequest, (File)baselineXmlReportFile, systemDiffLicensed, reportResult);
        SonargraphBuildReporter.reportProgress(this.m_progressInfo, "Writing report to directory: " + reportDirectory.getAbsolutePath());
        CreateReportCommand createReportCommand = new CreateReportCommand(this.m_systemProvider, (CreateReportCommand.IReportInteraction)interaction);
        BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)createReportCommand, SonargraphBuildReporter.createProgressWorkerContext(this.m_progressInfo));
        CreateReportResult createReportResult = interaction.getCreateReportResult();
        if (createReportResult != null) {
            reportRequest.setReportBaseName(createReportResult.getReportName());
            if (reportRequest.getUploadHostUrl() != null && !reportRequest.getUploadHostUrl().trim().isEmpty()) {
                TFile reportFile = createReportResult.getTargetFile(IReport.Format.XML);
                OperationResultWithOutcome<String> uploadResult = this.uploadReport(reportRequest, reportFile, reportResult);
                if (uploadResult.isSuccess()) {
                    if (uploadResult.containsWarning()) {
                        reportResult.addMessagesFromMaintainingCurrentOutcome(uploadResult);
                    } else {
                        SonargraphBuildReporter.reportProgress(this.m_progressInfo, (String)uploadResult.getOutcome());
                    }
                } else {
                    reportResult.addMessagesFromMaintainingCurrentOutcome(uploadResult);
                }
            }
        }
        return this.createResponseObject(reportResult, null);
    }

    private OperationResult setBaseline(final TFile baselineXmlReportFile) {
        assert (baselineXmlReportFile != null) : "Parameter 'baselineXmlReportFile' of method 'setBaseline' must not be null";
        final OperationResult createBaselineResult = new OperationResult("Set baseline report");
        SetBaselineCommand command = new SetBaselineCommand(this.m_systemProvider, new SetBaselineCommand.SetBaselineCommandInteraction(){

            public void processResult(OperationResult result) {
                createBaselineResult.addMessagesFromAndSetOutcome(result);
            }

            public boolean collect(SetBaselineCommand.SetBaselineInteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setData(BaselineType.LOCAL, baselineXmlReportFile);
                return true;
            }
        });
        BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command, SonargraphBuildReporter.createProgressWorkerContext(this.m_progressInfo));
        return createBaselineResult;
    }

    private OperationResultWithOutcome<String> uploadReport(ReportRequest reportRequest, TFile reportFile, OperationResult reportResult) {
        assert (reportRequest != null) : "Parameter 'reportRequest' of method 'uploadReport' must not be null";
        assert (reportFile != null) : "Parameter 'reportFile' of method 'uploadReport' must not be null";
        assert (reportResult != null) : "Parameter 'reportResult' of method 'uploadReport' must not be null";
        String snapshotPath = reportRequest.getSnapshotPath();
        TFile snapshotFile = snapshotPath != null ? new TFile(snapshotPath) : null;
        StringBuilder logMessage = new StringBuilder("Uploading report");
        if (snapshotFile != null) {
            logMessage.append(" and snapshot");
        }
        logMessage.append(" to ").append(reportRequest.getUploadHostUrl());
        if (reportRequest.getBranch() != null && reportRequest.getBranch().trim().length() > 0) {
            logMessage.append(", branch=").append(reportRequest.getBranch());
        }
        if (reportRequest.getCommitId() != null && reportRequest.getCommitId().trim().length() > 0) {
            logMessage.append(", commitId=").append(reportRequest.getCommitId());
        }
        if (reportRequest.getVersion() != null && reportRequest.getVersion().trim().length() > 0) {
            logMessage.append(", version=").append(reportRequest.getVersion());
        }
        if (reportRequest.getTimestampAsString() != null && reportRequest.getTimestampAsString().trim().length() > 0) {
            logMessage.append(", timestamp=").append(reportRequest.getTimestampAsString());
        }
        logMessage.append("...");
        SonargraphBuildReporter.reportProgress(this.m_progressInfo, logMessage.toString());
        SonargraphEnterpriseReportUploader uploader = new SonargraphEnterpriseReportUploader(reportRequest.getFailedUploadDirectory());
        return uploader.uploadSonargraphXmlReportAndSnapshot(reportRequest.getUploadHostUrl(), reportFile, snapshotFile, reportRequest.isUseSonargraphId(), reportRequest.getBranch(), reportRequest.getVersion(), reportRequest.getCommitId(), reportRequest.getClientKey());
    }

    public ServiceResponse createSnapshot(File snapshotDirectory, String snapshotFileName) {
        if (snapshotDirectory == null) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Mandatory parameter 'snapshotDirectory' is missing!");
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.SNAPSHOTS)) {
            return new ServiceResponse(StatusCode.WARNINGS_EXIST, "Creating snapshots is not licensed");
        }
        final OperationResult snapshotResult = new OperationResult("Create snapshot");
        final String filePath = this.createSnapshotFilePath(snapshotDirectory, snapshotFileName);
        SaveSnapshotCommand snapshotCommand = new SaveSnapshotCommand(this.m_systemProvider, new SaveSnapshotCommand.ISaveSnapshotInteraction(){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public boolean processSaveResult(OperationResult result) {
                return false;
            }

            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                return false;
            }

            public void processSaveSnapshotResult(OperationResult result) {
                snapshotResult.addMessagesFromAndSetOutcome(result);
            }

            public boolean confirmSnapshotOverwrite(String fileName) {
                return true;
            }

            public boolean collect(SaveSnapshotCommand.SaveSnapshotData data) {
                data.setFilePath(filePath);
                data.setIncludeSources(true);
                return true;
            }
        });
        SonargraphBuildReporter.reportProgress(this.m_progressInfo, "Writing snapshot to: " + filePath);
        BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)snapshotCommand, (IWorkerContext)DefaultWorkerContext.INSTANCE);
        ServiceResponse response = this.createResponseObject(snapshotResult, "Snapshot has been written to: " + filePath);
        if (!response.isFailure()) {
            response.setResult((Object)filePath);
        }
        return response;
    }

    private String createSnapshotFilePath(File snapshotDirectory, String snapshotFileName) {
        String fileName = snapshotFileName == null || snapshotFileName.trim().length() == 0 ? ((ISnapshotProvider)this.m_systemProvider.getSoftwareSystem().getExtension(ISnapshotProvider.class)).getDefaultSnapshotName() + CoreFileType.SNAPSHOT.getDefaultExtension() : snapshotFileName + CoreFileType.SNAPSHOT.getDefaultExtension();
        return new TFile(snapshotDirectory, fileName).getNormalizedAbsolutePath();
    }

    private Set<IReport.Format> convertFormats(Set<ReportRequest.ReportFormat> formats) {
        HashSet<IReport.Format> converted = new HashSet<IReport.Format>(formats.size());
        for (ReportRequest.ReportFormat next : formats) {
            converted.add(IReport.Format.valueOf((String)next.name()));
        }
        return converted;
    }

    public ServiceResponse failIfExists(FailSet failSet) {
        IMetricAccessor metricsExtension;
        Number sourceElementCount;
        assert (failSet != null) : "Parameter 'failSet' of method 'failIfExists' must not be null";
        if (!this.m_systemProvider.hasSoftwareSystem()) {
            String statusMessage = "No loaded software system available.";
            LOGGER.warn("No loaded software system available.");
            return new ServiceResponse(StatusCode.FAILED, "No loaded software system available.");
        }
        SoftwareSystem softwareSystem = this.m_systemProvider.getSoftwareSystem();
        if (failSet.isFailOnEmptyWorkspace() && ((sourceElementCount = (metricsExtension = (IMetricAccessor)((ISoftwareSystemProvider)softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricAccessor.class)).getMetricValue(softwareSystem, (NamedElement)softwareSystem, (IMetricLevel)CoreMetricLevel.SYSTEM, (IMetricId)CoreMetricId.CORE_SOURCE_ELEMENT_COUNT, true)) == null || sourceElementCount.intValue() == 0)) {
            String statusMessage = "Build failed because of empty workspace. Root directories in use are:";
            LOGGER.warn("Build failed because of empty workspace. Root directories in use are:");
            for (RootDirectoryPath root : ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildrenRecursively(RootDirectoryPath.class, new Class[]{RootDirectoryPath.class})) {
                LOGGER.warn(root.getDirectoryFile().getNormalizedAbsolutePath());
            }
            return new ServiceResponse(StatusCode.FAILED, "Build failed because of empty workspace. Root directories in use are:");
        }
        if (failSet.isEmpty()) {
            String statusMessage = "Not validating any detected issues, since provided failSet is empty.";
            LOGGER.info("Not validating any detected issues, since provided failSet is empty.");
            return new ServiceResponse(StatusCode.OK, "Not validating any detected issues, since provided failSet is empty.");
        }
        IssueFinder issueFinder = new IssueFinder(softwareSystem);
        StringBuilder filterLog = new StringBuilder();
        List<Issue> issuesFound = issueFinder.issuesExist(failSet, filterLog);
        if (issuesFound.isEmpty()) {
            String message = "Summary: No issues match the specified failset. Details:\n" + filterLog.toString();
            SonargraphBuildReporter.reportProgress(this.m_progressInfo, message);
            return new ServiceResponse(StatusCode.OK, message);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Debug info for issues found: {}", (Object)StringUtility.concat((Collection)issuesFound.stream().map(i -> "issue: " + i.getDebugInfo()).collect(Collectors.toList()), (String)StringUtility.LINE_SEPARATOR));
        }
        if (failSet.isFailOnIssues()) {
            String statusMessage = String.format("%sSummary: Build failed as %d issue(s) match the specified failset on virtual model '%s'.", filterLog.toString(), issuesFound.size(), softwareSystem.getCurrentModel().getShortName());
            return new ServiceResponse(StatusCode.FAILED, statusMessage);
        }
        String statusMessage = String.format("%sSummary: Warning because %d issue(s) match the specified failset on virtual model '%s'.", filterLog.toString(), issuesFound.size(), softwareSystem.getCurrentModel().getShortName());
        LOGGER.warn(statusMessage);
        return new ServiceResponse(StatusCode.WARNINGS_EXIST, statusMessage);
    }

    public ServiceResponse setVirtualModel(String virtualModel) {
        if (virtualModel == null) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, "Parameter 'virtualModel' of method 'setVirtualModel' must not be null");
        }
        if (this.m_systemProvider.getSoftwareSystem().getCurrentModel().getShortName().equals(virtualModel)) {
            return new ServiceResponse(StatusCode.OK, String.format("Virtual model '%s' is already the current model.", virtualModel));
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS)) {
            return new ServiceResponse(StatusCode.WARNINGS_EXIST, "Changing the virtual model is not licensed!");
        }
        List models = this.m_systemProvider.getSoftwareSystem().getAvailableVirtualModels();
        final Optional<VirtualModel> toSelect = models.stream().filter(m -> m.getShortName().equals(virtualModel)).findAny();
        if (!toSelect.isPresent()) {
            return new ServiceResponse(StatusCode.FAILED, "Specified 'virtualModel' is not available in system: " + virtualModel);
        }
        final OperationResult setModelResult = new OperationResult(String.format("Set virtual model '%s'", virtualModel));
        SetModelCommand setCommand = new SetModelCommand(this.m_systemProvider, new SetModelCommand.ISetModelInteraction(){

            public boolean collect(SetModelCommand.SetModelData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setModel((VirtualModel)toSelect.get());
                return true;
            }

            public void processSetModelResult(OperationResult result) {
                setModelResult.addMessagesFromAndSetOutcome(result);
            }
        });
        BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)setCommand, (IWorkerContext)DefaultWorkerContext.INSTANCE);
        SonargraphBuildReporter.reportProgress(this.m_progressInfo, "Virtual model successfully set to: " + virtualModel);
        return this.createResponseObject(setModelResult, null);
    }

    public ServiceResponse getInitializationStatus() {
        if (CommandRegistry.hasInstance()) {
            return new ServiceResponse(StatusCode.OK, "SonargraphBuild has been initialized.");
        }
        return new ServiceResponse(StatusCode.FAILED, "SonargraphBuild has not been initialized.");
    }

    public ServiceResponseWithOutcome<File> createDynamicSystem(final SystemInfo system, File qualityModelFile) {
        TFile determinedQualityModelFile;
        if (system == null) {
            return new ServiceResponseWithOutcome(StatusCode.INPUT_VALIDATION_ERROR, "Missing 'system' info");
        }
        if (system.getAbsolutePath() == null || system.getAbsolutePath().trim().isEmpty()) {
            return new ServiceResponseWithOutcome(StatusCode.INPUT_VALIDATION_ERROR, "Missing 'targetDirectory' in system info");
        }
        final OperationResultWithOutcome createSystemResult = new OperationResultWithOutcome(String.format("Create dynamic system '%s' in '%s'", system.getName(), system.getAbsolutePath()));
        final DynamicSystemInfo dynamicSystem = SonargraphBuildSystemOpener.convertSystemInfo(CreateDynamicSystemCommand.getAdditionalInfoProviders((ISoftwareSystemProvider)this.m_systemProvider), system, (OperationResult)createSystemResult);
        if (createSystemResult.isFailure()) {
            return this.createResponseForSystemCreation((OperationResultWithOutcome<TFile>)createSystemResult, null);
        }
        TFile tFile = determinedQualityModelFile = qualityModelFile == null ? null : SonargraphBuildSystemOpener.determineQualityModelFile(this.m_systemProvider, new TFile(qualityModelFile), (OperationResult)createSystemResult);
        if (createSystemResult.isFailure()) {
            return this.createResponseForSystemCreation((OperationResultWithOutcome<TFile>)createSystemResult, null);
        }
        assert (dynamicSystem != null) : "dynamicSystem must not be null if result is success";
        CreateDynamicSystemCommand create = new CreateDynamicSystemCommand(this.m_systemProvider, new CreateDynamicSystemCommand.IInteraction(){

            public boolean collect(CreateDynamicSystemCommand.SystemData data) {
                data.setSystemInfo(dynamicSystem);
                data.setTargetDirectory(new TFile(system.getAbsolutePath()));
                if (determinedQualityModelFile != null) {
                    data.setQualityModelFile(determinedQualityModelFile);
                }
                return true;
            }

            public void processResult(OperationResultWithOutcome<TFile> result) {
                createSystemResult.addMessagesFromAndSetOutcome(result);
                createSystemResult.setOutcome((Object)((TFile)result.getOutcome()));
            }
        });
        BuildUserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)create, (IWorkerContext)DefaultWorkerContext.INSTANCE);
        if (createSystemResult.isFailure()) {
            return this.createResponseForSystemCreation((OperationResultWithOutcome<TFile>)createSystemResult, null);
        }
        ServiceResponseWithOutcome<File> responseWithOutcome = this.createResponseForSystemCreation((OperationResultWithOutcome<TFile>)createSystemResult, "Created Sonargraph system in '" + system.getAbsolutePath() + "'");
        return responseWithOutcome;
    }

    public ServiceResponse resendFaildUploads(ResendFailedUploadsRequest request) {
        String message;
        StatusCode statusCode;
        SonargraphEnterpriseReportUploader enterpriseUploader = new SonargraphEnterpriseReportUploader(request.getFailedUploadDirectory());
        StrictPair<Integer, Set<String>> result = enterpriseUploader.uploadFailedReports(request.getUploadHostUrl(), request.getClientKey());
        ReportUploader uploader = new ReportUploader(request.getFailedUploadDirectory());
        Set failedUploads = (Set)result.getSecond();
        int countOfDeprecatedUploads = uploader.uploadFailedReports(request.getUploadHostUrl(), request.getClientKey(), failedUploads);
        int successfulUploadCount = countOfDeprecatedUploads + (Integer)result.getFirst();
        if (failedUploads.isEmpty()) {
            statusCode = StatusCode.OK;
            message = successfulUploadCount == 0 ? "No reports to upload to Sonargraph-Enterprise." : String.format("Successfully uploaded %d reports to Sonargraph-Enterprise.", successfulUploadCount);
        } else if (successfulUploadCount == 0 && !failedUploads.isEmpty()) {
            statusCode = StatusCode.FAILED;
            message = String.format("Failed to upload %d reports to Sonargraph-Enterprise (check log for details).", failedUploads.size());
        } else {
            statusCode = StatusCode.WARNINGS_EXIST;
            message = String.format("Successfully uploaded %d reports, failed to upload %d reports to Sonargraph-Enterprise (check log for details).", successfulUploadCount, failedUploads.size());
        }
        return new ServiceResponse(statusCode, message);
    }

    public ServiceResponse checkQualityGates() {
        ServiceResponse response;
        String summary;
        if (!CommandRegistry.getInstance().getLicenseHandler().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            ServiceResponse response2 = new ServiceResponse(StatusCode.WARNINGS_EXIST, "Quality gate check is not licensed!");
            return response2;
        }
        IQualityGateProvider qualityGateProvider = (IQualityGateProvider)this.m_systemProvider.getSoftwareSystem().getExtension(IQualityGateProvider.class);
        List checkedQualityGates = qualityGateProvider.getAvailableQualityGates().stream().filter(qg -> qg.isChecked()).collect(Collectors.toList());
        if (checkedQualityGates.isEmpty()) {
            ServiceResponse response3 = new ServiceResponse(StatusCode.OK, "No active quality gate(s) found!");
            return response3;
        }
        SonargraphBuildReporter.reportProgress(this.m_progressInfo, "\nChecking active quality gate(s)...");
        ArrayList<String> qualityGateReports = new ArrayList<String>(checkedQualityGates.size());
        int numberOfFailed = 0;
        for (QualityGate next : checkedQualityGates) {
            if (next.getStatus() == QualityGateResultStatus.FAILED) {
                ++numberOfFailed;
            }
            qualityGateReports.add(qualityGateProvider.getPrintoutFor(next));
        }
        if (numberOfFailed == 0) {
            summary = String.format("Quality Gate Summary: %d passed.", checkedQualityGates.size());
            response = new ServiceResponse(StatusCode.OK, "Successful check of quality gates.");
        } else {
            summary = String.format("Quality Gate Summary: %d of %d failed.", numberOfFailed, checkedQualityGates.size());
            response = new ServiceResponse(StatusCode.FAILED, "Check of quality gates failed.");
        }
        response.setResult((Object)summary);
        String printout = qualityGateReports.stream().collect(Collectors.joining("\n\n"));
        if (response.isFailure()) {
            SonargraphBuildReporter.reportError(this.m_progressInfo, printout);
        } else {
            SonargraphBuildReporter.reportProgress(this.m_progressInfo, printout);
        }
        return response;
    }
}

