/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericInterface;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public final class TypescriptInterface
extends GenericInterface {
    private String m_typeParameters;
    private int m_id;

    public TypescriptInterface(NamedElement parent) {
        super(parent);
    }

    public TypescriptInterface(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int id) {
        super(msp, parent, name, lineNumber);
        this.m_id = id;
    }

    public void setTypeParameters(String typeParameters) {
        this.m_typeParameters = typeParameters;
    }

    public String getShortName() {
        StringBuilder sb = new StringBuilder(super.getShortName());
        if (this.m_typeParameters.length() > 0) {
            sb.append('<').append(this.m_typeParameters.replace(";", ", ")).append('>');
        }
        return sb.toString();
    }

    public String getName() {
        NamedElement parent = this.getParent();
        if (parent instanceof SourceFile) {
            return this.getShortName();
        }
        return parent.getName() + "." + this.getShortName();
    }

    public String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart() + "--" + this.m_id;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_typeParameters);
        writer.writeInt(this.m_id);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_typeParameters = reader.readString();
        this.m_id = reader.readInt();
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitTypescriptInterface(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitTypescriptInterface(TypescriptInterface var1);
    }
}

