/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.commandline;

import com.hello2morrow.sonargraph.foundation.commandline.ProcessMessageSink;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessStream
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessStream.class);
    private final InputStream m_is;
    private final StringBuilder m_output;
    private final ProcessMessageSink m_messageSink;
    private volatile boolean m_completed;

    public ProcessStream(String name, InputStream is, ProcessMessageSink messageSink) {
        super(name);
        assert (is != null) : "Parameter 'is' of method 'ProcessStream' must not be null";
        this.m_is = is;
        this.m_output = new StringBuilder(256);
        this.m_messageSink = messageSink;
    }

    @Override
    public void run() {
        this.m_completed = false;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.m_is));){
                String line;
                while ((line = br.readLine()) != null) {
                    String next = line;
                    this.m_output.append(next + StringUtility.DEFAULT_LINE_SEPARATOR);
                    if (this.m_messageSink == null || this.m_messageSink.hasBeenCanceled()) continue;
                    LOGGER.info(line);
                    this.m_messageSink.message(next);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Couldn't read from " + this.getName(), (Throwable)ioe);
        }
        this.m_completed = true;
    }

    public String getOutput() {
        return this.m_output.toString().trim();
    }

    public boolean isCompleted() {
        return this.m_completed;
    }
}

