/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.api;

import com.hello2morrow.sonargraph.build.api.AbstractIssueFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class AbstractFailSet<T extends AbstractIssueFilter> {
    private List<T> m_includeIssueFilters;
    private List<T> m_excludeIssueFilters;

    protected AbstractFailSet() {
    }

    public final void addIncludeIssueFilter(T filter) {
        assert (filter != null) : "Parameter 'filter' of method 'addIncludeIssueFilter' must not be null";
        if (this.m_includeIssueFilters == null) {
            this.m_includeIssueFilters = new ArrayList<T>();
        }
        this.m_includeIssueFilters.add(filter);
    }

    public final List<T> getIncludeIssueFilters() {
        if (this.m_includeIssueFilters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_includeIssueFilters);
    }

    public final void addExcludeIssueFilter(T filter) {
        assert (filter != null) : "Parameter 'filter' of method 'addExcludeIssueFilter' must not be null";
        if (this.m_excludeIssueFilters == null) {
            this.m_excludeIssueFilters = new ArrayList<T>();
        }
        this.m_excludeIssueFilters.add(filter);
    }

    public final List<T> getExcludeIssueFilters() {
        if (this.m_excludeIssueFilters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_excludeIssueFilters);
    }

    public boolean isEmpty() {
        return this.getIncludeIssueFilters().isEmpty();
    }
}

