/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethodSignatureWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaMethod
extends JavaMember
implements IMethod {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaMethod.class);
    private String m_descriptor = "";
    private short m_numberOfParameters = (short)-1;
    private short m_cyclomaticComplexity = (short)-1;
    private short m_modifiedCyclomaticComplexity = (short)-1;
    private short m_numberOfLogicalOperations = (short)-1;
    private short m_numberOfStatements = (short)-1;
    private short m_maxNesting = (short)-1;

    public JavaMethod(IModelServiceProvider msp, NamedElement parent, String name, String descriptor) {
        super(msp, parent, name);
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'JavaMethod' must not be empty";
        this.m_descriptor = descriptor.intern();
    }

    public JavaMethod(NamedElement parent) {
        super(parent);
    }

    public final String getImageResourceName() {
        if (this.isDefinedInEnclosingElement()) {
            return JavaMethod.class.getSimpleName();
        }
        return JavaMethod.class.getSimpleName() + "FromSuperType";
    }

    public int getNumberOfGenericTypeParameters() {
        String signature = this.getSignature();
        if (signature != null && !signature.isEmpty()) {
            try {
                int endPos;
                int startPos = signature.indexOf(60);
                if (startPos != -1 && (endPos = signature.indexOf(40)) != -1 && startPos < endPos && signature.charAt(endPos - 1) == '>') {
                    String relevant = signature.substring(startPos + 1, endPos - 1);
                    return StringUtility.countChar((char)';', (String)relevant);
                }
            }
            catch (Throwable t) {
                LOGGER.error("Unable to process signature '" + signature + "' of method: " + this.m_descriptor, t);
            }
        }
        return 0;
    }

    public List<String> getArgumentTypes() {
        int start;
        if (this.m_numberOfParameters == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(this.m_numberOfParameters);
        Type[] argumentTypes = Type.getArgumentTypes((String)this.m_descriptor);
        int i = start = argumentTypes.length - this.m_numberOfParameters;
        while (i < argumentTypes.length) {
            Type type = argumentTypes[i];
            result.add(type.getClassName());
            ++i;
        }
        return result;
    }

    public String getReturnType() {
        if (this.isInitializer()) {
            return "void";
        }
        return Type.getReturnType((String)this.m_descriptor).getClassName();
    }

    protected final String getName(String parentName, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (parentName != null && !parentName.isEmpty()) {
            builder.append(parentName).append(".");
        }
        builder.append(this.getShortName());
        String signature = this.getSignature();
        if (signature != null) {
            try {
                JavaMethodSignatureWriter writer = new JavaMethodSignatureWriter(includeReturnType, false);
                SignatureReader signatureReader = new SignatureReader(signature);
                signatureReader.accept((SignatureVisitor)writer);
                builder.append(writer.getResult());
                return builder.toString();
            }
            catch (Throwable t) {
                LOGGER.error("Failed to process signature '" + signature + "' for '" + this.getShortName() + "' in: " + String.valueOf(this.getParent()), t);
            }
        }
        if (this.mightHaveParameters()) {
            builder.append("(");
            if (this.m_numberOfParameters > 0) {
                int start;
                Type[] argumentTypes = Type.getArgumentTypes((String)this.m_descriptor);
                int i = start = argumentTypes.length - this.m_numberOfParameters;
                while (i < argumentTypes.length) {
                    Type type = argumentTypes[i];
                    builder.append(JavaNameUtility.getTypeNameFromFqTypeName(type.getClassName()));
                    builder.append(",");
                    ++i;
                }
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append(")");
        }
        if (includeReturnType && !this.isInitializer()) {
            builder.append(" : ").append(JavaNameUtility.getTypeNameFromFqTypeName(Type.getReturnType((String)this.m_descriptor).getClassName()));
        }
        return builder.toString();
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        String fqNamePart = super.getFullyQualifiedNamePart();
        if (!this.mightHaveParameters()) {
            return fqNamePart;
        }
        StringBuilder builder = new StringBuilder(fqNamePart);
        builder.append("(");
        if (this.m_numberOfParameters > 0) {
            int start;
            Type[] argumentTypes = Type.getArgumentTypes((String)this.m_descriptor);
            int i = start = argumentTypes.length - this.m_numberOfParameters;
            while (i < argumentTypes.length) {
                Type type = argumentTypes[i];
                builder.append(type.getClassName());
                builder.append(",");
                ++i;
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(")");
        if (this.isBridge()) {
            builder.append('b');
        }
        if (this.isSynthetic()) {
            builder.append('s');
        }
        return builder.toString();
    }

    protected abstract boolean mightHaveParameters();

    public abstract boolean isInitializer();

    public final boolean isDestructor() {
        return false;
    }

    public final boolean isOverriding() {
        return this.hasFlag(JavaElementFlag.OVERRIDES);
    }

    public final boolean hasNumberOfParametersBeenSet() {
        return this.m_numberOfParameters != -1;
    }

    @IntProperty
    public final int getNumberOfParameters() {
        assert (this.m_numberOfParameters != -1) : "'m_numberOfParameters' of method 'getNumberOfParameters' not set";
        return this.m_numberOfParameters;
    }

    public final void setNumberOfParameters(int numberOfParameters) {
        assert (numberOfParameters <= Short.MAX_VALUE) : "number of parameters cannot be greater than 32767";
        assert (numberOfParameters >= 0) : "Parameter 'm_numberOfParameters' of method 'setNumberOfParameters' must not be negative";
        this.m_numberOfParameters = (short)numberOfParameters;
    }

    @Override
    public void aboutToReparse() {
        this.m_numberOfParameters = (short)-1;
        this.m_cyclomaticComplexity = (short)-1;
        this.m_modifiedCyclomaticComplexity = (short)-1;
        this.m_numberOfLogicalOperations = (short)-1;
        this.m_numberOfStatements = (short)-1;
        this.m_maxNesting = (short)-1;
    }

    public int getEndLineNumber() {
        return -1;
    }

    public final void initMetrics() {
        this.m_cyclomaticComplexity = 1;
        this.m_modifiedCyclomaticComplexity = 1;
        this.m_numberOfLogicalOperations = 0;
        this.m_numberOfStatements = 0;
        this.m_maxNesting = 0;
    }

    @IntProperty(undefinedValue=-1)
    public final int getCyclomaticComplexity() {
        return this.m_cyclomaticComplexity;
    }

    public final void incrementCyclomaticComplexity() {
        this.m_cyclomaticComplexity = (short)(this.m_cyclomaticComplexity + 1);
    }

    @IntProperty(undefinedValue=-1)
    public final int getModifiedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity;
    }

    public final void incrementModifiedCyclomaticComplexity() {
        this.m_modifiedCyclomaticComplexity = (short)(this.m_modifiedCyclomaticComplexity + 1);
    }

    @IntProperty(undefinedValue=-1)
    public final int getNumberOfLogicalOperations() {
        return this.m_numberOfLogicalOperations;
    }

    public final void incrementNumberOfLogicalOperations() {
        this.m_numberOfLogicalOperations = (short)(this.m_numberOfLogicalOperations + 1);
    }

    @IntProperty(undefinedValue=-1)
    public final int getExtendedCyclomaticComplexity() {
        if (this.m_cyclomaticComplexity == -1 || this.m_numberOfLogicalOperations == -1) {
            return -1;
        }
        return this.m_cyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @IntProperty(undefinedValue=-1)
    public final int getModifiedExtendedCyclomaticComplexity() {
        if (this.m_modifiedCyclomaticComplexity == -1 || this.m_numberOfLogicalOperations == -1) {
            return -1;
        }
        return this.m_modifiedCyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @IntProperty(undefinedValue=-1)
    public final int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    public final void incrementNumberOfStatements() {
        this.m_numberOfStatements = (short)(this.m_numberOfStatements + 1);
    }

    @IntProperty
    public int getMaxNesting() {
        return this.m_maxNesting;
    }

    public void setMaxNesting(int maxNesting) {
        this.m_maxNesting = (short)maxNesting;
    }

    public final int getSourceElementCount() {
        if (!this.isDefinedInEnclosingElement() || this.isExternal()) {
            return -1;
        }
        if (this.m_numberOfStatements != -1) {
            return 1 + this.m_numberOfStatements;
        }
        return 1;
    }

    public final String getDescriptor() {
        return this.m_descriptor;
    }

    public final Type[] getParameterTypes() {
        assert (this.m_descriptor != null && this.m_descriptor.length() > 0) : "'m_descriptor' of method 'getParameterTypes' must not be empty";
        assert (this.m_numberOfParameters != -1) : "'m_numberOfParameters' of method 'getParameterTypes' not set";
        Type[] nonSyntheticParameterTypes = new Type[this.m_numberOfParameters];
        if (this.m_numberOfParameters == 0) {
            return nonSyntheticParameterTypes;
        }
        Type[] parameters = Type.getArgumentTypes((String)this.m_descriptor);
        assert (this.m_numberOfParameters <= parameters.length) : "Less parameters retrieved from 'm_descriptor' than expected";
        int i = 0;
        int j = parameters.length - this.m_numberOfParameters;
        while (j < parameters.length) {
            nonSyntheticParameterTypes[i] = parameters[j];
            ++i;
            ++j;
        }
        return nonSyntheticParameterTypes;
    }

    @Override
    public String getName() {
        IType type = (IType)super.getParent(IType.class, new Class[0]);
        if (type != null) {
            return this.getName(type.getName(), false);
        }
        assert (!this.isValid()) : "Is still valid and has not type parent: " + this.getShortName();
        return this.getName(null, false);
    }

    public String getRawPresentationName(boolean shortName) {
        if (shortName) {
            return this.getShortName();
        }
        IType type = (IType)super.getParent(IType.class, new Class[0]);
        if (type != null) {
            return type.getRawPresentationName(false) + "." + this.getShortName();
        }
        assert (!this.isValid()) : "Is still valid and has not type parent: " + this.getShortName();
        return this.getShortName();
    }

    @Override
    public String getPresentationName(boolean shortName) {
        IType type = (IType)super.getParent(IType.class, new Class[0]);
        if (type != null) {
            return this.getName(shortName ? null : type.getPresentationName(false), true);
        }
        assert (!this.isValid()) : "Is still valid and has not type parent: " + this.getShortName();
        return this.getName(null, true);
    }

    public final String getMethodDescriptor() {
        return this.m_descriptor;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfParameters = reader.readShort();
        this.m_descriptor = reader.readString();
        this.m_cyclomaticComplexity = reader.readShort();
        this.m_modifiedCyclomaticComplexity = reader.readShort();
        this.m_numberOfLogicalOperations = reader.readShort();
        this.m_numberOfStatements = reader.readShort();
        this.m_maxNesting = reader.getVersion() >= 12 ? reader.readShort() : (short)-1;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeShort(this.m_numberOfParameters);
        writer.writeString(this.m_descriptor);
        writer.writeShort(this.m_cyclomaticComplexity);
        writer.writeShort(this.m_modifiedCyclomaticComplexity);
        writer.writeShort(this.m_numberOfLogicalOperations);
        writer.writeShort(this.m_numberOfStatements);
        writer.writeShort(this.m_maxNesting);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("Descriptor: ");
        builder.append(this.m_descriptor);
        return builder.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaMethod(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaMethod(JavaMethod var1);
    }
}

