/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaPackageNameExtractor;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonJavaFilePackageNameExtractor
extends JavaPackageNameExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonJavaFilePackageNameExtractor.class);
    private static final String TOKEN_DELIMITERS = " ;\t";
    private static final String PACKAGE = "package";

    private NonJavaFilePackageNameExtractor() {
    }

    public static String extract(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'extract' must not be null";
        JavaFileType fileType = JavaFileType.determine(file.getName());
        assert (fileType != null) : "'fileType' of method 'extract' must not be null";
        assert (fileType != JavaFileType.CLASS_FILE && fileType != JavaFileType.JAVA_FILE) : "Not an additional Java source file: " + file.getAbsolutePath();
        boolean nextTokenIsPackageName = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader((Reader)new TFileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(line, TOKEN_DELIMITERS);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (nextTokenIsPackageName) {
                            if (token.isEmpty()) continue;
                            return token;
                        }
                        if (!token.equals(PACKAGE)) continue;
                        nextTokenIsPackageName = true;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to extract package name from '" + file.getAbsolutePath() + "'", (Throwable)e);
        }
        return null;
    }
}

