/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.IDeltaDetector;
import com.hello2morrow.sonargraph.core.controller.system.IKeywordProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.RelativeCyclicityMetricIds;
import com.hello2morrow.sonargraph.core.controller.system.parser.JavaFamilySourceLineVisitor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedExternalLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PhysicalInfo;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.DeltaRefreshJob;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IJavaLanguageProvider;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaDynamicSystemInfoProvider;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaFileCreationVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaFilePresentVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaRefactoringAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaSoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaTypeRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaTypeVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.RefreshMessageCause;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.analysis.JavaPackageCyclesInModuleAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.analysis.JavaPackageCyclesInModuleMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.analysis.JavaPackageCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.analysis.JavaSystemPackageCyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.analysis.JavaVisibilityMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaAnnotationRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaAnnotationValueRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaBelongsToAggregateRootRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaExtendsClassRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaExtendsImplementsInterfaceRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaImplementsInterfaceRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaIsClassRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaIsInterfaceRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaTypeOfRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.plugin.PluginJavaAccess;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.script.JavaAccess;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaLanguage;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaIssueId;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaProviderId;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaStructureItem;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.UnknownJar;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaExternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaKeywords;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaLogicalModuleNamespace;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaLogicalSystemNamespace;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMetricLevel;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaNonInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaPackageFragment;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaStaticBlock;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaExternal;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaMetricId;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.JavaPersistenceProvider;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicJavaLanguageProvider
extends LanguageProvider
implements IJavaLanguageProvider,
IKeywordProvider {
    private static final String[] IMPORT_START_TOKENS = new String[]{"import", "package"};
    private final JavaRefactoringAdapter m_refactoringAdapter = new JavaRefactoringAdapter(this);
    private Installation m_installation;
    private JavaGlobalModel m_globalModel;

    public BasicJavaLanguageProvider() {
        super((Language)JavaLanguage.INSTANCE);
    }

    public final Set<IIssueId> getIssueIds() {
        return new THashSet(Arrays.asList(JavaIssueId.values()));
    }

    public IMetricId getNamespacesMetricId() {
        return JavaMetricId.JAVA_PACKAGES;
    }

    public IMetricId getFullyAnalyzedNamespacesMetricId() {
        return JavaMetricId.JAVA_PACKAGES_FULLY_ANALYZED;
    }

    public final IMetricLevel getNamespaceMetricLevel() {
        return JavaMetricLevel.JAVA_PACKAGE;
    }

    public final Set<IMetricId> getAdditionalSystemSizeMetricIds() {
        return Collections.singleton(JavaMetricId.JAVA_BYTE_CODE_INSTRUCTIONS);
    }

    public Set<RelativeCyclicityMetricIds> getRelativeCyclicityMetricIds() {
        return Set.of(new RelativeCyclicityMetricIds((IMetricId)JavaMetricId.JAVA_PACKAGES_FULLY_ANALYZED, (IMetricId)JavaMetricId.JAVA_RELATIVE_CYCLICITY_PACKAGES, (IMetricId)JavaMetricId.JAVA_AVERAGE_RELATIVE_CYCLICITY_PACKAGES));
    }

    public Map<IMetricId, Number> calculateAdditionalSizeMetrics(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'calculateAdditionalSizeMetrics' must not be null";
        return Collections.singletonMap(JavaMetricId.JAVA_BYTE_CODE_INSTRUCTIONS, ((ISoftwareSystemProvider)softwareSystem.getExtension(ISoftwareSystemProvider.class)).getUsedSize((Language)JavaLanguage.INSTANCE));
    }

    public Collection<String> getSourceExtensions() {
        return JavaFileType.getSourceFileExtensions();
    }

    public final Set<IConfigurableAnalyzerId> getAnalyzerIds() {
        return new THashSet(Arrays.asList(JavaAnalyzerId.values()));
    }

    public final List<? extends AnalyzerAdapter> getAnalyzerAdapters(IAnalyzerController controller, Set<IConfigurableAnalyzerId> licensedAnalyzerIds) {
        assert (controller != null) : "Parameter 'controller' of method 'getAnalyzerAdapters' must not be null";
        assert (licensedAnalyzerIds != null) : "Parameter 'licensedAnalyzerIds' of method 'getAnalyzerAdapters' must not be null";
        ArrayList<Object> result = new ArrayList<Object>();
        if (licensedAnalyzerIds.contains(JavaPackageCyclesInModuleAnalyzerAdapter.ID)) {
            result.add((Object)new JavaPackageCyclesInModuleAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(JavaSystemPackageCyclesAnalyzerAdapter.ID)) {
            result.add((Object)new JavaSystemPackageCyclesAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(JavaPackageCyclesInModuleMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new JavaPackageCyclesInModuleMetricsAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(JavaPackageCyclesInSystemMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new JavaPackageCyclesInSystemMetricsAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains((Object)JavaVisibilityMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new JavaVisibilityMetricsAnalyzerAdapter(controller));
        }
        return result;
    }

    public final CategoryProvider getPhysicalCategoryProvider() {
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(JavaModule.class, 1);
        categoryProvider.setCategory(JavaSourceRootDirectoryPath.class, 1);
        categoryProvider.setCategory(JavaInternalCompilationUnit.class, 1);
        categoryProvider.setCategory(JavaExternalCompilationUnit.class, 1);
        categoryProvider.setCategory(JavaType.class, 1);
        categoryProvider.setCategory(JavaField.class, 2);
        categoryProvider.setCategory(JavaStaticBlock.class, 3);
        categoryProvider.setCategory(JavaConstructor.class, 4);
        categoryProvider.setCategory(JavaNonInitializer.class, 5);
        categoryProvider.setCategory(JavaExternal.class, 1000);
        return categoryProvider;
    }

    public final CategoryProvider getLogicalCategoryProvider() {
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(JavaExternalLogicalNamespaceRoot.class, 1000);
        categoryProvider.setCategory(JavaLogicalModuleNamespace.class, 0);
        categoryProvider.setCategory(JavaLogicalSystemNamespace.class, 0);
        categoryProvider.setCategory(JavaType.class, 1);
        categoryProvider.setCategory(JavaField.class, 2);
        categoryProvider.setCategory(JavaStaticBlock.class, 3);
        categoryProvider.setCategory(JavaConstructor.class, 4);
        categoryProvider.setCategory(JavaNonInitializer.class, 5);
        categoryProvider.setCategory(JavaExternal.class, 1000);
        categoryProvider.setCategory(PhysicalElementBasedExternalLogicalRoot.class, 1000);
        return categoryProvider;
    }

    private JavaTypeRegistry createTypeRegistry(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createTypeRegistry' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createTypeRegistry' must not be null";
        workerContext.working("Create Java type registry", true);
        JavaTypeRegistry typeRegistry = new JavaTypeRegistry();
        JavaTypeVisitor typeVisitor = new JavaTypeVisitor(typeRegistry);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        workspace.getChildren(JavaModule.class).forEach(m -> m.accept(typeVisitor));
        ((JavaExternal)((Object)workspace.getUniqueExistingChild(JavaExternal.class))).accept(typeVisitor);
        return typeRegistry;
    }

    protected final boolean isRefreshable(RootDirectoryPath rootDirectoryPath) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'isRefreshable' must not be null";
        return rootDirectoryPath instanceof JavaClassRootDirectoryPath;
    }

    public final boolean prepareRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, PrepareRefreshResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'isRefreshPossible' must not be null";
        assert (result != null) : "Parameter 'result' of method 'isRefreshPossible' must not be null";
        for (Module nextModule : ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(JavaModule.class)) {
            if (!nextModule.hasChildren(true, new Class[]{JavaClassRootDirectoryPath.class})) continue;
            result.setParserRefreshPossible(this.getLanguage(), true);
            return false;
        }
        result.setParserRefreshPossible(this.getLanguage(), false);
        result.addWarning((OperationResult.IMessageCause)RefreshMessageCause.AT_LEAST_ONE_JAVA_CLASS_ROOT_DIRECTORY_NEEDED, "No class root directory/archive defined in Java module(s). Java refresh not possible.", new Object[0]);
        return false;
    }

    public final IDeltaDetector createDeltaDetector(IWorkerContext workerContext, IWorkspaceFilter filter, Module module, PrepareRefreshResult result) {
        assert (filter != null) : "Parameter 'filter' of method 'createDeltaDetector' must not be null";
        assert (module != null && module instanceof JavaModule) : "Unexpected class in method 'createDeltaDetector': " + String.valueOf(module);
        return new JavaDeltaDetector((ILanguageProvider)this, filter, module);
    }

    public void aboutToRefreshModules(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener listener) {
        super.aboutToRefreshModules(workerContext, softwareSystem, result, refreshOptions, moduleDeltas, listener);
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToRefreshModules' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'prepareRefresh' must not be null";
        assert (moduleDeltas != null) : "Parameter 'moduleDeltas' of method 'aboutToRefreshModules' must not be null";
        assert (this.m_globalModel == null) : "'m_globalModel' of method 'prepareRefresh' must be null";
        JavaIgnoreAccess ignoreAccess = ((JavaSoftwareSystemSettingsExtension)softwareSystem.getExtension(JavaSoftwareSystemSettingsExtension.class)).aboutToParse();
        JavaTypeRegistry typeRegistry = this.createTypeRegistry(workerContext, softwareSystem);
        UnknownJar classesJar = (UnknownJar)((Object)((JavaExternal)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(JavaExternal.class))).getUniqueExistingChild(UnknownJar.class));
        this.m_globalModel = new JavaGlobalModel(workerContext, (IModelServiceProvider)softwareSystem, ignoreAccess, typeRegistry, classesJar);
        block0: for (Map.Entry<JavaModule, Set<JavaFile>> nextEntry : typeRegistry.getFilesToReparse().entrySet()) {
            JavaModule nextModule = nextEntry.getKey();
            for (ModuleDelta nextModuleDelta : moduleDeltas) {
                if (nextModule != nextModuleDelta.getModule()) continue;
                for (JavaFile nextFile : nextEntry.getValue()) {
                    if (nextModuleDelta.isDeleted((FilePath)nextFile)) continue;
                    nextModuleDelta.modified((FilePath)nextFile);
                }
                continue block0;
            }
        }
        typeRegistry.clearFilesToReparse();
    }

    public void finishApplySnapshot(IWorkerContext workerContext, SoftwareSystem softwareSystem, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishApplySnapshot' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishApplySnapshot' must not be null";
        if (listener != null) {
            JavaFileCreationVisitor visitor = new JavaFileCreationVisitor(listener);
            ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(JavaModule.class).forEach(m -> m.accept(visitor));
        }
        super.finishApplySnapshot(workerContext, softwareSystem, listener);
    }

    public void visitPresentFilePaths(IFilePathListener listener, IModule ... modules) {
        assert (listener != null) : "Parameter 'listener' of method 'visitPresentFilePaths' must not be null";
        assert (modules != null && modules.length > 0) : "Parameter 'modules' of method 'visitPresentFilePaths' must not be empty";
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule nextModule = iModuleArray[n2];
            if (nextModule instanceof JavaModule) {
                ((JavaModule)nextModule).accept(new JavaFilePresentVisitor(listener));
            }
            ++n2;
        }
        super.visitPresentFilePaths(listener, modules);
    }

    public final void refreshModule(IWorkerContext workerContext, ModuleDelta delta, IFilePathListener listener, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refresh' must not be null";
        assert (!delta.isEmpty()) : "'delta' must not be empty";
        assert (this.m_globalModel != null) : "'m_globalModel' of method 'refreshModule' must not be null";
        SoftwareSystem softwareSystem = (SoftwareSystem)delta.getModule().getParent(SoftwareSystem.class, new Class[0]);
        assert (softwareSystem != null) : "'softwareSystem' of method 'refreshModule' must not be null";
        assert (softwareSystem.getCurrentModel() == softwareSystem.getParserModel()) : "Parser model expected - but was: " + String.valueOf(softwareSystem.getCurrentModel());
        DeltaRefreshJob deltaRefreshJob = new DeltaRefreshJob(workerContext, (IAddedOrChangedSourceFileProcessor)this, this.m_globalModel, delta, listener);
        deltaRefreshJob.start();
    }

    public final boolean finishRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, boolean systemWillBeCleared) {
        block10: {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'finishRefresh' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishRefresh' must not be null";
            assert (result != null) : "Parameter 'result' of method 'finishRefresh' must not be null";
            if (this.m_globalModel != null) {
                try {
                    try {
                        if (!systemWillBeCleared) {
                            this.m_globalModel.finishModification(((Workspace)softwareSystem.getUniqueChild(Workspace.class)).getChildren(JavaModule.class), result);
                        }
                    }
                    catch (Throwable t) {
                        result.addWarning((OperationResult.IMessageCause)RefreshMessageCause.EXCEPTION_CAUGHT_DURING_JAVA_REFRESH, t);
                        ((JavaSoftwareSystemSettingsExtension)softwareSystem.getExtension(JavaSoftwareSystemSettingsExtension.class)).parsingFinished(this.m_globalModel.getIgnoreAccess());
                        this.m_globalModel = null;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    ((JavaSoftwareSystemSettingsExtension)softwareSystem.getExtension(JavaSoftwareSystemSettingsExtension.class)).parsingFinished(this.m_globalModel.getIgnoreAccess());
                    this.m_globalModel = null;
                    throw throwable;
                }
                ((JavaSoftwareSystemSettingsExtension)softwareSystem.getExtension(JavaSoftwareSystemSettingsExtension.class)).parsingFinished(this.m_globalModel.getIgnoreAccess());
                this.m_globalModel = null;
            }
        }
        return super.finishRefresh(workerContext, softwareSystem, result, systemWillBeCleared);
    }

    public final FilePath getSourceFile(NamedElement element) {
        assert (element != null) : "Parameter 'namedElement' of method 'getSourceFile' must not be null";
        if (!element.isValid()) {
            return null;
        }
        if ((element = element.getElement()) instanceof LogicalProgrammingElement) {
            element = ((LogicalProgrammingElement)element).getPrimaryProgrammingElement();
        }
        if (element instanceof JavaInternalCompilationUnit) {
            return (FilePath)element;
        }
        if (element instanceof JavaElement) {
            return (FilePath)element.getOriginalParent(JavaInternalCompilationUnit.class);
        }
        if (element instanceof JavaSourceFile) {
            JavaInternalCompilationUnit internalCompilationUnit = (JavaInternalCompilationUnit)((Object)element.getParent(JavaInternalCompilationUnit.class, new Class[0]));
            if (internalCompilationUnit != null && internalCompilationUnit.getPrimarySourceFile() == element) {
                return internalCompilationUnit;
            }
            return (FilePath)element;
        }
        if (element instanceof JavaClassFile) {
            return (FilePath)element.getParent(JavaInternalCompilationUnit.class, new Class[0]);
        }
        return null;
    }

    public String hasTimestampChangedOnDisk(FilePath sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'hasTimestampChangedOnDisk' must not be null";
        if (sourceFile instanceof JavaInternalCompilationUnit && (sourceFile = ((JavaInternalCompilationUnit)sourceFile).getPrimarySourceFile()) == null) {
            return null;
        }
        return super.hasTimestampChangedOnDisk(sourceFile);
    }

    public PhysicalInfo getPhysicalInfo(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getPhysicalInfo' must not be null";
        if (element instanceof JavaClassFile) {
            JavaClassFile classFile = (JavaClassFile)element;
            RootDirectoryPath baseDirectory = classFile.getBaseDirectory();
            if (baseDirectory instanceof RootDirectoryPath) {
                return new PhysicalInfo(baseDirectory, classFile.getPath(), classFile.getFile().getName());
            }
        } else if (element instanceof JavaPackageFragment) {
            JavaPackageFragment packageFragment = (JavaPackageFragment)element;
            RootDirectoryPath rootDirectoryPath = (RootDirectoryPath)packageFragment.getOriginalParent(RootDirectoryPath.class);
            if (rootDirectoryPath != null) {
                return new PhysicalInfo(rootDirectoryPath, "./" + packageFragment.getOriginalName().replace('.', '/'), packageFragment.getOriginalShortName());
            }
        } else {
            RootDirectoryPath baseDirectory;
            List<JavaClassFile> classFiles;
            JavaFile physicalFile = null;
            FilePath filePath = this.getSourceFile(element);
            if (filePath instanceof JavaSourceFile) {
                physicalFile = (JavaSourceFile)filePath;
            } else if (filePath instanceof JavaInternalCompilationUnit && (physicalFile = ((JavaInternalCompilationUnit)filePath).getPrimarySourceFile()) == null && !(classFiles = ((JavaInternalCompilationUnit)filePath).getPrimaryClassFiles()).isEmpty()) {
                physicalFile = classFiles.get(0);
            }
            if (physicalFile != null && (baseDirectory = physicalFile.getBaseDirectory()) instanceof RootDirectoryPath) {
                return new PhysicalInfo(baseDirectory, physicalFile.getPath(), physicalFile.getFile().getName());
            }
        }
        return null;
    }

    public final Set<String> getKeywords(IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'getKeywords' must not be null";
        if (fileType.equals((Object)JavaFileType.JAVA_FILE)) {
            return JavaKeywords.getJavaKeywords();
        }
        if (fileType.equals((Object)JavaFileType.GROOVY_FILE)) {
            return JavaKeywords.getGroovyKeywords();
        }
        if (fileType.equals((Object)JavaFileType.KOTLIN_FILE)) {
            return JavaKeywords.getKotlinKeywords();
        }
        if (fileType.equals((Object)JavaFileType.ASPECTJ_FILE)) {
            return JavaKeywords.getAspectJKeywords();
        }
        if (fileType.equals((Object)JavaFileType.SCALA_FILE)) {
            return JavaKeywords.getScalaKeywords();
        }
        assert (false) : "Unhandled file type: " + String.valueOf(fileType);
        return Collections.emptySet();
    }

    public final void accept(ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'accept' must not be null";
        JavaFamilySourceLineVisitor.process((ISourceFileRegionVisitor)visitor, (String)content, this.getKeywords(fileType));
    }

    public final void clearSystem(SoftwareSystem softwareSystem, boolean onRefresh) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clear' must not be null";
        this.m_globalModel = null;
        super.clearSystem(softwareSystem, onRefresh);
    }

    public final IAdditionalFileInfoProvider getPersistenceProvider(Installation installation) {
        return new JavaPersistenceProvider(installation);
    }

    public final IAdditionalDynamicInfoProvider getDynamicSystemInfoProvider() {
        return new JavaDynamicSystemInfoProvider();
    }

    public final IProviderId getProviderId() {
        return JavaProviderId.INSTANCE;
    }

    public void initialize(Installation installation, IFinishModelProcessor finishModelProcessor) {
        super.initialize(installation, finishModelProcessor);
        this.m_installation = installation;
    }

    public void initialize(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super.initialize(softwareSystem, finishModelProcessor);
        assert (this.m_installation != null) : "'m_installation' of method 'initialize' must not be null";
        softwareSystem.addExtension((Extension)new JavaSoftwareSystemSettingsExtension(this.m_installation, softwareSystem));
    }

    public final LogicalNamespaceRoot createLogicalNamespaceRoot(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createLogicalNamespaceRoot' must not be null";
        return new JavaLogicalNamespaceRoot(parent);
    }

    public final ExternalLogicalNamespaceRoot createExternalLogicalNamespaceRoot(NamedElement parent, NamedElement external, LogicalNamespaceScope scope) {
        assert (parent != null) : "Parameter 'parent' of method 'createExternalLogicalNamespaceRoot' must not be null";
        assert (external != null) : "Parameter 'external' of method 'createExternalLogicalNamespaceRoot' must not be null";
        return new JavaExternalLogicalNamespaceRoot(parent, external, scope);
    }

    protected void checkSoftwareSystemSettings(Workspace sourceWorkspace, Workspace targetWorkspace, OperationResult result) {
        JavaSoftwareSystemSettingsExtension.checkSoftwareSystemSettings(sourceWorkspace, targetWorkspace, result);
    }

    public final void aboutToCreateFirstModule(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToCreateFirstModule' must not be null";
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        JavaExternal external = (JavaExternal)((Object)workspace.getUniqueChild(JavaExternal.class));
        assert (external == null) : "'external' of method 'aboutToCreateFirstModule' must be null";
        external = new JavaExternal((NamedElement)workspace);
        workspace.addChild((NamedElement)external);
        external.addChild((NamedElement)new UnknownJar((NamedElement)external));
        JavaSoftwareSystemSettingsExtension.aboutToCreateFirstModule(workspace);
        super.aboutToCreateFirstModule(softwareSystem);
    }

    public final void lastModuleDeleted(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'lastModuleDeleted' must not be null";
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        ((JavaExternal)((Object)workspace.getUniqueExistingChild(JavaExternal.class))).remove();
        JavaSoftwareSystemSettingsExtension.lastModuleDeleted(workspace);
        super.lastModuleDeleted(softwareSystem);
    }

    protected final Module.IModuleType getModuleType(String moduleTypeStandardName) {
        assert (moduleTypeStandardName != null) : "Parameter 'moduleTypeStandardName' of method 'getModuleType' must not be null";
        try {
            return JavaModule.JavaModuleType.fromStandardName(moduleTypeStandardName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    protected final Module createModule(SoftwareSystem softwareSystem, Module.IModuleType type, String id, String name, String description) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createSpecificModule' must not be null";
        assert (type instanceof JavaModule.JavaModuleType) : "Not a Java module type: " + type.getClass().getSimpleName();
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createModule' must not be empty";
        JavaModule module = new JavaModule((NamedElement)softwareSystem.getUniqueExistingChild(Workspace.class), name, id);
        if (description != null) {
            module.setDescription(description);
        }
        ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).addChild((NamedElement)module);
        return module;
    }

    public final LogicalSystemNamespace createLogicalSystemNamespace(NamedElement parent, String name) {
        return new JavaLogicalSystemNamespace(parent, name);
    }

    public final LogicalModuleNamespace createLogicalModuleNamespace(NamedElement parent, String name) {
        return new JavaLogicalModuleNamespace(parent, name);
    }

    protected final Class<? extends External> getExternalClass() {
        return JavaExternal.class;
    }

    protected final Class<? extends Module> getModuleClass() {
        return JavaModule.class;
    }

    protected final RelevantSourceLinesScanner.ScannerInfo getScannerInfo() {
        return new RelevantSourceLinesScanner.ScannerInfo(IMPORT_START_TOKENS);
    }

    public final OperationResult.IMessageCause manualWorkspaceDependencyCreationSupported(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to) {
        assert (from != null) : "Parameter 'from' of method 'manualWorkspaceDependencyCreationSupported' must not be null";
        assert (to != null) : "Parameter 'to' of method 'manualWorkspaceDependencyCreationSupported' must not be null";
        assert (from != to) : "Same instance";
        if (from instanceof JavaModule && to instanceof JavaModule && ((JavaModule)from).getType().equals((Object)JavaModule.JavaModuleType.MANUAL) && ((JavaModule)to).getType().equals((Object)JavaModule.JavaModuleType.MANUAL)) {
            return from.getOutgoingWorkspaceDependency(to) != null ? LanguageProviderMessageCause.WORKSPACE_DEPENDENCY_ALREADY_DEFINED : null;
        }
        return LanguageProviderMessageCause.MANUAL_WORKSPACE_DEPENDENCY_NOT_SUPPORTED;
    }

    public final WorkspaceDependency createManualWorkspaceDependency(SoftwareSystem softwareSystem, IWorkspaceDependencyElement from, IWorkspaceDependencyElement to) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createManualWorkspaceDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'createManualWorkspaceDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'createManualWorkspaceDependency' must not be null";
        assert (this.manualWorkspaceDependencyCreationSupported(from, to) == null) : "Dependency creation not supported: " + String.valueOf(from) + "->" + String.valueOf(to);
        return ((JavaWorkspaceExtension)softwareSystem.getExtension(JavaWorkspaceExtension.class)).createWorkspaceDependency(from, to, JavaWorkspaceDependency.DependencyType.MANUAL_DEPENDENCY);
    }

    public final WorkspaceDependency createWorkspaceDependency(SoftwareSystem softwareSystem, IWorkspaceDependencyElement from, String toId, String toName, String type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createWorkspaceDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'createWorkspaceDependency' must not be null";
        assert (toId != null && toId.length() > 0) : "Parameter 'to' of method 'createWorkspaceDependency' must not be empty";
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'createWorkspaceDependency' must not be empty";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'createWorkspaceDependency' must not be empty";
        assert (dependencyData != null) : "Parameter 'dependencyData' of method 'createWorkspaceDependency' must not be null";
        try {
            JavaWorkspaceDependency.DependencyType javaDependencyType = JavaWorkspaceDependency.DependencyType.fromStandardName(type);
            IWorkspaceDependencyElement endpoint = this.findWorkspaceDependencyElement((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class), from, javaDependencyType, toId, toName, dependencyData, false);
            return JavaWorkspaceExtension.createWorkspaceDependency(from, endpoint, toId, toName, javaDependencyType, dependencyData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public final void clearExternal(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clear' must not be null";
        ((UnknownJar)((Object)((JavaExternal)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(JavaExternal.class))).getUniqueExistingChild(UnknownJar.class))).forgetChildren(true);
    }

    @Override
    public final void aboutToMoveWorkspaceElements(IWorkerContext workerContext, SoftwareSystem softwareSystem, Module module, List<NamedElement> workspaceElements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToMoveWorkspaceElements' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToMoveWorkspaceElements' must not be null";
        assert (module != null && module instanceof JavaModule) : "Unexpected class in method 'aboutToMoveWorkspaceElements': " + String.valueOf(module);
        assert (workspaceElements != null && !workspaceElements.isEmpty()) : "Parameter 'workspaceElements' of method 'aboutToMoveWorkspaceElements' must not be empty";
        ArrayList<NamedElement> rootDirectories = new ArrayList<NamedElement>();
        for (NamedElement nextWorkspaceElement : workspaceElements) {
            if (nextWorkspaceElement instanceof JavaClassRootDirectoryPath || nextWorkspaceElement instanceof JavaSourceRootDirectoryPath) {
                rootDirectories.add(nextWorkspaceElement);
                assert (module == nextWorkspaceElement.getParent(Module.class, new Class[0])) : "Modules not matching";
                continue;
            }
            if (nextWorkspaceElement instanceof JavaModule) {
                assert (module == nextWorkspaceElement) : "Modules not matching";
                continue;
            }
            assert (false) : "Unhandled class: " + String.valueOf(nextWorkspaceElement);
        }
        if (!rootDirectories.isEmpty()) {
            this.aboutToDeleteWorkspaceElements(workerContext, softwareSystem, module, rootDirectories);
        }
    }

    protected final List<IStructureItem> getPhysicalStructureItems() {
        return Arrays.asList(JavaStructureItem.values());
    }

    protected final CoreAccess getSystemAccess(Installation installation, SoftwareSystem system, IMetricIdProvider metricIdProvider, ScriptApi api) {
        assert (installation != null) : "Parameter 'installation' of method 'getSystemAccess' must not be null";
        assert (system != null) : "Parameter 'system' of method 'getSystemAccess' must not be null";
        return new JavaAccess(installation, system, metricIdProvider, api);
    }

    public final String getBundleId() {
        return "com.hello2morrow.sonargraph.language.provider.java";
    }

    public final LanguageProviderRefactoringAdapter getRefactoringAdapter() {
        return this.m_refactoringAdapter;
    }

    public LanguageProviderRefactoringDescriptorProvider getRefactoringDescriptorProvider() {
        return new JavaRefactoringDescriptorProvider();
    }

    public final RootPathType getRootPathTypeForModuleMatching() {
        return RootPathType.NON_STANDARD;
    }

    public final List<? extends RootDirectoryPath> getRootDirectoryPaths(Module module, RootPathType type) {
        assert (module != null) : "Parameter 'module' of method 'getRootDirectoryPaths' must not be null";
        assert (type != null) : "Parameter 'type' of method 'getRootDirectoryPaths' must not be null";
        switch (type) {
            case STANDARD: {
                return module.getChildren(JavaClassRootDirectoryPath.class);
            }
            case NON_STANDARD: {
                return module.getChildren(JavaSourceRootDirectoryPath.class);
            }
        }
        assert (false) : "Unhandled type: " + String.valueOf(type);
        return Collections.emptyList();
    }

    public final boolean createMissingRootDirectoryPathOnSync(RootPathType type) {
        assert (type != null) : "Parameter 'type' of method 'createMissingRootDirectoryPathOnSync' must not be null";
        switch (type) {
            case STANDARD: {
                return true;
            }
            case NON_STANDARD: {
                return false;
            }
        }
        assert (false) : "Unhandled type: " + String.valueOf(type);
        return false;
    }

    public final List<IAssignableAttributeRetriever> createAssignableAttributeRetrievers() {
        return Arrays.asList(new IAssignableAttributeRetriever[]{new JavaAnnotationRetriever(), new JavaExtendsClassRetriever(), new JavaExtendsImplementsInterfaceRetriever(), new JavaImplementsInterfaceRetriever(), new JavaAnnotationValueRetriever(), new JavaTypeOfRetriever(), new JavaIsClassRetriever(), new JavaIsInterfaceRetriever(), new JavaBelongsToAggregateRootRetriever()});
    }

    public final Double computeLanguageSpecificMaintainabilityLevel(SoftwareSystem system, Module module) {
        assert (system != null) : "Parameter 'system' of method 'computeLanguageSpecificMaintainabilityLevel' must not be null";
        assert (module != null) : "Parameter 'module' of method 'computeLanguageSpecificMaintainabilityLevel' must not be null";
        IMetricAccessor ma = (IMetricAccessor)((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricAccessor.class);
        Number relativePackageCyclicity = ma.getMetricValue(system, (NamedElement)module, (IMetricLevel)CoreMetricLevel.MODULE, (IMetricId)JavaMetricId.JAVA_RELATIVE_CYCLICITY_PACKAGES, false);
        if (relativePackageCyclicity == null) {
            return null;
        }
        Number numberOfPackages = ma.getMetricValue(system, (NamedElement)module, (IMetricLevel)CoreMetricLevel.MODULE, (IMetricId)JavaMetricId.JAVA_PACKAGES_FULLY_ANALYZED, false);
        if (numberOfPackages == null) {
            return null;
        }
        double ml = 100.0 - relativePackageCyclicity.doubleValue();
        double np = numberOfPackages.doubleValue();
        if (np < 20.0) {
            ml = 100.0 * (20.0 - np) / 20.0 + np / 20.0 * ml;
        }
        return ml;
    }

    public void addPluginAccess(Installation installation, SoftwareSystem softwareSystem, Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> access) {
        assert (installation != null) : "Parameter 'installation' of method 'addPluginAccess' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addPluginAccess' must not be null";
        assert (access != null) : "Parameter 'access' of method 'addPluginAccess' must not be null";
        access.put(IPluginJavaAccess.class, (IPluginCoreAccess)new PluginJavaAccess(installation, softwareSystem));
    }
}

