/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm.git.controller;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.scm.ConfigurationException;
import com.hello2morrow.sonargraph.scm.ICommitRetriever;
import com.hello2morrow.sonargraph.scm.ICommitRetrieverFactory;
import com.hello2morrow.sonargraph.scm.IScmDataAndConfigurationProvider;
import com.hello2morrow.sonargraph.scm.RetrieveException;
import com.hello2morrow.sonargraph.scm.ScmManager;
import com.hello2morrow.sonargraph.scm.git.controller.GitCommitRetriever;
import com.hello2morrow.sonargraph.scm.git.controller.GitRepository;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitCommitRetrieverFactory
implements ICommitRetrieverFactory {
    public static final String SCM_NAME = "Git";
    private static final Logger LOGGER = LoggerFactory.getLogger(GitCommitRetrieverFactory.class);
    private static final String DOT_GIT = ".git";
    private static final String GIT_REPOS = "git.repos";

    public GitCommitRetrieverFactory() {
        LOGGER.debug("[" + String.valueOf(this) + "] Instantiated");
        ScmManager.getInstance().addCommitRetrieverFactory((ICommitRetrieverFactory)this);
    }

    public synchronized boolean autoDetect(IScmDataAndConfigurationProvider configProvider) {
        assert (configProvider != null) : "Parameter 'configProvider' of method 'autoDetect' must not be null";
        try {
            this.getGitRoots(configProvider);
        }
        catch (Exception e) {
            LOGGER.error("Git auto-detection failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public ICommitRetriever create(IScmDataAndConfigurationProvider configProvider) throws ConfigurationException, RetrieveException {
        assert (configProvider != null) : "Parameter 'configProvider' of method 'create' must not be null";
        List<GitRepository> repositories = this.getGitRoots(configProvider);
        return new GitCommitRetriever(repositories, configProvider.getBaseDirectory(), configProvider.getFileExtensions());
    }

    public String getScmName() {
        return SCM_NAME;
    }

    private String getCurrentBranch(File repositoryDir) throws RetrieveException {
        assert (repositoryDir != null);
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setGitDir(repositoryDir);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Repository repository = builder.build();){
                if (repository.isBare()) {
                    throw new RetrieveException("Repository is empty");
                }
                String branchName = repository.getBranch();
                if (branchName == null) {
                    throw new RetrieveException("Could not determine current branch");
                }
                return branchName;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    private TFile readDotGitFile(TFile dotGit) {
        TFile result = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)dotGit));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("gitDir: ")) continue;
                    String dir = line.substring(7).trim();
                    result = new TFile((File)dotGit.getParentFile(), dir);
                    if (!result.isDirectory()) {
                        result = null;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("failed to read from " + dotGit.getPath(), (Throwable)e);
        }
        return result;
    }

    public List<File> detectRepositoryRoots(IScmDataAndConfigurationProvider configProvider) throws ConfigurationException {
        List<GitRepository> roots = this.detectGitRoots(configProvider, false);
        return roots.stream().map(root -> root.getFile().getParentFile()).collect(Collectors.toList());
    }

    private List<GitRepository> detectGitRoots(IScmDataAndConfigurationProvider configProvider, boolean evaluateDotGitFiles) throws ConfigurationException {
        assert (configProvider != null) : "Parameter 'configProvider' of method 'detectGitRoot' must not be null";
        List sourceRoots = configProvider.getSourceRootDirectories();
        THashSet checkedDirs = new THashSet();
        ArrayList<GitRepository> gitRepositories = new ArrayList<GitRepository>();
        Iterator iterator = sourceRoots.iterator();
        block0: while (iterator.hasNext()) {
            TFile sourceRoot;
            TFile dir = sourceRoot = (TFile)iterator.next();
            while (checkedDirs.add(dir)) {
                TFile dotGit = new TFile((File)dir, DOT_GIT);
                if (dotGit.isFile() && evaluateDotGitFiles) {
                    TFile gitDir = this.readDotGitFile(dotGit);
                    if (gitDir == null) continue block0;
                    String relativeGitRoot = FileUtility.calculateRelativePath((TFile)dotGit.getParentFile(), (TFile)configProvider.getBaseDirectory());
                    gitRepositories.add(new GitRepository((File)gitDir, relativeGitRoot + "/"));
                    continue block0;
                }
                if (dotGit.isDirectory() || dotGit.isFile()) {
                    String relativeGitRoot = FileUtility.calculateRelativePath((TFile)dotGit.getParentFile(), (TFile)configProvider.getBaseDirectory());
                    gitRepositories.add(new GitRepository((File)dotGit, relativeGitRoot + "/"));
                    continue block0;
                }
                if ((dir = dir.getParentFile()) != null) continue;
                continue block0;
            }
        }
        if (gitRepositories.isEmpty()) {
            throw new ConfigurationException("Unable to locate any Git root directory.");
        }
        return gitRepositories;
    }

    private List<GitRepository> getGitRoots(IScmDataAndConfigurationProvider configProvider) throws ConfigurationException, RetrieveException {
        assert (configProvider != null) : "Parameter 'configProvider' of method 'getGitRoot' must not be null";
        List<GitRepository> repositories = (List<GitRepository>)configProvider.retrieveProperty(GIT_REPOS, List.class);
        if (repositories == null) {
            repositories = this.detectGitRoots(configProvider, true);
            configProvider.storeProperty(GIT_REPOS, repositories);
        }
        for (GitRepository repo : repositories) {
            repo.setBranch(this.getCurrentBranch(repo.getFile()));
        }
        return repositories;
    }
}

