/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpFileType;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CSharpProjectFile
extends FilePath {
    private String m_configurationName;
    private String m_platform;
    private TFile m_solutionDir;
    private TFile m_solutionFile;
    private String m_projectFilePathWithEnvVars;
    private final List<String> m_nugetPackageFolders = new ArrayList<String>();

    public CSharpProjectFile(NamedElement parent) {
        super(parent);
    }

    public CSharpProjectFile(NamedElement parent, String path) {
        super(parent, path);
        this.getFile();
    }

    public CSharpProjectFile(NamedElement parent, TFile csharpProjectFile) {
        super(parent, csharpProjectFile);
    }

    public void setFilePathWithEnvVars(String filePathWithEnvVars) {
        assert (filePathWithEnvVars != null && filePathWithEnvVars.length() > 0) : "Parameter 'filePathWithEnvVars' of method 'setFilePathWithEnvVars' must not be empty";
        this.m_projectFilePathWithEnvVars = filePathWithEnvVars;
    }

    public String getFilePathWithEnvVars() {
        return this.m_projectFilePathWithEnvVars;
    }

    public IFileType getFileType() {
        return CSharpFileType.PROJECT_FILE;
    }

    public void setConfiguration(String configurationName) {
        assert (configurationName != null) : "Parameter 'configurationName' of method 'setConfigurationName' must not be null";
        this.m_configurationName = configurationName;
    }

    public String getConfiguration() {
        return this.m_configurationName;
    }

    public void setPlatform(String platform) {
        assert (platform != null) : "Parameter 'platform' of method 'setPlatform' must not be null";
        this.m_platform = platform;
    }

    public String getPlatform() {
        return this.m_platform;
    }

    @Deprecated
    public void setSolutionDir(TFile solutionDir) {
        this.m_solutionDir = solutionDir;
    }

    @Deprecated
    public TFile getSolutionDir() {
        if (this.m_solutionDir == null && this.m_solutionFile != null) {
            return this.m_solutionFile.getParentFile();
        }
        return this.m_solutionDir;
    }

    public void setSolutionFile(TFile file) {
        this.m_solutionFile = file;
    }

    public TFile getSolutionFile() {
        return this.m_solutionFile;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpProjectFile(this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        StringBuilder builder = new StringBuilder();
        for (String next : this.m_nugetPackageFolders) {
            builder.append(next).append(";");
        }
        writer.writeString(builder.toString());
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() >= 18) {
            String flattenedFolders = reader.readString();
            String[] stringArray = flattenedFolders.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                String trimmed = next.trim();
                if (trimmed.length() > 0) {
                    this.m_nugetPackageFolders.add(trimmed);
                }
                ++n2;
            }
        }
    }

    public void setNugetPackageFolders(List<String> nugetPackageFolders) {
        assert (nugetPackageFolders != null) : "Parameter 'nugetPackageFolders' of method 'setNugetPackageFolders' must not be null";
        this.m_nugetPackageFolders.clear();
        this.m_nugetPackageFolders.addAll(nugetPackageFolders);
    }

    public List<String> getNugetPackageFolders() {
        return this.m_nugetPackageFolders;
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCSharpProjectFile(CSharpProjectFile var1);
    }
}

