/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn;

import com.hello2morrow.sonargraph.api.csharp.CSharpTypeKind;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.IDependencyFactory;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.ModelRoot;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.RoslynDependencyType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpProjectFileDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpSourceFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpEnumConstant;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpEvent;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpExternalRoslynType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpField;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpGeneratedWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpLogicalTypeHelper;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMember;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethod;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethodType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethodWithBody;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpNamespaceFragment;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpProperty;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpVisualStudioProjectToAssemblyWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpVisualStudioProjectWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.CallDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ExplicitConversion;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ExtendsDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.HasAttributeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ImplementsDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.NewDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ReadDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.UsesDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.WriteDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpAssembly;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpRoslynModule;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpModelBuilder
implements IDependencyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpModelBuilder.class);
    private final SoftwareSystem m_softwareSystem;
    private final Map<String, String> m_moduleIds = new THashMap();
    private final Map<String, Integer> m_metaDataTable = new THashMap();
    private final Map<Integer, CSharpProgrammingElement> m_objectTable = new THashMap();
    private final List<DependencyProcessor> m_dependencyProcessors = new ArrayList<DependencyProcessor>();
    private boolean m_isExternal = false;
    private final IAddedOrChangedSourceFileProcessor m_sourceProcessor;
    private final List<Pair<CSharpRoslynModule, List<String>>> m_moduleDependencies = new ArrayList<Pair<CSharpRoslynModule, List<String>>>();
    private final Map<String, IWorkspaceDependencyElement> m_endPoints = new THashMap();
    private final Map<String, CSharpSourceFile> m_sourceMap = new THashMap();

    public CSharpModelBuilder(SoftwareSystem softwareSystem, IAddedOrChangedSourceFileProcessor sourceProcessor) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'CSharpModelBuilder' must not be null";
        assert (sourceProcessor != null) : "Parameter 'sourceProcessor' of method 'CSharpModelBuilder' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_sourceProcessor = sourceProcessor;
        for (CSharpModule module : ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CSharpModule.class)) {
            this.m_moduleIds.put(module.getShortName(), module.getId());
        }
    }

    public NamedElement buildModel(JSONObject jsonModel) {
        assert (jsonModel != null) : "Parameter 'jsonModel' of method 'CSharpModelBuilder' must not be null";
        JSONArray metas = (JSONArray)jsonModel.get((Object)"MetaData");
        for (Object obj : metas) {
            JSONObject meta = (JSONObject)obj;
            String name = (String)meta.get((Object)"MetaName");
            JSONArray fields = (JSONArray)meta.get((Object)"FieldNames");
            int i = 0;
            while (i < fields.size()) {
                String fieldName = (String)fields.get(i);
                this.m_metaDataTable.put(name + ":" + fieldName, i);
                ++i;
            }
        }
        JSONObject root = (JSONObject)jsonModel.get((Object)"Root");
        NamedElement result = this.processObject(root, null);
        this.m_dependencyProcessors.forEach(proc -> proc.run(this));
        this.m_dependencyProcessors.clear();
        for (Pair<CSharpRoslynModule, List<String>> item : this.m_moduleDependencies) {
            CSharpRoslynModule from = (CSharpRoslynModule)((Object)item.getFirst());
            for (String targetName : (List)item.getSecond()) {
                IWorkspaceDependencyElement to = this.m_endPoints.get(targetName);
                if (to == null) continue;
                CSharpGeneratedWorkspaceDependency dep = to instanceof CSharpAssembly ? new CSharpVisualStudioProjectToAssemblyWorkspaceDependency((IWorkspaceDependencyElement)from, to) : new CSharpVisualStudioProjectWorkspaceDependency((IWorkspaceDependencyElement)from, to);
                from.addOutgoingWorkspaceDependency(dep);
            }
        }
        return result;
    }

    @Override
    public CSharpProgrammingElement resolveElement(int id) {
        CSharpProgrammingElement result = this.m_objectTable.get(id);
        assert (result != null);
        return result;
    }

    private <T> T getProperty(String fieldName, String className, JSONArray fields, Class<T> type) {
        Integer index = this.m_metaDataTable.get(className + ":" + fieldName);
        assert (index != null);
        return (T)fields.get(index.intValue());
    }

    private NamedElement handleModule(NamedElement parent, JSONArray fields, String className) {
        String name = this.getProperty("Name", className, fields, String.class);
        String path = this.getProperty("Path", className, fields, String.class);
        String projectName = this.getProperty("ProjectName", className, fields, String.class);
        List dependsUpon = this.getProperty("DependsUpon", className, fields, List.class);
        String id = this.m_moduleIds.get(name);
        if (id == null) {
            id = StringUtility.createTimebasedId((String)name);
        }
        CSharpRoslynModule module = new CSharpRoslynModule(parent, name, id, projectName);
        TFile filePath = new TFile(path);
        CSharpProjectFileDirectoryPath rootDir = new CSharpProjectFileDirectoryPath((IModelServiceProvider)this.m_softwareSystem, (NamedElement)module, filePath.getParentFile());
        module.addChild((NamedElement)rootDir);
        module.setRootPath(rootDir.getPath());
        parent.addChild((NamedElement)module);
        this.m_moduleDependencies.add((Pair<CSharpRoslynModule, List<String>>)new Pair((Object)module, (Object)dependsUpon));
        this.m_endPoints.put(module.getShortName(), (IWorkspaceDependencyElement)module);
        return rootDir;
    }

    private NamedElement handleSourceFile(NamedElement parent, JSONArray fields, String className) {
        String path = this.getProperty("Path", className, fields, String.class);
        String logicalPath = this.getProperty("LogicalPath", className, fields, String.class);
        TFile sourceFilePath = new TFile(path);
        assert (parent instanceof RootDirectoryPath);
        RootDirectoryPath rootPath = (RootDirectoryPath)parent;
        CSharpSourceFile source = null;
        if (rootPath.getDirectoryFile().isParentOf((File)sourceFilePath)) {
            String relPath = FileUtility.calculateRelativePath((TFile)sourceFilePath.getParentFile(), (TFile)rootPath.getDirectoryFile());
            IDirectoryPath directoryPath = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)rootPath, (String)relPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

                public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                    return new CSharpDirectoryFragment(msp, parent, name);
                }
            });
            source = new CSharpSourceFile((IModelServiceProvider)this.m_softwareSystem, directoryPath.getNamedElement(), sourceFilePath);
            directoryPath.getNamedElement().addChild((NamedElement)source);
        } else {
            assert (logicalPath != null);
            IDirectoryPath directoryPath = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)rootPath, (String)logicalPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

                public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                    return new CSharpDirectoryFragment(msp, parent, name);
                }
            });
            source = new CSharpSourceFile((IModelServiceProvider)this.m_softwareSystem, directoryPath.getNamedElement(), sourceFilePath);
            directoryPath.getNamedElement().addChild((NamedElement)source);
        }
        this.m_sourceProcessor.processAddedOrChangedSourceFile((SourceFile)source);
        this.m_sourceMap.put(path, source);
        return source;
    }

    public CSharpSourceFile getSource(String path) {
        return this.m_sourceMap.get(path);
    }

    private NamedElement buildNamespaceFragments(NamedElement parent, String[] fragments) {
        int i = 0;
        while (i < fragments.length) {
            String fragName = fragments[i];
            Object namespaceFragment = (NamedElement)parent.getFirstChild(c -> c.getShortName().equals(fragName), CSharpNamespaceFragment.class);
            if (namespaceFragment == null) {
                namespaceFragment = new CSharpNamespaceFragment((IModelServiceProvider)this.m_softwareSystem, parent, fragName);
                parent.addChild(namespaceFragment);
            }
            parent = namespaceFragment;
            ++i;
        }
        return parent;
    }

    private CSharpType handleType(NamedElement parent, JSONArray fields, String className) {
        CSharpType type;
        int id = this.getProperty("Id", className, fields, Number.class).intValue();
        String name = this.getProperty("Name", className, fields, String.class);
        int lineNumber = this.getProperty("LineNumber", className, fields, Number.class).intValue();
        String access = this.getProperty("Access", className, fields, String.class);
        boolean isStatic = this.getProperty("IsStatic", className, fields, Boolean.class);
        boolean isAbstract = this.getProperty("IsAbstract", className, fields, Boolean.class);
        JSONArray dependencies = this.getProperty("Dependencies", className, fields, JSONArray.class);
        String kind = this.getProperty("Kind", className, fields, String.class);
        String namespace = this.getProperty("Namespace", className, fields, String.class);
        boolean isPartial = this.getProperty("IsPartial", className, fields, Boolean.class);
        JSONArray typeParameters = this.getProperty("TypeParameters", className, fields, JSONArray.class);
        int prevId = this.getProperty("PreviousId", className, fields, Number.class).intValue();
        CSharpTypeKind typeKind = CSharpTypeKind.valueOf((String)kind);
        CSharpAccessSpecifier accessSpecifier = CSharpAccessSpecifier.valueOf(StringUtility.convertStandardNameToConstantName((String)access));
        if (namespace != null && namespace.length() > 0) {
            parent = this.buildNamespaceFragments(parent, namespace.split("\\."));
        }
        String[] tp = null;
        if (typeParameters != null) {
            tp = (String[])typeParameters.toArray((Object[])new String[typeParameters.size()]);
        }
        if (this.m_isExternal && !(parent instanceof CSharpType)) {
            type = new CSharpExternalRoslynType((IModelServiceProvider)this.m_softwareSystem, parent, name, tp, typeKind);
        } else {
            type = new CSharpType((IModelServiceProvider)this.m_softwareSystem, parent, name, tp, typeKind);
            if (isPartial && !parent.isExternal()) {
                CSharpLogicalTypeHelper.processNonExternalPartialType(parent, type);
            }
        }
        type.setStatic(isStatic);
        type.setAbstract(isAbstract);
        type.setLineNumber(lineNumber);
        type.setAccessSpecifier(accessSpecifier);
        if (isPartial) {
            type.setPartial(true);
            if (prevId != 0) {
                CSharpType prev = (CSharpType)this.m_objectTable.get(prevId);
                assert (prev != null);
                prev.addPartialFragment(type);
            }
        }
        this.m_objectTable.put(id, type);
        if (dependencies != null) {
            this.handleDependencies(type, id, dependencies);
        }
        parent.addChild((NamedElement)type);
        return type;
    }

    private CSharpType handleDelegate(NamedElement parent, JSONArray fields, String className) {
        CSharpType type = this.handleType(parent, fields, className);
        String sig = this.getProperty("Signature", className, fields, String.class);
        type.setSignature(sig);
        return type;
    }

    @Override
    public void addDependency(CSharpProgrammingElement from, RoslynDependencyType kind, int lineNumber, CSharpProgrammingElement target) {
        Object dep = null;
        switch (kind) {
            case Attribute: {
                dep = new HasAttributeDependency((ProgrammingElement)from, (ProgrammingElement)target, lineNumber);
                break;
            }
            case Call: {
                dep = new CallDependency((ProgrammingElement)from, (ProgrammingElement)target, lineNumber);
                break;
            }
            case Cast: {
                dep = new ExplicitConversion((ProgrammingElement)from, (ProgrammingElement)target, lineNumber);
                break;
            }
            case Extends: {
                dep = new ExtendsDependency((ProgrammingElement)from, (ProgrammingElement)target);
                break;
            }
            case Implements: {
                dep = new ImplementsDependency((ProgrammingElement)from, (ProgrammingElement)target);
                break;
            }
            case New: {
                dep = new NewDependency((ProgrammingElement)from, (ProgrammingElement)target, lineNumber);
                break;
            }
            case Read: {
                dep = new ReadDependency((ProgrammingElement)from, (ProgrammingElement)target, lineNumber);
                break;
            }
            case Uses: {
                dep = new UsesDependency((ProgrammingElement)from, (ProgrammingElement)target, lineNumber);
                break;
            }
            case Write: {
                dep = new WriteDependency((ProgrammingElement)from, (ProgrammingElement)target, lineNumber);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        from.addDependency((ParserDependency)dep);
    }

    private void handleDependencies(CSharpProgrammingElement from, int id, JSONArray dependencies) {
        for (Object obj : dependencies) {
            JSONObject dep = (JSONObject)obj;
            JSONArray depFields = (JSONArray)dep.get((Object)"Fields");
            int targetId = this.getProperty("TargetId", "Dependency", depFields, Number.class).intValue();
            RoslynDependencyType depKind = RoslynDependencyType.valueOf(this.getProperty("Kind", "Dependency", depFields, String.class));
            int depLine = this.getProperty("LineNumber", "Dependency", depFields, Number.class).intValue();
            if (targetId <= id) {
                CSharpProgrammingElement target = this.m_objectTable.get(targetId);
                if (target == null) {
                    LOGGER.error(String.format("Unknown dependency target %d -> %d (kind=%s)", id, targetId, depKind != null ? depKind.name() : "null"));
                    LOGGER.error(String.format("%s: %d", ((SourceFile)from.getParent(SourceFile.class, new Class[0])).getName(), depLine));
                    continue;
                }
                this.addDependency(from, depKind, depLine, target);
                continue;
            }
            this.m_dependencyProcessors.add(new DependencyProcessor(from, targetId, depKind, depLine));
        }
    }

    private NamedElement handleEnumMember(NamedElement parent, JSONArray fields, String className) {
        int id = this.getProperty("Id", className, fields, Number.class).intValue();
        String name = this.getProperty("Name", className, fields, String.class);
        int lineNumber = this.getProperty("LineNumber", className, fields, Number.class).intValue();
        String access = this.getProperty("Access", className, fields, String.class);
        CSharpEnumConstant result = new CSharpEnumConstant((IModelServiceProvider)this.m_softwareSystem, parent, name);
        CSharpAccessSpecifier accessSpecifier = CSharpAccessSpecifier.valueOf(StringUtility.convertStandardNameToConstantName((String)access));
        result.setAccessSpecifier(accessSpecifier);
        result.setLineNumber(lineNumber);
        result.setSignature("int");
        this.m_objectTable.put(id, result);
        parent.addChild((NamedElement)result);
        return result;
    }

    private NamedElement handleTypedElement(NamedElement parent, JSONArray fields, String className) {
        int id = this.getProperty("Id", className, fields, Number.class).intValue();
        String name = this.getProperty("Name", className, fields, String.class);
        int lineNumber = this.getProperty("LineNumber", className, fields, Number.class).intValue();
        String access = this.getProperty("Access", className, fields, String.class);
        CSharpAccessSpecifier accessSpecifier = CSharpAccessSpecifier.valueOf(StringUtility.convertStandardNameToConstantName((String)access));
        boolean isStatic = this.getProperty("IsStatic", className, fields, Boolean.class);
        boolean isAbstract = this.getProperty("IsAbstract", className, fields, Boolean.class);
        JSONArray dependencies = this.getProperty("Dependencies", className, fields, JSONArray.class);
        String kind = this.getProperty("Kind", className, fields, String.class);
        String type = this.getProperty("Type", className, fields, String.class);
        CSharpProgrammingElement result = null;
        switch (kind) {
            case "Event": {
                result = new CSharpEvent((IModelServiceProvider)this.m_softwareSystem, parent, name);
                break;
            }
            case "Field": {
                result = new CSharpField((IModelServiceProvider)this.m_softwareSystem, parent, name);
                break;
            }
            case "Method": {
                assert (false);
                break;
            }
            case "Property": {
                result = new CSharpProperty((IModelServiceProvider)this.m_softwareSystem, parent, name, false);
                break;
            }
            case "Indexer": {
                result = new CSharpProperty((IModelServiceProvider)this.m_softwareSystem, parent, name, true);
            }
        }
        assert (result != null);
        result.setAccessSpecifier(accessSpecifier);
        result.setLineNumber(lineNumber);
        ((CSharpMember)result).setSignature(type);
        result.setStatic(isStatic);
        result.setAbstract(isAbstract);
        this.m_objectTable.put(id, result);
        if (dependencies != null) {
            this.handleDependencies(result, id, dependencies);
        }
        parent.addChild((NamedElement)result);
        return result;
    }

    private CSharpMethod handleMethod(NamedElement parent, JSONArray fields, String className) {
        int id = this.getProperty("Id", className, fields, Number.class).intValue();
        String name = this.getProperty("Name", className, fields, String.class);
        int lineNumber = this.getProperty("LineNumber", className, fields, Number.class).intValue();
        String access = this.getProperty("Access", className, fields, String.class);
        CSharpAccessSpecifier accessSpecifier = CSharpAccessSpecifier.valueOf(StringUtility.convertStandardNameToConstantName((String)access));
        boolean isStatic = this.getProperty("IsStatic", className, fields, Boolean.class);
        boolean isAbstract = this.getProperty("IsAbstract", className, fields, Boolean.class);
        JSONArray dependencies = this.getProperty("Dependencies", className, fields, JSONArray.class);
        String type = this.getProperty("Type", className, fields, String.class);
        String methodKind = this.getProperty("MethodKind", className, fields, String.class);
        CSharpMethodType mk = CSharpMethodType.valueOf(methodKind);
        JSONArray typeParameters = this.getProperty("TypeParameters", className, fields, JSONArray.class);
        String[] tp = null;
        if (typeParameters != null) {
            tp = (String[])typeParameters.toArray((Object[])new String[typeParameters.size()]);
        }
        int statementCount = this.getProperty("StatementCount", className, fields, Number.class).intValue();
        int cyclomaticComplexity = this.getProperty("CyclomaticComplexity", className, fields, Number.class).intValue();
        int modifiedCyclomaticComplexity = this.getProperty("ModifiedCyclomaticComplexity", className, fields, Number.class).intValue();
        int logicalOperatorCount = this.getProperty("LogicalOperatorCount", className, fields, Number.class).intValue();
        int maxIndentationdepth = this.getProperty("MaxIndentationDepth", className, fields, Number.class).intValue();
        CSharpMethod result = null;
        if (statementCount >= 0) {
            CSharpMethodWithBody method = new CSharpMethodWithBody((IModelServiceProvider)this.m_softwareSystem, parent, name, mk, tp);
            method.setNumberOfStatements(statementCount);
            method.setCyclomaticComplexity(cyclomaticComplexity);
            method.setModifiedCyclomaticComplexity(modifiedCyclomaticComplexity);
            method.setNumberOfLogicalOperations(logicalOperatorCount);
            method.setMaxNesting(maxIndentationdepth);
            result = method;
        } else {
            result = new CSharpMethod((IModelServiceProvider)this.m_softwareSystem, parent, name, mk, tp);
        }
        this.m_objectTable.put(id, result);
        result.setLineNumber(lineNumber);
        result.setAccessSpecifier(accessSpecifier);
        if (isStatic) {
            result.setStatic(true);
        }
        if (isAbstract) {
            result.setAbstract(true);
        }
        if (dependencies != null) {
            this.handleDependencies(result, id, dependencies);
        }
        result.setSignature(type);
        parent.addChild((NamedElement)result);
        return result;
    }

    private NamedElement processObject(JSONObject obj, NamedElement parent) {
        String className = (String)obj.get((Object)"ClassName");
        JSONArray fields = (JSONArray)obj.get((Object)"Fields");
        JSONArray children = (JSONArray)obj.get((Object)"Children");
        boolean isExternal = false;
        Object result = null;
        switch (className) {
            case "Root": {
                result = new ModelRoot((IBaseDirectory)this.m_softwareSystem);
                break;
            }
            case "Assembly": {
                result = new CSharpAssembly(parent, this.getProperty("Name", className, fields, String.class));
                parent.addChild((NamedElement)result);
                this.m_endPoints.put(result.getShortName(), (IWorkspaceDependencyElement)result);
                isExternal = true;
                break;
            }
            case "Type": {
                result = this.handleType(parent, fields, className);
                break;
            }
            case "Delegate": {
                result = this.handleDelegate(parent, fields, className);
                break;
            }
            case "Indexer": 
            case "TypedElement": {
                result = this.handleTypedElement(parent, fields, className);
                break;
            }
            case "EnumMember": {
                result = this.handleEnumMember(parent, fields, className);
                break;
            }
            case "Method": {
                result = this.handleMethod(parent, fields, className);
                break;
            }
            case "Module": {
                result = this.handleModule(parent, fields, className);
                break;
            }
            case "SourceFile": {
                if (children.size() > 0) {
                    result = this.handleSourceFile(parent, fields, className);
                    break;
                }
                return null;
            }
            default: {
                assert (false) : "Unexpected class name: " + className;
                break;
            }
        }
        assert (result != null);
        if (isExternal) {
            this.m_isExternal = true;
        }
        for (Object c : children) {
            JSONObject child = (JSONObject)c;
            this.processObject(child, (NamedElement)result);
        }
        if (isExternal) {
            this.m_isExternal = false;
        }
        return result;
    }
}

