/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.api.csharp.CSharpTypeKind;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpAttributeRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.CSharpDependencyType;
import java.util.List;
import java.util.Set;

public final class CSharpExtendsClassRetriever
extends CSharpAttributeRetriever {
    public String getName() {
        return "CSharpExtendsClass";
    }

    public String getShortName() {
        return "ExtendsClass";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the fully qualified C# name (namespace plus class name separated by \u2018.\u2019) of any direct or indirect base class of a class.\n\nIn a physical model a C# component will only be considered if it contains a type that has the same name as the component.\n\nPlease note that \u201c*\u201d will match anything except dots (\u2018.\u2019).\n\nWildcards: ?=any character, *=any sequence between dots, **=any sequence";
    }

    public String getMultipleAttributeInfo() {
        return "Extends class";
    }

    @Override
    protected boolean collectFor(CSharpType type) {
        assert (type != null) : "Parameter 'type' of method 'collectFor' must not be null";
        return type.getKind() == CSharpTypeKind.Class;
    }

    @Override
    protected void collect(IWorkerContext workerContext, CSharpType type, Set<String> collector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collectInterfaces' must not be null";
        assert (type != null) : "Parameter 'type' of method 'collectInterfaces' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collect' must not be null";
        assert (!type.isInterface()) : "No interface expected";
        for (CSharpType typePart : type.getPartialSegments()) {
            List dependencies = typePart.getOutgoingDependencies(new IParserDependencyType[]{CSharpDependencyType.EXTENDS});
            if (dependencies.size() != 1) continue;
            CSharpType baseClass = (CSharpType)((ParserDependency)dependencies.get(0)).getTo();
            collector.add(baseClass.getFullyQualifiedTypeName());
            Set<String> nextData = this.getData(workerContext, baseClass);
            if (nextData.isEmpty()) break;
            collector.addAll(nextData);
            break;
        }
    }
}

