/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.license.foundation;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseUtilities {
    private static final int TIMEOUT_FOR_MAC_ADDRESS_PROCESS = 5000;
    static final Logger LOGGER = LoggerFactory.getLogger(LicenseUtilities.class);
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final KeyPairGenerator KEY_PAIR_GENERATOR;
    private static final KeyFactory KEY_FACTORY;

    static {
        try {
            KEY_PAIR_GENERATOR = KeyPairGenerator.getInstance("DSA");
            SecureRandom sr = new SecureRandom();
            KEY_PAIR_GENERATOR.initialize(1024, new SecureRandom(sr.generateSeed(8)));
            KEY_FACTORY = KeyFactory.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private LicenseUtilities() {
    }

    public static PublicKey getPublic(byte[] encodedKey) throws InvalidKeySpecException {
        return KEY_FACTORY.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static PrivateKey getPrivate(byte[] encodedKey) throws InvalidKeySpecException {
        return KEY_FACTORY.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static KeyPair getKeyPair() {
        return KEY_PAIR_GENERATOR.genKeyPair();
    }

    public static void main(String[] args) {
        KeyPair kp = LicenseUtilities.getKeyPair();
        System.out.println("PUBLIC=" + LicenseUtilities.convert(kp.getPublic().getEncoded()));
        System.out.println("PRIVATE=" + LicenseUtilities.convert(kp.getPrivate().getEncoded()));
    }

    public static String convert(byte[] bytes) {
        assert (bytes != null) : "Parameter 'bytes' of method 'convert' must not be null";
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            sb.append(HEX[element >> 4 & 0xF]);
            sb.append(HEX[element & 0xF]);
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] convert(String hex) {
        assert (hex != null) : "Parameter 'hex' of method 'convert' must not be null";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < hex.length()) {
            char c1 = hex.charAt(i);
            if (i + 1 >= hex.length()) {
                throw new IllegalArgumentException();
            }
            char c2 = hex.charAt(i + 1);
            int b = 0;
            if (c1 >= '0' && c1 <= '9') {
                b = (byte)(b + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b = (byte)(b + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b = (byte)(b + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException();
            }
            if (c2 >= '0' && c2 <= '9') {
                b = (byte)(b + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b = (byte)(b + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b = (byte)(b + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException();
            }
            baos.write(b);
            i += 2;
        }
        return baos.toByteArray();
    }

    public static Map<String, String> getMacAdresses() {
        HashMap<String, String> macAddresses = new HashMap<String, String>();
        switch (Platform.getOperatingSystem()) {
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM_64: {
                LicenseUtilities.getMacAddressesLinux(macAddresses);
                break;
            }
            case MAC_32: 
            case MAC_64: 
            case MAC_ARM_64: {
                LicenseUtilities.getMacAddressesMac(macAddresses);
                break;
            }
            case WINDOWS_32: 
            case WINDOWS_64: 
            case WINDOWS_ARM_64: {
                LicenseUtilities.getMacAddressesWindows(macAddresses);
                break;
            }
        }
        return macAddresses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void getMacAddressesWindows(Map<String, String> macAddresses) {
        ProcessBuilder pb = new ProcessBuilder("getmac", "/fo", "csv", "/nh");
        try {
            Process p = pb.start();
            Throwable throwable = null;
            Object var4_7 = null;
            try {
                InputStream input = p.getInputStream();
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.isEmpty()) continue;
                            String[] items = line.split(",");
                            String addr = items[0].substring(1, items[0].length() - 1);
                            String name = items[1].substring(1, items[1].length() - 1);
                            if (addr.length() != 17 || macAddresses.containsKey(addr)) continue;
                            macAddresses.put(addr, name);
                        }
                        p.waitFor(5000L, TimeUnit.MILLISECONDS);
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
                input.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Cannot determine extra mac addresses. Please check if the current user '" + System.getProperty("user.name") + "' has sufficient rights to execute command without specifying a password: getmac.exe /fo csv /nh", (Throwable)e);
            return;
        }
        catch (Throwable e) {
            LOGGER.error("Cannot determine extra mac addresses", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void getMacAddressesMac(Map<String, String> macAddresses) {
        assert (macAddresses != null) : "Parameter 'macAddresses' of method 'getMacAddressesMac' must not be null";
        ProcessBuilder pb = new ProcessBuilder("networksetup", "-listallhardwareports");
        try {
            Process p = pb.start();
            Throwable throwable = null;
            Object var4_7 = null;
            try {
                InputStream input = p.getInputStream();
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String addr;
                            if (!line.startsWith("Device:")) continue;
                            String name = line.substring(8);
                            line = reader.readLine();
                            if (line == null || !line.startsWith("Ethernet Address:") || (addr = line.substring(18)).length() != 17) continue;
                            macAddresses.put(addr.replace(':', '-'), name);
                        }
                        p.waitFor(5000L, TimeUnit.MILLISECONDS);
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
                input.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Cannot determine extra mac addresses. Check if the current user '" + System.getProperty("user.name") + "' has sufficient rights to execute the following command without specifying a password: networksetup -listallhardwareports", (Throwable)e);
            return;
        }
        catch (Throwable e) {
            LOGGER.error("Cannot determine extra mac addresses", e);
        }
    }

    static void getMacAddressesLinux(Map<String, String> macAddresses) {
        assert (macAddresses != null) : "Parameter 'macAddresses' of method 'getMacAddressesLinux' must not be null";
        TFile dir = new TFile("/sys/class/net");
        Arrays.stream(dir.listFiles()).forEach(f -> LicenseUtilities.addAddressLinux(macAddresses, f));
    }

    private static void addAddressLinux(Map<String, String> macAddresses, TFile file) {
        assert (macAddresses != null) : "Parameter 'macAddresses' of method 'addAddressLinux' must not be null";
        assert (file != null) : "Parameter 'file' of method 'addAddressLinux' must not be null";
        String name = file.getName();
        TFile addressFile = new TFile((File)file, "address");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)addressFile));){
                String nextLine = reader.readLine();
                if (nextLine != null) {
                    String address = nextLine.trim().replace(':', '-');
                    if (!address.equals("00-00-00-00-00-00")) {
                        macAddresses.put(address, name);
                    }
                } else {
                    LOGGER.error("Nothing read from interface " + name);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot determine mac address of interface " + name, (Throwable)e);
        }
    }
}

