/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture;

import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaAttributeRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import gnu.trove.set.hash.THashSet;
import java.util.Set;

public final class JavaAnnotationRetriever
extends JavaAttributeRetriever {
    public String getName() {
        return "JavaHasAnnotation";
    }

    public String getShortName() {
        return "HasAnnotation";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the fully qualified Java name of any annotation of a type.\n\nIn a physical model only the Java main type (i.e. the type matching the component's name) is considered. This only works on 'internal' types.\n\nPlease note that \u201c*\u201d will match anything except dots ('.').\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    public String getMultipleAttributeInfo() {
        return "Has annotation";
    }

    private void processAnnotations(IWorkerContext workerContext, Set<String> data, JavaElement element) {
        assert (workerContext != null);
        assert (data != null);
        assert (element != null);
        for (Annotation nextAnnotation : element.getAnnotations()) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            NamedElement nextAnnotationClass = nextAnnotation.getAnnotationClass();
            if (!(nextAnnotationClass instanceof JavaType)) continue;
            data.add(((JavaType)nextAnnotationClass).getFullyQualifiedTypeName());
        }
    }

    @Override
    protected String computeAttributeForJavaType(IWorkerContext workerContext, JavaType type, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForJavaType' must not be null";
        assert (type != null) : "Parameter 'type' of method 'computeAttributeForJavaType' must not be null";
        Set data = this.getData((NamedElement)type);
        if (data == null) {
            data = new THashSet();
            this.processAnnotations(workerContext, data, type);
            for (JavaField field : type.getChildren(JavaField.class)) {
                this.processAnnotations(workerContext, data, field);
            }
            for (JavaMethod method : type.getChildren(JavaMethod.class)) {
                this.processAnnotations(workerContext, data, method);
            }
            this.setData((NamedElement)type, data);
        }
        return this.createAttribute(data);
    }
}

