/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.SoftwareSystemSettingsFile;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaLanguage;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaDefaultIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaUserDefinedIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IJavaSoftwareSystemSettingsProvider;
import com.hello2morrow.sonargraph.languageprovider.java.persistence.system.settings.JavaSoftwareSystemSettingsPersistence;
import de.schlichtherle.truezip.file.TFile;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaSoftwareSystemSettingsExtension
extends SoftwareSystemSettingsExtension
implements IJavaSoftwareSystemSettingsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSoftwareSystemSettingsExtension.class);

    static void aboutToCreateFirstModule(Workspace workspace) {
        assert (workspace != null) : "Parameter 'workspace' of method 'aboutToCreateFirstModule' must not be null";
        LOGGER.debug("Create default Java ignore access");
        JavaDefaultIgnoreAccess ignoreAccess = (JavaDefaultIgnoreAccess)((Object)workspace.getUniqueChild(JavaDefaultIgnoreAccess.class));
        assert (ignoreAccess == null) : "'ignoreAccess' of method 'aboutToCreateFirstModule' must be null";
        ignoreAccess = new JavaDefaultIgnoreAccess((NamedElement)workspace);
        workspace.addChild((NamedElement)ignoreAccess);
    }

    static void lastModuleDeleted(Workspace workspace) {
        assert (workspace != null) : "Parameter 'workspace' of method 'lastModuleDeleted' must not be null";
        LOGGER.debug("Remove default Java ignore access");
        ((JavaDefaultIgnoreAccess)((Object)workspace.getUniqueExistingChild(JavaDefaultIgnoreAccess.class))).remove();
    }

    static void checkSoftwareSystemSettings(Workspace sourceWorkspace, Workspace targetWorkspace, OperationResult result) {
        assert (sourceWorkspace != null) : "Parameter 'sourceWorkspace' of method 'checkSoftwareSystemSettings' must not be null";
        assert (targetWorkspace != null) : "Parameter 'targetWorkspace' of method 'checkSoftwareSystemSettings' must not be null";
        assert (result != null) : "Parameter 'result' of method 'checkSoftwareSystemSettings' must not be null";
        JavaDefaultIgnoreAccess sourceDefaultIgnoreAccess = (JavaDefaultIgnoreAccess)((Object)sourceWorkspace.getUniqueChild(JavaDefaultIgnoreAccess.class));
        if (sourceDefaultIgnoreAccess != null) {
            JavaDefaultIgnoreAccess targetDefaultIgnoreAccess = (JavaDefaultIgnoreAccess)((Object)targetWorkspace.getUniqueExistingChild(JavaDefaultIgnoreAccess.class));
            if (!targetDefaultIgnoreAccess.getCurrentlyUsedSignature().equals(sourceDefaultIgnoreAccess.getCurrentlyUsedSignature())) {
                result.addError((OperationResult.IMessageCause)JavaSoftwareSystemSettingsMessageCause.IGNORE_ACCESS_DOES_NOT_MATCH);
                LOGGER.debug("Java ignore access does not match");
            }
        } else {
            sourceWorkspace.addChild((NamedElement)new JavaDefaultIgnoreAccess((NamedElement)sourceWorkspace));
        }
        LOGGER.debug("Java ignore access matches");
    }

    JavaSoftwareSystemSettingsExtension(Installation installation, SoftwareSystem softwareSystem) {
        super(installation, softwareSystem);
    }

    @Override
    public JavaIgnoreAccess getIgnoreAccessForEdit() {
        JavaIgnoreAccess ignoreAccess = (JavaIgnoreAccess)((Object)this.getSoftwareSystemSettingsFile().getUniqueChild(JavaUserDefinedIgnoreAccess.class));
        return ignoreAccess == null ? (JavaIgnoreAccess)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(JavaDefaultIgnoreAccess.class)) : ignoreAccess;
    }

    JavaIgnoreAccess aboutToParse() {
        JavaIgnoreAccess ignoreAccess = (JavaIgnoreAccess)((Object)this.getSoftwareSystemSettingsFile().getUniqueChild(JavaUserDefinedIgnoreAccess.class));
        if (ignoreAccess == null) {
            ignoreAccess = (JavaIgnoreAccess)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(JavaDefaultIgnoreAccess.class));
            LOGGER.debug("Use default Java ignore access for parse");
        } else {
            LOGGER.debug("Use user defined Java ignore access for parse");
        }
        ignoreAccess.aboutToParse();
        return ignoreAccess;
    }

    void parsingFinished(JavaIgnoreAccess ignoreAccess) {
        assert (ignoreAccess != null) : "Parameter 'ignoreAccess' of method 'parsingFinished' must not be null";
        LOGGER.debug("Parse finished, reset Java ignore access");
        ignoreAccess.parsingFinished();
    }

    private JavaSoftwareSystemSettingsPersistence getPersistence() {
        return new JavaSoftwareSystemSettingsPersistence(this.getInstallation().getVersion());
    }

    protected Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    protected OperationResult loadSettingsFileContentInto(TFile file, NamedElement into, EnumSet<Modification> modifications) {
        assert (file != null) : "Parameter 'file' of method 'performLoad' must not be null";
        assert (into != null) : "Parameter 'into' of method 'performLoad' must not be null";
        assert (!into.hasChildren()) : "Not empty: " + String.valueOf(into.getChildren());
        LOGGER.debug("Load Java ignore access from file: " + file.getAbsolutePath());
        OperationResult result = this.getPersistence().load(file, into);
        if (result.isSuccess()) {
            LOGGER.debug("Loaded successfully");
            if (((JavaDefaultIgnoreAccess)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(JavaDefaultIgnoreAccess.class))).setCurrentlyUsedSignature(((JavaUserDefinedIgnoreAccess)((Object)into.getUniqueExistingChild(JavaUserDefinedIgnoreAccess.class))).createStringRepresentation())) {
                LOGGER.debug("Current ignored access changed");
                if (modifications != null) {
                    modifications.add(Modification.SYSTEM_NEEDS_REPARSE);
                }
            } else {
                LOGGER.debug("Current ignored access not changed");
            }
            return result;
        }
        LOGGER.debug("Failure: " + String.valueOf(result));
        return result;
    }

    protected OperationResult saveSettingsFile(SoftwareSystemSettingsFile settingsFile, TFile targetFile) {
        assert (settingsFile != null) : "Parameter 'settingsFile' of method 'performSave' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'saveSettingsFile' must not be null";
        LOGGER.debug("Save Java ignore access to file: " + targetFile.getAbsolutePath());
        OperationResult result = this.getPersistence().save((NamedElement)settingsFile, targetFile);
        if (result.isSuccess()) {
            LOGGER.debug("Success");
            return result;
        }
        LOGGER.debug("Failure: " + String.valueOf(result));
        return result;
    }

    protected void restoreDefaults(EnumSet<Modification> modifications) {
        LOGGER.debug("Restore defaults");
        JavaDefaultIgnoreAccess defaultIgnoreAccess = (JavaDefaultIgnoreAccess)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(JavaDefaultIgnoreAccess.class));
        if (defaultIgnoreAccess.setCurrentlyUsedSignature(defaultIgnoreAccess.getOwnSignature())) {
            LOGGER.debug("Defaults differ");
            if (modifications != null) {
                modifications.add(Modification.SYSTEM_NEEDS_REPARSE);
            }
        } else {
            LOGGER.debug("Defaults do not differ");
        }
    }

    static enum JavaSoftwareSystemSettingsMessageCause implements OperationResult.IMessageCause
    {
        IGNORE_ACCESS_DOES_NOT_MATCH;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

