/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaTypeRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.NestedTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.NestedTypeInfoNestedTypeBased;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.NestedTypeInfoOuterFqTypeNameBased;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.NestedTypeInfoOuterTypeBased;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.OuterTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.AnonymousTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaModuleModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.ClassFileParser;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.AspectJFileProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.GroovyFileProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaFileParser;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.KotlinFileParser;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.ScalaFileProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.ClassFileOutOfDate;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaModuleModel
implements IJavaModuleModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaModuleModel.class);
    private final Map<String, JavaInternalCompilationUnit> m_relSourceFilePathToCompilationUnit = new THashMap();
    private final Map<String, ArrayList<JavaType>> m_relGroovySourceFilePathToJavaTypes = new THashMap();
    private final Map<String, ArrayList<JavaType>> m_relScalaSourceFileToJavaTypes = new THashMap();
    private final Map<String, ArrayList<JavaType>> m_relAspectJSourceFileToJavaTypes = new THashMap();
    private final Set<OuterTypeInfo> m_outerTypeInfo = new LinkedHashSet<OuterTypeInfo>();
    private final Set<NestedTypeInfoNestedTypeBased> m_nestedTypeInfoNestedTypeBased = new LinkedHashSet<NestedTypeInfoNestedTypeBased>();
    private final Set<NestedTypeInfoOuterTypeBased> m_nestedTypeInfoOuterTypeBased = new LinkedHashSet<NestedTypeInfoOuterTypeBased>();
    private final Set<NestedTypeInfoOuterFqTypeNameBased> m_nestedTypeInfoOuterFqTypeNameBased = new LinkedHashSet<NestedTypeInfoOuterFqTypeNameBased>();
    private final Map<String, AnonymousTypeInfo> m_anonymousTypeToInfo = new THashMap();
    private final Set<JavaType> m_typesToBeReparsed = new THashSet();
    private final IAddedOrChangedSourceFileProcessor m_addedOrChangedSourceFileProcessor;
    private final JavaGlobalModel m_globalModel;
    private final ClassFileParser m_classFileParser;
    private final JavaFileParser m_javaFileParser;
    private final KotlinFileParser m_kotlinFileParser;
    private final GroovyFileProcessor m_groovyFileProcessor;
    private final ScalaFileProcessor m_scalaFileProcessor;
    private final AspectJFileProcessor m_aspectJFileProcessor;
    private final JavaModule m_module;

    JavaModuleModel(JavaGlobalModel globalModel, JavaModule module, IAddedOrChangedSourceFileProcessor addedOrChangedSourceFileProcessor, IFilePathListener listener) {
        assert (globalModel != null) : "Parameter 'globalModel' of method 'JavaProgrammingModel' must not be null";
        assert (module != null) : "Parameter 'module' of method 'JavaModuleModel' must not be null";
        assert (addedOrChangedSourceFileProcessor != null) : "Parameter 'addedOrChangedSourceFileProcessor' of method 'JavaModuleModel' must not be null";
        this.m_globalModel = globalModel;
        this.m_module = module;
        this.m_addedOrChangedSourceFileProcessor = addedOrChangedSourceFileProcessor;
        this.m_classFileParser = new ClassFileParser(globalModel, this);
        this.m_javaFileParser = new JavaFileParser(globalModel, this, listener);
        this.m_kotlinFileParser = new KotlinFileParser(globalModel, this, listener);
        this.m_groovyFileProcessor = new GroovyFileProcessor(globalModel, this, listener);
        this.m_scalaFileProcessor = new ScalaFileProcessor(globalModel, this, listener);
        this.m_aspectJFileProcessor = new AspectJFileProcessor(globalModel, this, listener);
    }

    @Override
    public JavaModule getModule() {
        return this.m_module;
    }

    ClassFileParser getClassFileParser() {
        return this.m_classFileParser;
    }

    JavaFileParser getJavaFileParser() {
        return this.m_javaFileParser;
    }

    GroovyFileProcessor getGroovyFileProcessor() {
        return this.m_groovyFileProcessor;
    }

    KotlinFileParser getKotlinFileParser() {
        return this.m_kotlinFileParser;
    }

    ScalaFileProcessor getScaleFileProcessor() {
        return this.m_scalaFileProcessor;
    }

    AspectJFileProcessor getAspectJFileProcessor() {
        return this.m_aspectJFileProcessor;
    }

    @Override
    public JavaInternalCompilationUnit getInternalCompilationUnit(String relPath) {
        assert (relPath != null && relPath.length() > 0) : "Parameter 'relPath' of method 'getInternalCompilationUnit' must not be empty";
        return this.m_relSourceFilePathToCompilationUnit.get(relPath);
    }

    @Override
    public void setAsPrimarySourceFileForInternalCompilationUnit(String relPath, JavaSourceFile sourceFile, JavaInternalCompilationUnit internalCompilationUnit) {
        assert (relPath != null && relPath.length() > 0) : "Parameter 'relPath' of method 'setAsPrimarySourceFileForInternalCompilationUnit' must not be empty";
        assert (internalCompilationUnit != null) : "Parameter 'internalCompilationUnit' of method 'setAsPrimarySourceFileForInternalCompilationUnit' must not be null";
        JavaInternalCompilationUnit previous = this.m_relSourceFilePathToCompilationUnit.put(relPath.intern(), internalCompilationUnit);
        if (previous != null) assert (previous == internalCompilationUnit) : relPath + ": " + previous.getIdentifyingPath() + " != " + internalCompilationUnit.getIdentifyingPath();
        List<JavaClassFile> primaryJavaClassFiles = internalCompilationUnit.getPrimaryClassFiles();
        for (JavaClassFile nextPrimaryJavaClassFile : primaryJavaClassFiles) {
            if (nextPrimaryJavaClassFile.getTimestamp() >= sourceFile.getTimestamp()) continue;
            nextPrimaryJavaClassFile.addIssue((Issue)new ClassFileOutOfDate((NamedElement)nextPrimaryJavaClassFile, "Corresponding source file " + sourceFile.getName() + " has a more recent timestamp than '" + nextPrimaryJavaClassFile.getName() + "'"));
        }
        this.m_addedOrChangedSourceFileProcessor.processAddedOrChangedSourceFile((SourceFile)internalCompilationUnit);
    }

    @Override
    public List<JavaType> getGroovyTypes(String relGroovySourcePath) {
        assert (relGroovySourcePath != null && relGroovySourcePath.length() > 0) : "Parameter 'relGroovySourcePath' of method 'getGroovyTypes' must not be empty";
        List types = this.m_relGroovySourceFilePathToJavaTypes.get(relGroovySourcePath);
        if (types != null) {
            return Collections.unmodifiableList(types);
        }
        return Collections.emptyList();
    }

    @Override
    public List<JavaType> getAspectJTypes(String relAspectJSourcePath) {
        assert (relAspectJSourcePath != null && relAspectJSourcePath.length() > 0) : "Parameter 'relAspectJSourcePath' of method 'getAspectJTypes' must not be empty";
        List types = this.m_relAspectJSourceFileToJavaTypes.get(relAspectJSourcePath);
        if (types != null) {
            return Collections.unmodifiableList(types);
        }
        return Collections.emptyList();
    }

    @Override
    public List<JavaType> getScalaTypes(String relScalaSourcePath) {
        assert (relScalaSourcePath != null && relScalaSourcePath.length() > 0) : "Parameter 'relScalaSourcePath' of method 'getScalaTypes' must not be empty";
        List types = this.m_relScalaSourceFileToJavaTypes.get(relScalaSourcePath);
        if (types != null) {
            return Collections.unmodifiableList(types);
        }
        return Collections.emptyList();
    }

    private void resetAnonymousTypeShortNameIfNecessary(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'resetAnonymousTypeShortNameIfNecessary' must not be null";
        if (type.isAnonymous()) {
            String oldShortName = type.getShortName();
            String newShortName = JavaNameUtility.getTypeNameFromFqTypeName(type.getFqName());
            type.setShortName(newShortName);
            this.m_globalModel.getTypeRegistry().updateShortNameOfTypeIfNecessary(oldShortName, type);
        }
    }

    void setNeedsReparse(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'setNeedsReparse' must not be null";
        JavaClassFile primaryClassFile = (JavaClassFile)((Object)type.getFirstChild(JavaClassFile.class));
        assert (primaryClassFile != null) : "'primaryClassFile' of method 'setNeedsReparse' must not be null";
        RootDirectoryPath nextBaseDirectory = primaryClassFile.getBaseDirectory();
        assert (nextBaseDirectory != null) : "'nextBaseDirectory' of method 'setNeedsReparse' must not be null";
        String packageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(type.getFqName());
        NamedElement parent = packageName.length() > 0 ? NamespaceFragment.getNamespaceFragmentOrSpecifiedParent((IModelServiceProvider)this.m_globalModel.getModelServiceProvider(), (NamedElement)nextBaseDirectory.getNamedElement(), (String)packageName, (NamespaceFragment.INamespaceFragmentCreator)this.m_globalModel.getNamespaceFragmentCreator()) : nextBaseDirectory.getNamedElement();
        type.changeParent(parent, true);
        this.m_typesToBeReparsed.add(type);
        this.resetAnonymousTypeShortNameIfNecessary(type);
        this.m_globalModel.aboutToReparse(type);
    }

    void removedFromInternalCompilationUnit(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'removedFromInternalCompilationUnit' must not be null";
        this.resetAnonymousTypeShortNameIfNecessary(type);
        this.m_globalModel.removedFromInternalCompilationUnit(type);
    }

    private void register(Map<String, ArrayList<JavaType>> map, JavaType type, String relSourcePath) {
        assert (map != null) : "Parameter 'map' of method 'register' must not be null";
        assert (type != null) : "Parameter 'type' of method 'register' must not be null";
        assert (relSourcePath != null && relSourcePath.length() > 0) : "Parameter 'relSourcePath' of method 'register' must not be empty";
        ArrayList<JavaType> types = map.get(relSourcePath);
        if (types == null) {
            types = new ArrayList(2);
            map.put(relSourcePath.intern(), types);
        }
        types.add(type);
    }

    @Override
    public void finishClassFileParsing(JavaType type, String relSourcePath) {
        assert (type != null) : "Parameter 'type' of method 'finishClassFileParsing' must not be null";
        assert (relSourcePath != null && relSourcePath.length() > 0) : "Parameter 'relSourcePath' of method 'finishClassFileParsing' must not be empty";
        JavaFileType fileType = JavaFileType.determine(relSourcePath);
        assert (fileType != null) : "'fileType' of method 'finishClassFileParsing' must not be null";
        switch (fileType) {
            case GROOVY_FILE: {
                this.register(this.m_relGroovySourceFilePathToJavaTypes, type, relSourcePath);
                break;
            }
            case ASPECTJ_FILE: {
                this.register(this.m_relAspectJSourceFileToJavaTypes, type, relSourcePath);
                break;
            }
            case SCALA_FILE: {
                this.register(this.m_relScalaSourceFileToJavaTypes, type, relSourcePath);
                break;
            }
            case CLASS_FILE: 
            case JAVA_FILE: 
            case KOTLIN_FILE: {
                break;
            }
            default: {
                assert (false) : "Unhandled file type: " + String.valueOf((Object)fileType);
                break;
            }
        }
    }

    @Override
    public Set<JavaType> getTypesToBeReparsed() {
        return this.m_typesToBeReparsed;
    }

    @Override
    public void addOuterTypeInfo(RootDirectoryPath rootDirectoryPath, JavaType nestedType, String outerFqTypeName) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'addOuterTypeInfo' must not be null";
        assert (nestedType != null) : "Parameter 'nestedType' of method 'addOuterTypeInfo' must not be null";
        assert (outerFqTypeName != null && outerFqTypeName.length() > 0) : "Parameter 'outerFqTypeName' of method 'addOuterTypeInfo' must not be empty";
        OuterTypeInfo info = new OuterTypeInfo(rootDirectoryPath, nestedType, outerFqTypeName);
        this.m_outerTypeInfo.add(info);
    }

    @Override
    public void addNestedTypeInfo(RootDirectoryPath rootDirectoryPath, JavaType nestedType, String nestedTypeShortName, boolean nestedTypeIsSynthetic, boolean nestedTypeIsStatic) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'addNestedTypeInfo' must not be null";
        assert (nestedType != null) : "Parameter 'nestedType' of method 'addNestedTypeInfo' must not be null";
        NestedTypeInfoNestedTypeBased info = new NestedTypeInfoNestedTypeBased(rootDirectoryPath, nestedType, nestedTypeShortName, nestedTypeIsSynthetic, nestedTypeIsStatic);
        this.m_nestedTypeInfoNestedTypeBased.add(info);
    }

    @Override
    public void addNestedTypeInfo(RootDirectoryPath rootDirectoryPath, JavaType enclosing, String fqNestedTypeName, String nestedName, boolean isSynthetic, boolean isStatic) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'addNestedTypeInfo' must not be null";
        assert (enclosing != null) : "Parameter 'enclosing' of method 'addNestedTypeInfo' must not be null";
        assert (fqNestedTypeName != null && fqNestedTypeName.length() > 0) : "Parameter 'fqNestedTypeName' of method 'addNestedTypeInfo' must not be empty";
        NestedTypeInfoOuterTypeBased info = new NestedTypeInfoOuterTypeBased(rootDirectoryPath, enclosing, fqNestedTypeName, nestedName, isSynthetic, isStatic);
        this.m_nestedTypeInfoOuterTypeBased.add(info);
    }

    @Override
    public void addNestedTypeInfo(RootDirectoryPath rootDirectoryPath, String fqEnclosingTypeName, String fqNestedTypeName, String nestedName, boolean isSynthetic, boolean isStatic) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'addNestedTypeInfo' must not be null";
        assert (fqEnclosingTypeName != null && fqEnclosingTypeName.length() > 0) : "Parameter 'fqEnclosingTypeName' of method 'addNestedTypeInfo' must not be empty";
        assert (fqNestedTypeName != null && fqNestedTypeName.length() > 0) : "Parameter 'fqNestedTypeName' of method 'addNestedTypeInfo' must not be empty";
        NestedTypeInfoOuterFqTypeNameBased info = new NestedTypeInfoOuterFqTypeNameBased(rootDirectoryPath, fqEnclosingTypeName, fqNestedTypeName, nestedName, isSynthetic, isStatic);
        this.m_nestedTypeInfoOuterFqTypeNameBased.add(info);
    }

    private void processNestedType(JavaType outerType, JavaType nestedType, NestedTypeInfo info, Map<JavaType, String> innerKotlinInlineTypeToShortName) {
        assert (nestedType != null) : "Parameter 'nestedType' of method 'processNestedType' must not be null";
        assert (info != null) : "Parameter 'info' of method 'processNestedType' must not be null";
        assert (innerKotlinInlineTypeToShortName != null) : "Parameter 'innerKotlinInlineTypeToShortName' of method 'processNestedType' must not be null";
        String oldShortName = nestedType.getShortName();
        nestedType.removeFlag(JavaElementFlag.STATIC);
        nestedType.removeFlag(JavaElementFlag.SYNTHETIC);
        nestedType.removeFlag(JavaElementFlag.INNER);
        nestedType.removeFlag(JavaElementFlag.ANONYMOUS);
        nestedType.addFlag(JavaElementFlag.NESTED);
        if (info.isSynthetic()) {
            nestedType.addFlag(JavaElementFlag.SYNTHETIC);
        }
        if (info.isStatic()) {
            nestedType.addFlag(JavaElementFlag.STATIC);
        }
        List constructors = nestedType.getChildren(JavaConstructor.class);
        if (info.isAnonymous()) {
            nestedType.addFlag(JavaElementFlag.INNER);
            nestedType.addFlag(JavaElementFlag.ANONYMOUS);
            nestedType.setShortName("");
            for (JavaConstructor nextConstructor : constructors) {
                this.m_globalModel.addSyntheticMethod(nextConstructor);
            }
        } else {
            String nestedTypeShortName = info.getNestedTypeShortName();
            nestedType.setShortName(nestedTypeShortName);
            if (!nestedType.isStatic()) {
                nestedType.addFlag(JavaElementFlag.INNER);
                for (JavaConstructor nextConstructor : constructors) {
                    int numberOfParameters = Type.getArgumentTypes((String)nextConstructor.getDescriptor()).length;
                    if (numberOfParameters < 1) continue;
                    nextConstructor.setShortName(nestedTypeShortName);
                    nextConstructor.setNumberOfParameters(numberOfParameters - 1);
                }
            } else {
                for (JavaConstructor nextConstructor : constructors) {
                    nextConstructor.setShortName(nestedTypeShortName);
                }
            }
        }
        if (outerType != null) {
            nestedType.changeParent((NamedElement)outerType, true);
            this.m_globalModel.getTypeRegistry().updateShortNameOfTypeIfNecessary(oldShortName, nestedType);
        } else if (nestedType.hasFlag(JavaElementFlag.KOTLIN_TYPE) && nestedType.getFqName().indexOf("$inlined$") != -1) {
            innerKotlinInlineTypeToShortName.put(nestedType, oldShortName);
        }
    }

    public void finishClassFileParsing() {
        JavaTypeRegistry typeRegistry = this.m_globalModel.getTypeRegistry();
        THashMap innerKotlinInlineTypeToShortName = new THashMap();
        for (NestedTypeInfoOuterTypeBased nestedTypeInfoOuterTypeBased : this.m_nestedTypeInfoOuterTypeBased) {
            JavaType nestedType = typeRegistry.getType(this.m_module, nestedTypeInfoOuterTypeBased.getNestedFqTypeName());
            if (nestedType == null) continue;
            this.processNestedType(nestedTypeInfoOuterTypeBased.getOuterType(), nestedType, nestedTypeInfoOuterTypeBased, (Map<JavaType, String>)innerKotlinInlineTypeToShortName);
        }
        this.m_nestedTypeInfoOuterTypeBased.clear();
        for (NestedTypeInfoOuterFqTypeNameBased nestedTypeInfoOuterFqTypeNameBased : this.m_nestedTypeInfoOuterFqTypeNameBased) {
            JavaType nestedType;
            JavaType nextOuterType = typeRegistry.getType(this.m_module, nestedTypeInfoOuterFqTypeNameBased.getOuterFqTypeName());
            if (nextOuterType == null || (nestedType = typeRegistry.getType(this.m_module, nestedTypeInfoOuterFqTypeNameBased.getNestedFqTypeName())) == null) continue;
            this.processNestedType(nextOuterType, nestedType, nestedTypeInfoOuterFqTypeNameBased, (Map<JavaType, String>)innerKotlinInlineTypeToShortName);
        }
        this.m_nestedTypeInfoOuterFqTypeNameBased.clear();
        for (NestedTypeInfoNestedTypeBased nestedTypeInfoNestedTypeBased : this.m_nestedTypeInfoNestedTypeBased) {
            this.processNestedType(null, nestedTypeInfoNestedTypeBased.getNestedType(), nestedTypeInfoNestedTypeBased, (Map<JavaType, String>)innerKotlinInlineTypeToShortName);
        }
        this.m_nestedTypeInfoNestedTypeBased.clear();
        for (OuterTypeInfo outerTypeInfo : this.m_outerTypeInfo) {
            JavaType nextNestedType = outerTypeInfo.getNestedType();
            JavaType nextOuterType = typeRegistry.getType(this.m_module, outerTypeInfo.getOuterFqTypeName());
            if (nextOuterType == null) continue;
            String oldShortName = nextNestedType.getShortName();
            nextNestedType.changeParent((NamedElement)nextOuterType, true);
            nextNestedType.addFlag(JavaElementFlag.NESTED);
            this.m_globalModel.getTypeRegistry().updateShortNameOfTypeIfNecessary(oldShortName, nextNestedType);
        }
        this.m_outerTypeInfo.clear();
        for (Map.Entry entry : innerKotlinInlineTypeToShortName.entrySet()) {
            String potentialOuterTypeName;
            JavaType nextPotentialOuterType;
            String nextFqName;
            int pos;
            JavaType nextInnerType = (JavaType)entry.getKey();
            if (nextInnerType.getParent() instanceof JavaType || (pos = (nextFqName = nextInnerType.getFqName()).indexOf(36)) == -1 || (nextPotentialOuterType = typeRegistry.getType(this.m_module, potentialOuterTypeName = nextFqName.substring(0, pos))) == null || !nextPotentialOuterType.hasFlag(JavaElementFlag.KOTLIN_TYPE)) continue;
            nextInnerType.changeParent((NamedElement)nextPotentialOuterType, true);
            nextInnerType.addFlag(JavaElementFlag.SYNTHETIC);
            this.m_globalModel.getTypeRegistry().updateShortNameOfTypeIfNecessary((String)entry.getValue(), nextInnerType);
        }
    }

    @Override
    public void addAnonymousTypeInstantiationInfo(String fqTypeName, JavaMethod method, int line) {
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'addAnonymousTypeInstantiationInfo' must not be empty";
        assert (JavaNameUtility.isPotentialAnonymousType(fqTypeName)) : "Not a potential anonymous fq type name: " + fqTypeName;
        assert (method != null) : "Parameter 'method' of method 'addAnonymousTypeInstantiationInfo' must not be null";
        assert (line > -1) : "Invalid line in 'addAnonymousTypeInstantiationInfo': " + line;
        AnonymousTypeInfo info = this.m_anonymousTypeToInfo.get(fqTypeName);
        if (info == null) {
            info = new AnonymousTypeInfo();
            this.m_anonymousTypeToInfo.put(fqTypeName, info);
        }
        if (!info.addInstantiationInfo(method, line)) {
            LOGGER.warn("Ignoring duplicate instantiation info for '" + fqTypeName + "' in [line] method: [" + line + "] " + method.getPresentationName(false));
        }
    }

    @Override
    public void addAnonymousTypeLineNumberOfFirstInstructionInMethod(JavaType type, JavaMethod method, int line) {
        assert (type != null) : "Parameter 'type' of method 'addAnonymousTypeLineNumberOfFirstInstructionInMethod' must not be null";
        String fqTypeName = type.getFqName();
        assert (JavaNameUtility.isPotentialAnonymousType(fqTypeName)) : "Not a potential anonymous fq type name: " + fqTypeName;
        assert (method != null) : "Parameter 'method' of method 'addAnonymousTypeLineNumberOfFirstInstructionInMethod' must not be null";
        assert (line > -1) : "Invalid line in 'addAnonymousTypeLineNumberOfFirstInstructionInMethod':" + line;
        AnonymousTypeInfo info = this.m_anonymousTypeToInfo.get(fqTypeName);
        if (info == null) {
            info = new AnonymousTypeInfo();
            this.m_anonymousTypeToInfo.put(fqTypeName, info);
        }
        if (info.getLineNumberOfFirstInstructionInMethod() == -1) {
            info.setLineNumberOfFirstInstructionInMethod(line);
        } else {
            LOGGER.warn("Line number of first instruction in method already added for '" + fqTypeName + "': " + String.valueOf(info));
        }
    }

    @Override
    public AnonymousTypeInfo getAnonymousTypeInfo(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'getAnonymousTypeInstantiationInfo' must not be null";
        assert (type.isAnonymous()) : "Parameter 'type' of method 'getAnonymousTypeInstantiationInfo' must be anonymous";
        return this.m_anonymousTypeToInfo.get(type.getFqName());
    }
}

