/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.AccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaNonInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaStaticBlock;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class JavaGlobalModelHelper {
    private final Map<JavaType, Set<JavaType>> m_typeToDirectSuperTypes = new THashMap();
    private final Map<JavaType, Set<JavaType>> m_typeToAllSuperTypes = new THashMap();
    private final Map<JavaType, Set<JavaType>> m_typeToAllSubTypes = new THashMap();
    private final Map<JavaType, Map<String, JavaMethod>> m_methodCacheWithReturnType = new THashMap();
    private final Map<JavaType, Map<String, JavaMethod>> m_nonInitializerMethodCacheWithoutReturnType = new THashMap();
    private final Map<JavaType, Map<String, JavaField>> m_fieldCache = new THashMap();
    private final IJavaElementAccessor m_elementAccessor;

    static MethodType getMethodType(String methodName) {
        assert (methodName != null && methodName.length() > 0) : "Parameter 'methodName' of method 'getMethodType' must not be empty";
        if (methodName.equals("<init>")) {
            return MethodType.CONSTRUCTOR;
        }
        if (methodName.equals("<clinit>")) {
            return MethodType.STATIC_BLOCK;
        }
        return MethodType.NON_INITIALIZER;
    }

    JavaGlobalModelHelper(IJavaElementAccessor elementAccessor) {
        assert (elementAccessor != null) : "Parameter 'elementAccessor' of method 'JavaGlobalModelHelper' must not be null";
        this.m_elementAccessor = elementAccessor;
    }

    private String getDescriptorWithoutReturnType(String descriptor) {
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'getDescriptorWithoutReturnType' must not be empty";
        int pos = descriptor.indexOf(41);
        assert (pos != -1) : "Invalid descriptor: " + descriptor;
        String relevant = descriptor.substring(0, pos + 1);
        return relevant;
    }

    void resetCache() {
        Map.Entry<String, JavaMember> nextEntry;
        Iterator<Map.Entry<String, JavaMember>> nextIterator;
        this.m_typeToDirectSuperTypes.clear();
        this.m_typeToAllSuperTypes.clear();
        this.m_typeToAllSubTypes.clear();
        for (Map<String, JavaField> map : this.m_fieldCache.values()) {
            nextIterator = map.entrySet().iterator();
            while (nextIterator.hasNext()) {
                nextEntry = nextIterator.next();
                if (nextEntry.getValue().isValid()) continue;
                nextIterator.remove();
            }
        }
        for (Map<String, JavaMember> map : this.m_methodCacheWithReturnType.values()) {
            nextIterator = map.entrySet().iterator();
            while (nextIterator.hasNext()) {
                nextEntry = nextIterator.next();
                if (((JavaMethod)nextEntry.getValue()).isValid()) continue;
                nextIterator.remove();
            }
        }
        for (Map<String, JavaMember> map : this.m_nonInitializerMethodCacheWithoutReturnType.values()) {
            nextIterator = map.entrySet().iterator();
            while (nextIterator.hasNext()) {
                nextEntry = nextIterator.next();
                if (((JavaMethod)nextEntry.getValue()).isValid()) continue;
                nextIterator.remove();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    JavaMethod getMethod(JavaType type, String name, String descriptor, MethodType methodType, boolean omitReturnTypeInLookup) {
        block19: {
            if (!JavaGlobalModelHelper.$assertionsDisabled && type == null) {
                throw new AssertionError((Object)"Parameter 'type' of method 'getMethod' must not be null");
            }
            if (!(JavaGlobalModelHelper.$assertionsDisabled || name != null && name.length() > 0)) {
                throw new AssertionError((Object)"Parameter 'name' of method 'getMethod' must not be empty");
            }
            if (!JavaGlobalModelHelper.$assertionsDisabled && descriptor == null) {
                throw new AssertionError((Object)"Parameter 'descriptor' of method 'getMethod' must not be null");
            }
            method = null;
            switch (JavaGlobalModelHelper.$SWITCH_TABLE$com$hello2morrow$sonargraph$languageprovider$java$controller$system$JavaGlobalModelHelper$MethodType()[methodType.ordinal()]) {
                case 1: 
                case 2: {
                    idToMethod = this.m_methodCacheWithReturnType.get(type);
                    method = idToMethod != null ? idToMethod.get(name + descriptor) : null;
                    break;
                }
                case 3: {
                    if (omitReturnTypeInLookup) {
                        idToMethod = this.m_nonInitializerMethodCacheWithoutReturnType.get(type);
                        method = idToMethod != null ? idToMethod.get(name + this.getDescriptorWithoutReturnType(descriptor)) : null;
                        break;
                    }
                    idToMethod = this.m_methodCacheWithReturnType.get(type);
                    method = idToMethod != null ? idToMethod.get(name + descriptor) : null;
                    break;
                }
                default: {
                    if (!JavaGlobalModelHelper.$assertionsDisabled) {
                        throw new AssertionError((Object)("Unhandled method type: " + String.valueOf((Object)methodType)));
                    }
                    break;
                }
            }
            if (method != null) break block19;
            block4 : switch (JavaGlobalModelHelper.$SWITCH_TABLE$com$hello2morrow$sonargraph$languageprovider$java$controller$system$JavaGlobalModelHelper$MethodType()[methodType.ordinal()]) {
                case 3: {
                    iter = type.getChildrenIterator(JavaNonInitializer.class);
                    if (!omitReturnTypeInLookup) ** GOTO lbl40
                    while (iter.hasNext()) {
                        next = (JavaNonInitializer)iter.next();
                        if (!next.getShortName().equals(name) || !this.getDescriptorWithoutReturnType(next.getDescriptor()).equals(this.getDescriptorWithoutReturnType(descriptor))) continue;
                        method = next;
                        break block4;
                    }
                    break;
lbl-1000:
                    // 1 sources

                    {
                        next = (JavaNonInitializer)iter.next();
                        if (!next.getShortName().equals(name) || !next.getDescriptor().equals(descriptor)) continue;
                        method = next;
                        break block4;
lbl40:
                        // 2 sources

                        ** while (iter.hasNext())
                    }
lbl41:
                    // 1 sources

                    break;
                }
                case 1: {
                    iter = type.getChildrenIterator(JavaConstructor.class);
                    while (iter.hasNext()) {
                        next = (JavaConstructor)iter.next();
                        if (!next.getDescriptor().equals(descriptor)) continue;
                        method = next;
                        break block4;
                    }
                    break;
                }
                case 2: {
                    iter = type.getChildrenIterator(JavaStaticBlock.class);
                    if (!iter.hasNext()) break;
                    method = iter.next();
                    break;
                }
                default: {
                    if (!JavaGlobalModelHelper.$assertionsDisabled) {
                        throw new AssertionError((Object)("Unhandled method type: " + String.valueOf((Object)methodType)));
                    }
                    break;
                }
            }
            if (method != null) {
                this.addMethod(type, name, descriptor, method, methodType);
            }
        }
        return method;
    }

    void addMethod(JavaType type, String name, String descriptor, JavaMethod method, MethodType methodType) {
        assert (type != null) : "Parameter 'type' of method 'addMethod' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addMethod' must not be empty";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'addMethod' must not be null";
        assert (method != null) : "Parameter 'method' of method 'addMethod' must not be null";
        assert (methodType != null) : "Parameter 'methodType' of method 'addMethod' must not be null";
        Object idToMethod = this.m_methodCacheWithReturnType.get(type);
        if (idToMethod == null) {
            idToMethod = new THashMap();
            this.m_methodCacheWithReturnType.put(type, (Map<String, JavaMethod>)idToMethod);
        }
        idToMethod.put(name + descriptor, method);
        switch (methodType) {
            case CONSTRUCTOR: 
            case STATIC_BLOCK: {
                break;
            }
            case NON_INITIALIZER: {
                idToMethod = this.m_nonInitializerMethodCacheWithoutReturnType.get(type);
                if (idToMethod == null) {
                    idToMethod = new THashMap();
                    this.m_nonInitializerMethodCacheWithoutReturnType.put(type, (Map<String, JavaMethod>)idToMethod);
                }
                idToMethod.put(name + this.getDescriptorWithoutReturnType(descriptor), method);
                break;
            }
            default: {
                assert (false) : "Unhandled method type: " + String.valueOf((Object)methodType);
                break;
            }
        }
    }

    JavaField getField(JavaType type, String name) {
        JavaField field;
        assert (type != null) : "Parameter 'type' of method 'getField' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getField' must not be empty";
        Map<String, JavaField> idToField = this.m_fieldCache.get(type);
        JavaField javaField = field = idToField != null ? idToField.get(name) : null;
        if (field == null) {
            Iterator<JavaField> iter = type.getChildrenIterator(JavaField.class);
            while (iter.hasNext()) {
                JavaField next = iter.next();
                if (!next.getShortName().equals(name)) continue;
                field = next;
                this.addField(type, name, field);
                break;
            }
        }
        return field;
    }

    void addField(JavaType type, String name, JavaField field) {
        assert (type != null) : "Parameter 'type' of method 'addField' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addField' must not be empty";
        assert (field != null) : "Parameter 'field' of method 'addField' must not be null";
        THashMap idToField = this.m_fieldCache.get(type);
        if (idToField == null) {
            idToField = new THashMap();
            this.m_fieldCache.put(type, (Map<String, JavaField>)idToField);
        }
        idToField.put(name, field);
    }

    private void collectSubTypes(JavaType type, Set<JavaType> collected) {
        assert (type != null) : "Parameter 'type' of method 'collectSubTypes' must not be null";
        assert (collected != null) : "Parameter 'collected' of method 'collectSubTypes' must not be null";
        ArrayList<JavaType> nextFroms = new ArrayList<JavaType>();
        Iterator iterator = type.getDependencyIterator();
        while (iterator.hasNext()) {
            JavaType nextFrom;
            ParserDependency nextDependency = (ParserDependency)iterator.next();
            IParserDependencyType nextDependencyType = nextDependency.getDependencyType();
            if (nextDependency.getOriginalTo() != type || nextDependencyType != JavaDependencyType.EXTENDS && nextDependencyType != JavaDependencyType.IMPLEMENTS || !collected.add(nextFrom = (JavaType)nextDependency.getOriginalFrom())) continue;
            nextFroms.add(nextFrom);
        }
        nextFroms.forEach(n -> this.collectSubTypes((JavaType)n, collected));
    }

    Set<JavaType> getSubTypes(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'getSubTypes' must not be null";
        Set<JavaType> collected = this.m_typeToAllSubTypes.get(type);
        if (collected == null) {
            collected = new LinkedHashSet<JavaType>();
            this.collectSubTypes(type, collected);
            this.m_typeToAllSubTypes.put(type, collected);
        }
        return collected;
    }

    Set<JavaType> getSuperTypes(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'getSuperTypes' must not be null";
        Set<JavaType> collected = this.m_typeToAllSuperTypes.get(type);
        if (collected == null) {
            collected = new LinkedHashSet<JavaType>();
            this.collectSuperTypes(type, collected);
            this.m_typeToAllSuperTypes.put(type, collected);
        }
        return collected;
    }

    Set<JavaType> getDirectSuperTypes(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'getDirectSuperTypes' must not be null";
        Set<JavaType> collected = this.m_typeToDirectSuperTypes.get(type);
        if (collected == null) {
            collected = new LinkedHashSet<JavaType>();
            Iterator iterator = type.getDependencyIterator();
            while (iterator.hasNext()) {
                ParserDependency nextDependency = (ParserDependency)iterator.next();
                IParserDependencyType nextDependencyType = nextDependency.getDependencyType();
                if (nextDependency.getOriginalFrom() != type || nextDependencyType != JavaDependencyType.EXTENDS && nextDependencyType != JavaDependencyType.IMPLEMENTS) continue;
                collected.add((JavaType)nextDependency.getOriginalTo());
            }
            this.m_typeToDirectSuperTypes.put(type, collected);
        }
        return collected;
    }

    private void collectSuperTypes(JavaType type, Set<JavaType> superTypes) {
        assert (type != null) : "Parameter 'type' of method 'collectSuperTypes' must not be null";
        assert (superTypes != null) : "Parameter 'superTypes' of method 'collectSuperTypes' must not be null";
        for (JavaType nextDirectSuperType : this.getDirectSuperTypes(type)) {
            if (!superTypes.add(nextDirectSuperType)) continue;
            this.collectSuperTypes(nextDirectSuperType, superTypes);
        }
    }

    private Set<JavaType> collectSuperTypes(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'collectSuperTypes' must not be null";
        Set<JavaType> collected = this.m_typeToAllSuperTypes.get(type);
        if (collected == null) {
            collected = new LinkedHashSet<JavaType>();
            this.collectSuperTypes(type, collected);
            this.m_typeToAllSuperTypes.put(type, collected);
        }
        return collected;
    }

    boolean isDerivedFrom(JavaType type, JavaType derivedFrom) {
        assert (type != null) : "Parameter 'type' of method 'isDerivedFrom' must not be null";
        assert (derivedFrom != null) : "Parameter 'derivedFrom' of method 'isDerivedFrom' must not be null";
        return type == derivedFrom ? true : this.collectSuperTypes(type).contains(derivedFrom);
    }

    private boolean isNestedWithin(JavaType type, JavaType otherType) {
        assert (type != null) : "Parameter 'type' of method 'isNestedWithin' must not be null";
        assert (otherType != null) : "Parameter 'otherType' of method 'isNestedWithin' must not be null";
        JavaType parentType = (JavaType)type.getParent(JavaType.class, new Class[0]);
        while (parentType != null) {
            if (parentType == otherType) {
                return true;
            }
            parentType = (JavaType)parentType.getParent(JavaType.class, new Class[0]);
        }
        return false;
    }

    boolean isAccessibleFrom(JavaField field, JavaType accessibleFrom) {
        String otherPackage;
        assert (field != null) : "Parameter 'field' of method 'isAccessibleFrom' must not be null";
        assert (accessibleFrom != null) : "Parameter 'accessibleFrom' of method 'isAccessibleFrom' must not be null";
        JavaType parentTypeOfField = (JavaType)field.getParent(JavaType.class, new Class[0]);
        assert (parentTypeOfField != null) : "Parameter 'parentTypeOfField' of method 'isAccessibleFrom' must not be null";
        AccessSpecifier accessSpecifier = field.getAccessSpecifier();
        if (parentTypeOfField == accessibleFrom || accessSpecifier == AccessSpecifier.PUBLIC) {
            return true;
        }
        if (this.isNestedWithin(accessibleFrom, parentTypeOfField)) {
            return true;
        }
        String packageOfField = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(parentTypeOfField.getFqName());
        if (packageOfField.equals(otherPackage = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(accessibleFrom.getFqName()))) {
            return accessSpecifier != AccessSpecifier.PRIVATE;
        }
        return accessSpecifier == AccessSpecifier.PROTECTED && this.isDerivedFrom(accessibleFrom, parentTypeOfField);
    }

    boolean inRange(List<Integer> ranges, int line) {
        assert (ranges != null && !ranges.isEmpty()) : "Parameter 'ranges' of method 'inRange' must not be empty";
        int i = 0;
        while (i < ranges.size()) {
            int from = ranges.get(i);
            int to = ranges.get(i + 1);
            if (from <= line && line <= to) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    void processSyntheticNonInitializerOfNonSyntheticType(JavaNonInitializer syntheticNonInitializer) {
        assert (syntheticNonInitializer != null) : "Parameter 'syntheticNonInitializer' of method 'processSyntheticNonInitializerOfNonSyntheticType' must not be null";
        List allDependencies = syntheticNonInitializer.getDependencies();
        ArrayList<JavaDependency> toBeProcessed = new ArrayList<JavaDependency>(allDependencies.size());
        for (ParserDependency nextParserDependency : allDependencies) {
            assert (nextParserDependency instanceof JavaDependency) : "Unexpected class in method 'processSyntheticNonInitializerOfNonSyntheticType': " + String.valueOf(nextParserDependency);
            JavaDependency nextDependency = (JavaDependency)nextParserDependency;
            if (nextDependency.getLineNumber() == -1) continue;
            ProgrammingElement nextTo = nextDependency.getOriginalTo();
            assert (nextTo instanceof JavaElement) : "Unexpected class in method 'processSyntheticNonInitializerOfNonSyntheticType': " + String.valueOf(nextTo);
            JavaElement nextToElement = (JavaElement)nextTo;
            if (nextToElement == syntheticNonInitializer || this.m_elementAccessor.isSynthetic(nextToElement)) continue;
            toBeProcessed.add(nextDependency);
        }
        if (!toBeProcessed.isEmpty()) {
            NamedElement parent = syntheticNonInitializer.getParent();
            assert (parent != null && parent instanceof JavaType) : "Unexpected class in method 'processSyntheticNonInitializerOfNonSyntheticType': " + String.valueOf(parent);
            List nonInitializers = parent.getChildren(JavaNonInitializer.class);
            block1: for (JavaDependency nextDependency : toBeProcessed) {
                int nextLineNumber = nextDependency.getLineNumber();
                for (JavaNonInitializer nextNonInitializer : nonInitializers) {
                    List<Integer> nextRanges;
                    if (nextNonInitializer == syntheticNonInitializer || this.m_elementAccessor.isSynthetic(nextNonInitializer) || (nextRanges = this.m_elementAccessor.getRangeInfo(nextNonInitializer)) == null || nextRanges.isEmpty() || !this.inRange(nextRanges, nextLineNumber)) continue;
                    JavaDependencyType nextDependencyType = (JavaDependencyType)nextDependency.getDependencyType();
                    boolean add = true;
                    if (nextDependencyType == JavaDependencyType.CATCH) {
                        Set<String> catchedTypeNamesAt = this.m_elementAccessor.getCatchedTypeNamesAt(nextNonInitializer, nextDependency.getLineNumber());
                        add = catchedTypeNamesAt.contains(nextDependency.getOriginalTo().getShortName());
                    }
                    if (!add || DependencyProcessor.dependencyAlreadyExists(nextNonInitializer, (JavaElement)nextDependency.getOriginalTo(), nextDependency.getDependencyContext(), nextDependencyType, nextDependency.getLineNumber())) continue block1;
                    nextNonInitializer.addDependency(DependencyCreator.create(nextDependency.getDependencyContext(), nextDependencyType, nextNonInitializer, nextDependency.getOriginalTo(), nextDependency.getLineNumber()));
                    continue block1;
                }
            }
        }
    }

    void addDependency(JavaElement from, JavaElement to, int line, JavaDependencyContext context, JavaDependencyType type) {
        assert (from != null) : "Parameter 'from' of method 'addDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addDependency' must not be null";
        JavaDependency dependency = DependencyProcessor.addDependency(from, to, line, context, type);
        if (dependency != null) {
            if (type == JavaDependencyType.HAS_ANNOTATION) {
                to.addFlag(JavaElementFlag.ANNOTATION);
            } else if (type == JavaDependencyType.ANNOTATION_ENUMERATION_VALUE) {
                to.addFlag(JavaElementFlag.ENUM);
            }
        }
    }

    private void collectNonSyntheticFromEndpointMethods(JavaMethod method, Set<JavaMethod> collector, Set<JavaMethod> allVisited) {
        assert (method != null) : "Parameter 'method' of method 'collectNonSyntheticFromEndpointMethods' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectNonSyntheticFromEndpointMethods' must not be null";
        assert (allVisited != null) : "Parameter 'allVisited' of method 'collectNonSyntheticFromEndpointMethods' must not be null";
        for (ParserDependency nextInDependency : method.getIncomingDependencies(new IStandardEnumeration[0])) {
            ProgrammingElement nextIn = nextInDependency.getFrom();
            if (!(nextIn instanceof JavaMethod) || allVisited.contains(nextIn)) continue;
            JavaMethod nextInMethod = (JavaMethod)nextIn;
            if (!(nextInMethod.hasFlag(JavaElementFlag.SYNTHETIC) || nextInMethod.hasFlag(JavaElementFlag.BRIDGE) || nextInMethod.hasFlag(JavaElementFlag.LAMBDA))) {
                collector.add(nextInMethod);
            } else {
                this.collectNonSyntheticFromEndpointMethods(nextInMethod, collector, allVisited);
            }
            allVisited.add((JavaMethod)nextIn);
        }
    }

    void processBridgeMethod(JavaMethod method) {
        assert (method != null) : "Parameter 'method' of method 'processBridgeMethod' must not be null";
        assert (method.hasFlag(JavaElementFlag.BRIDGE)) : "Not a bridge method: " + String.valueOf(method);
        List incomingDependenciesOfMethod = method.getIncomingDependencies(new IStandardEnumeration[0]);
        List outgoingDependenciesOfMethod = method.getOutgoingDependencies(new IParserDependencyType[0]);
        if (incomingDependenciesOfMethod.size() > 0 && outgoingDependenciesOfMethod.size() > 0) {
            for (ParserDependency nextIncomingDependency : incomingDependenciesOfMethod) {
                JavaElement nextFrom = (JavaElement)nextIncomingDependency.getOriginalFrom();
                if (nextFrom.hasFlag(JavaElementFlag.SYNTHETIC) || nextFrom.hasFlag(JavaElementFlag.BRIDGE) || nextFrom.hasFlag(JavaElementFlag.LAMBDA)) continue;
                for (ParserDependency nextOutgoingDependency : outgoingDependenciesOfMethod) {
                    JavaElement nextTo = (JavaElement)nextOutgoingDependency.getOriginalTo();
                    if (nextTo.hasFlag(JavaElementFlag.SYNTHETIC) || nextTo.hasFlag(JavaElementFlag.BRIDGE) || nextTo.hasFlag(JavaElementFlag.LAMBDA)) continue;
                    IParserDependencyType nextDependencyType = nextOutgoingDependency.getDependencyType();
                    assert (nextDependencyType != null && nextDependencyType instanceof JavaDependencyType) : "Unexpected class in method 'processBridgeOrLambdaMethod': " + String.valueOf(nextDependencyType);
                    JavaDependencyType nextJavaDependencyType = (JavaDependencyType)nextDependencyType;
                    if (nextJavaDependencyType == JavaDependencyType.RETURNS || nextJavaDependencyType == JavaDependencyType.PARAMETER || nextJavaDependencyType == JavaDependencyType.THROWS) continue;
                    this.addDependency(nextFrom, nextTo, nextIncomingDependency.getLineNumber(), ((JavaDependency)nextOutgoingDependency).getDependencyContext(), (JavaDependencyType)nextOutgoingDependency.getDependencyType());
                }
            }
        }
    }

    Set<JavaMethod> processLambdaMethod(JavaMethod method) {
        assert (method != null) : "Parameter 'method' of method 'processLambdaMethod' must not be null";
        assert (method.hasFlag(JavaElementFlag.LAMBDA)) : "Not a lambda method: " + String.valueOf(method);
        LinkedHashSet<JavaMethod> isLambdaFor = new LinkedHashSet<JavaMethod>();
        THashSet allVisited = new THashSet();
        this.collectNonSyntheticFromEndpointMethods(method, isLambdaFor, (Set<JavaMethod>)allVisited);
        Integer fallbackIncomingDependencyLineNumber = null;
        for (ParserDependency nextOutgoingDependency : method.getOutgoingDependencies(new IParserDependencyType[0])) {
            JavaElement nextTo = (JavaElement)nextOutgoingDependency.getOriginalTo();
            if (nextTo.hasFlag(JavaElementFlag.SYNTHETIC) || nextTo.hasFlag(JavaElementFlag.BRIDGE) || nextTo.hasFlag(JavaElementFlag.LAMBDA)) continue;
            IParserDependencyType nextDependencyType = nextOutgoingDependency.getDependencyType();
            assert (nextDependencyType != null && nextDependencyType instanceof JavaDependencyType) : "Unexpected class in method 'processBridgeOrLambdaMethod': " + String.valueOf(nextDependencyType);
            JavaDependencyType nextJavaDependencyType = (JavaDependencyType)nextDependencyType;
            if (nextJavaDependencyType == JavaDependencyType.RETURNS || nextJavaDependencyType == JavaDependencyType.PARAMETER || nextJavaDependencyType == JavaDependencyType.THROWS) continue;
            for (JavaMethod nextIsLambdaFor : isLambdaFor) {
                int nextOutgoingDependencyLineNumber = nextOutgoingDependency.getLineNumber();
                if (nextOutgoingDependencyLineNumber == -1) {
                    if (fallbackIncomingDependencyLineNumber == null) {
                        for (ParserDependency nextIncomingDependency : method.getIncomingDependencies(new IStandardEnumeration[0])) {
                            int nextIncomingDependencyLineNumber = nextIncomingDependency.getLineNumber();
                            if (nextIncomingDependencyLineNumber == -1) continue;
                            fallbackIncomingDependencyLineNumber = nextIncomingDependencyLineNumber;
                            break;
                        }
                        if (fallbackIncomingDependencyLineNumber == null) {
                            fallbackIncomingDependencyLineNumber = -1;
                        }
                    }
                    nextOutgoingDependencyLineNumber = fallbackIncomingDependencyLineNumber;
                }
                this.addDependency(nextIsLambdaFor, nextTo, nextOutgoingDependencyLineNumber, ((JavaDependency)nextOutgoingDependency).getDependencyContext(), (JavaDependencyType)nextOutgoingDependency.getDependencyType());
            }
        }
        return isLambdaFor;
    }

    static enum MethodType {
        CONSTRUCTOR,
        STATIC_BLOCK,
        NON_INITIALIZER;

    }
}

