/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerIdImplementation;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptLanguage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public enum TypescriptAnalyzerId implements IConfigurableAnalyzerId
{
    TYPESCRIPT_DIRECTORY_CYCLES_MODULE(SonargraphFeature.PLATFORM, "TypeScript Directory Cycles (Module)", "Analyzes directory cycles on module level", CycleAnalyzerConfiguration.CREATOR_DIRECTORY_CYCLES, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLES, Arrays.asList(AnalyzerGroup.CYCLE_METRICS)),
    TYPESCRIPT_DIRECTORY_CYCLES_MODULE_METRICS(SonargraphFeature.PLATFORM, "TypeScript Directory Cycle Metrics (Module)", "Computes directory cycle metrics on module level", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLE_METRICS, Collections.emptyList()),
    TYPESCRIPT_DIRECTORY_CYCLES_SYSTEM(SonargraphFeature.PLATFORM, "TypeScript Directory Cycles (System)", "Analyzes directory cycles on system level", CycleAnalyzerConfiguration.CREATOR_DIRECTORY_CYCLES, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLES, Arrays.asList(AnalyzerGroup.CYCLE_METRICS)),
    TYPESCRIPT_DIRECTORY_CYCLES_SYSTEM_METRICS(SonargraphFeature.PLATFORM, "TypeScript Directory Cycle Metrics (System)", "Computes directory cycle metrics on system level", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLE_METRICS, Collections.emptyList());

    private final AnalyzerIdImplementation m_implementation;

    private TypescriptAnalyzerId(SonargraphFeature feature, String presentationName, String description, IConfigurationCreator creator, AnalyzerExecutionLevel level, AnalyzerGroup group, List<AnalyzerGroup> affectedGroups) {
        this.m_implementation = new AnalyzerIdImplementation(feature, presentationName, description, creator, level, group, affectedGroups);
    }

    public Language getLanguage() {
        return TypescriptLanguage.INSTANCE;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_implementation.getPresentationName();
    }

    public String getDescription() {
        return this.m_implementation.getDescription();
    }

    public boolean hasConfiguration() {
        return this.m_implementation.hasConfiguration();
    }

    public IConfigurationCreator getConfigurationCreator() {
        return this.m_implementation.getConfigurationCreator();
    }

    public SonargraphFeature getFeature() {
        return this.m_implementation.getFeature();
    }

    public AnalyzerExecutionLevel getExecutionLevel() {
        return this.m_implementation.getExecutionLevel();
    }

    public AnalyzerGroup getGroup() {
        return this.m_implementation.getGroup();
    }

    public Set<AnalyzerGroup> getAffectedGroups() {
        return this.m_implementation.getAffectedGroups();
    }
}

