/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser.IModelBuilder;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser.TypescriptParserMessageCause;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.FileLocator;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NodeParserScript {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeParserScript.class);
    private final IModelBuilder m_modelBuilder;
    private double m_msPerFile;
    private final String m_nodePath;

    NodeParserScript(IModelBuilder mb, String nodePath) {
        assert (mb != null) : "Parameter 'mb' of method 'NodeParserScript' must not be null";
        this.m_modelBuilder = mb;
        this.m_nodePath = nodePath;
    }

    private static File getBundleRoot(String bundleId) {
        URL url;
        String urlString;
        block4: {
            assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getFileInBundleOsgi' must not be empty";
            urlString = "platform:///plugin/" + bundleId + "/";
            url = FileLocator.find((URL)new URI(urlString).toURL());
            if (url != null) break block4;
            LOGGER.error("Couldn't find file '{}' in osgi bundle '{}'", (Object)urlString, (Object)bundleId);
            return null;
        }
        try {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            URI fileUri = new URI(fileUrl.getProtocol(), fileUrl.getPath(), null).normalize();
            File file = new File(fileUri);
            LOGGER.debug("Found {} for {}", (Object)file.getAbsolutePath(), (Object)urlString);
            return file;
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            LOGGER.error("Couldn't find '{}': '{}'", (Object)urlString, (Object)e.getMessage());
            return null;
        }
    }

    private String getParserScriptPath() {
        TFile parserScriptPath = new TFile("../com.hello2morrow.sonargraph.language.provider.typescript/ts-analyzer/dist/index.js");
        if (parserScriptPath.canRead()) {
            return parserScriptPath.getNormalizedAbsolutePath();
        }
        File root = NodeParserScript.getBundleRoot("com.hello2morrow.sonargraph.language.provider.typescript");
        if (root == null) {
            return null;
        }
        File result = new File(root, "ts-analyzer/dist/index.js");
        return result.getAbsolutePath();
    }

    double getMsPerFile() {
        return this.m_msPerFile;
    }

    OperationResultWithOutcome<JSONObject> run(IWorkerContext workerContext, String tsConfigPath, double msPerFile) {
        assert (tsConfigPath != null && tsConfigPath.length() > 0) : "Parameter 'tsConfigPath' of method 'run' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Running Typescript Parser");
        String parserScriptPath = this.getParserScriptPath();
        if (parserScriptPath == null) {
            result.addError((OperationResult.IMessageCause)TypescriptParserMessageCause.CANNOT_FIND_PARSERSCRIPT, "Cannot find Typescript parser script", new Object[0]);
            return result;
        }
        LOGGER.info("Typescript parser script path: " + parserScriptPath);
        ProcessBuilder pb = new ProcessBuilder(this.m_nodePath, parserScriptPath, tsConfigPath);
        Process process = null;
        workerContext.setNumberOfSteps(2, new int[]{10, 90});
        long startTime = System.currentTimeMillis();
        workerContext.beginSubTask("Parsing system");
        ProgressDaemon progressDaemon = new ProgressDaemon(workerContext, 4000.0);
        try {
            process = pb.start();
        }
        catch (IOException e) {
            LOGGER.error("Could not start NodeJS parser script: " + e.getMessage(), (Throwable)e);
            result.addError((OperationResult.IMessageCause)TypescriptParserMessageCause.CANNOT_START_PARSERSCRIPT, "Cannot start parser script.", new Object[]{e});
            return result;
        }
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        BufferedReader errorOutput = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        Thread errorMonitor = new Thread(() -> this.monitorErrorOutput(errorOutput, (OperationResult)result));
        errorMonitor.start();
        String line = this.readLineFromProcess(processOutput);
        if (line != null && line.equals("Parsing project")) {
            line = this.readLineFromProcess(processOutput);
            try {
                int numberOfSourceFiles = Integer.parseInt(line);
                long parseTime = System.currentTimeMillis() - startTime;
                progressDaemon.finish();
                workerContext.endSubTask();
                workerContext.beginSubTask("Analyzing dependencies");
                progressDaemon = new ProgressDaemon(workerContext, (double)numberOfSourceFiles * msPerFile);
                int i = 0;
                while (i < numberOfSourceFiles) {
                    String path = this.readLineFromProcess(processOutput);
                    if (path == null) {
                        result.addError((OperationResult.IMessageCause)TypescriptParserMessageCause.PARSER_SCRIPT_FAILED, "Parse script failed to deliver result", new Object[0]);
                        LOGGER.error("No result from parser script (path missing)");
                        break;
                    }
                    this.m_modelBuilder.processSourceFile(path);
                    ++i;
                }
                this.m_modelBuilder.finishSourceProcessing();
                if (result.isSuccess()) {
                    LOGGER.info("Typescript parse time for " + numberOfSourceFiles + " files was " + parseTime + "ms.");
                    String jsonData = this.readLineFromProcess(processOutput);
                    long analyzerTime = System.currentTimeMillis() - parseTime - startTime;
                    LOGGER.info("Typescript analyzer time for " + numberOfSourceFiles + " files was " + analyzerTime + "ms.");
                    this.m_msPerFile = (double)analyzerTime / (double)numberOfSourceFiles;
                    if (jsonData == null) {
                        result.addError((OperationResult.IMessageCause)TypescriptParserMessageCause.PARSER_SCRIPT_FAILED, "Parse script failed to deliver result", new Object[0]);
                        LOGGER.error("No result from parser script");
                    } else {
                        JSONObject model = (JSONObject)JSONValue.parseWithException((String)jsonData);
                        result.setOutcome((Object)model);
                    }
                    progressDaemon.finish();
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("Unexpected output from Typescript parsing script: " + line);
                result.addError((OperationResult.IMessageCause)TypescriptParserMessageCause.UNEXPECTED_SCRIPT_OUTPUT, "Cannot parse number output from parser script", new Object[0]);
            }
            catch (ParseException e) {
                LOGGER.error("cannot parse JSON typescript model data: " + e.getMessage());
                result.addError((OperationResult.IMessageCause)TypescriptParserMessageCause.UNEXPECTED_SCRIPT_OUTPUT, "Cannot parse JSON output from parser script", new Object[0]);
            }
        } else {
            result.addError((OperationResult.IMessageCause)TypescriptParserMessageCause.UNEXPECTED_SCRIPT_OUTPUT, "Unexpected script output: " + line, new Object[0]);
        }
        try {
            if (errorMonitor.isAlive()) {
                errorMonitor.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private String readLineFromProcess(BufferedReader processOutput) {
        try {
            String result = processOutput.readLine();
            return result;
        }
        catch (IOException e) {
            LOGGER.error("Error when reading from Roslyn Daemon: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void monitorErrorOutput(BufferedReader errorOutput, OperationResult result) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = errorOutput.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        String message = sb.toString();
        if (!message.isEmpty()) {
            LOGGER.warn("Parser script error output:\n '" + message + "'");
            result.addWarning((OperationResult.IMessageCause)TypescriptParserMessageCause.SCRIPT_ERROR_OUTPUT, message, new Object[0]);
        }
    }

    private class ProgressDaemon {
        private final IWorkerContext m_workerContext;
        private final int m_incrementInMs;
        private final Thread m_progressThread;
        private int m_counter = 0;
        private boolean m_finished = false;

        ProgressDaemon(IWorkerContext workerContext, double totalTimeInMs) {
            this.m_workerContext = workerContext;
            this.m_incrementInMs = (int)(totalTimeInMs / 100.0) + 1;
            this.m_progressThread = new Thread(() -> this.run());
            this.m_progressThread.start();
            this.m_workerContext.beginBlockOfWork(100);
        }

        void run() {
            try {
                while (!this.m_finished && this.m_counter < 99) {
                    Thread.sleep(this.m_incrementInMs);
                    ++this.m_counter;
                    this.m_workerContext.workItemCompleted();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void finish() {
            this.m_finished = true;
            try {
                this.m_progressThread.join();
            }
            catch (InterruptedException interruptedException) {}
            while (this.m_counter < 100) {
                this.m_workerContext.workItemCompleted();
                ++this.m_counter;
            }
        }
    }
}

