/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.settings.TypescriptInterpreterValidator;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.NodeJsLocator;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.ITypescriptSettingsProvider;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypescriptSettingsExtension
extends Extension
implements ITypescriptSettingsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypescriptSettingsExtension.class);
    private static final String SETTINGS_FILE_NAME = "TypescriptSettings.properties";
    private static final String NODE_PATH = "NODE_PATH";
    private final TFile m_typescriptSettingsDir;
    private final Properties m_settings = new Properties();

    public TypescriptSettingsExtension(TFile typescriptSettingsDir) {
        assert (typescriptSettingsDir != null && typescriptSettingsDir.isDirectory());
        this.m_typescriptSettingsDir = typescriptSettingsDir;
        TFile settingsFile = this.getSettingsFile();
        if (settingsFile.canRead()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader((File)settingsFile));){
                    this.m_settings.load(reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot read TypeScript settings file: ", (Throwable)e);
            }
        }
    }

    @Override
    public TFile getNodeFile() {
        String path = this.m_settings.getProperty(NODE_PATH);
        if (path == null) {
            path = NodeJsLocator.locateNodeJsExecutable();
        }
        if (path == null) {
            return null;
        }
        return new TFile(path);
    }

    private TFile getSettingsFile() {
        return new TFile((File)this.m_typescriptSettingsDir, SETTINGS_FILE_NAME);
    }

    @Override
    public void setNodeFile(TFile nodeExeFile) {
        if (nodeExeFile == null) {
            this.m_settings.remove(NODE_PATH);
        } else {
            this.m_settings.put(NODE_PATH, nodeExeFile.getNormalizedAbsolutePath());
        }
        if (this.m_settings.isEmpty()) {
            try {
                this.getSettingsFile().rm();
            }
            catch (IOException iOException) {}
        } else {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)this.getSettingsFile()));){
                    this.m_settings.store(writer, "TypeScript Settings");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("failed to save TypeScript settings: ", (Throwable)e);
            }
        }
    }

    @Override
    public IPathValidator getNodeJSPathValidator() {
        return new TypescriptInterpreterValidator();
    }
}

