/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.DynamicSystemRequest;
import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.ServiceResponseWithOutcome;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.api.SystemOpenRequest;
import com.hello2morrow.sonargraph.build.client.BuildInteraction;
import com.hello2morrow.sonargraph.build.client.ILogger;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;
import com.hello2morrow.sonargraph.build.client.Params;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class CreateReportInteraction
extends BuildInteraction {
    public static final String SONARGRAPH_SYSTEM_DIR_SUFFIX = ".sonargraph";
    private static final String VIRTUAL_MODEL_EXTENSION = ".vm";
    private static final String QUALITY_MODEL_EXTENSION = ".sgqm";
    private static final String WORKSPACE_PROFILE_EXTENSION = ".xml";
    public static final String SONARGRAPH_SONARQUBE_REPORT_FILENAME = "sonargraph-sonarqube-report.xml";
    public static final String SONARGRAPH_TARGET_DIR = "sonargraph";
    private final SystemOpenRequest m_openRequest;
    private final ReportRequest m_reportRequest;
    private final FailSet m_failSet;
    private final DynamicSystemRequest m_dynamicSystemRequest;

    public CreateReportInteraction(ISonargraphBuildClient client, SystemOpenRequest openRequest, ReportRequest reportRequest, FailSet failSet) {
        super(client);
        assert (openRequest != null) : "Parameter 'openRequest' of method 'CreateReportInteraction' must not be null";
        assert (reportRequest != null) : "Parameter 'reportRequest' of method 'CreateReportInteraction' must not be null";
        this.m_dynamicSystemRequest = null;
        this.m_openRequest = openRequest;
        this.m_reportRequest = reportRequest;
        this.m_failSet = failSet;
    }

    public CreateReportInteraction(ISonargraphBuildClient client, DynamicSystemRequest dynamicSystemRequest, SystemOpenRequest openRequest, ReportRequest reportRequest, FailSet failSet) {
        super(client);
        assert (dynamicSystemRequest != null) : "Parameter 'dynamicSystemRequest' of method 'CreateReportInteraction' must not be null";
        assert (openRequest != null) : "Parameter 'openRequest' of method 'CreateReportInteraction' must not be null";
        assert (reportRequest != null) : "Parameter 'reportRequest' of method 'CreateReportInteraction' must not be null";
        this.m_dynamicSystemRequest = dynamicSystemRequest;
        this.m_openRequest = openRequest;
        this.m_reportRequest = reportRequest;
        this.m_failSet = failSet;
    }

    @Override
    public ServiceResponse validateInput(ILogger logger) {
        assert (logger != null) : "Parameter 'logger' of method 'validateInput' must not be null";
        StringBuilder errorMsg = new StringBuilder();
        if (this.m_dynamicSystemRequest != null) {
            this.validateDynamicSystemRequest(errorMsg, this.m_dynamicSystemRequest);
            this.m_openRequest.setQualityModelFile(null);
            this.m_openRequest.setSystemDirectory(null);
        }
        this.validateOpenRequest(errorMsg);
        this.validateReportRequest(errorMsg, logger);
        if (errorMsg.length() > 0) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, errorMsg.toString());
        }
        return new ServiceResponse(StatusCode.OK, "All input parameters are valid.");
    }

    @Override
    public ServiceResponse execute(ISonargraphBuild sonargraphBuild, ILogger logger) throws SonargraphBuildException {
        File systemDirectory;
        ServiceResponse open;
        assert (sonargraphBuild != null) : "Parameter 'sonargraphBuild' of method 'execute' must not be null";
        assert (logger != null) : "Parameter 'logger' of method 'execute' must not be null";
        if (this.m_dynamicSystemRequest != null) {
            ServiceResponseWithOutcome<File> create = this.generateDynamicSystem(this.m_dynamicSystemRequest, sonargraphBuild, logger);
            if (create.isFailure() || !create.getOutcome().isPresent()) {
                return create;
            }
            File systemDir = create.getOutcome().get();
            this.m_openRequest.setSystemDirectory(systemDir.getAbsolutePath());
            this.m_openRequest.setQualityModelFile(null);
        }
        File qualityModelFile = this.getQualityModelPath(this.m_openRequest.getQualityModelFile());
        ISonargraphBuild.Version version = sonargraphBuild.getVersion();
        if (version.compareTo(new ISonargraphBuild.Version(8, 6, 3, 356)) <= 0) {
            logger.info("Workspace profiles are not supported by SonargraphBuild version: " + version.toString());
            this.m_openRequest.setWorkspaceProfile(null);
        }
        if ((open = sonargraphBuild.open(systemDirectory = new File(this.m_openRequest.getSystemDirectory()), this.m_openRequest.getSystemInfo(), this.m_openRequest.getWorkspaceProfile(), qualityModelFile, this.m_openRequest.getInstallationSpecificParameters())).isFailure()) {
            logger.error("Open failed: " + open.getStatusMessage());
            return open;
        }
        if (qualityModelFile != null) {
            try {
                logger.info("NOTE: Specified quality model '" + qualityModelFile.getCanonicalPath() + "' will replace all analyzer configuration, architecture, script and quality model files!");
            }
            catch (IOException e) {
                logger.info("NOTE: Specified quality model will replace all analyzer configuration, architecture, script and quality model files!");
            }
        }
        boolean alreadyClosed = false;
        try {
            ServiceResponse close;
            ServiceResponse refresh;
            String virtualModel = this.m_openRequest.getVirtualModel();
            if (virtualModel != null && virtualModel.trim().length() > 0) {
                ServiceResponse setModel = sonargraphBuild.setVirtualModel(virtualModel);
                if (setModel.isFailure()) {
                    ServiceResponse serviceResponse = setModel;
                    return serviceResponse;
                }
                if (setModel.getStatusCode() == StatusCode.WARNINGS_EXIST) {
                    logger.error(setModel.getStatusMessage());
                }
            }
            if ((refresh = sonargraphBuild.refresh()).isFailure()) {
                logger.error("Refresh failed: " + refresh.getStatusMessage());
                ServiceResponse serviceResponse = refresh;
                return serviceResponse;
            }
            if (this.m_openRequest.getActualSnapshotDirectory() != null) {
                ServiceResponse snapshotResponse = sonargraphBuild.createSnapshot(this.m_openRequest.getActualSnapshotDirectory(), this.m_openRequest.getSnapshotFileName());
                if (snapshotResponse.isFailure()) {
                    logger.info("Snapshot was not created: " + snapshotResponse.getStatusMessage());
                } else if (this.m_reportRequest.getUploadHostUrl() != null && !this.m_reportRequest.getUploadHostUrl().trim().isEmpty() && snapshotResponse.getResult() != null) {
                    this.m_reportRequest.setSnapshotPath(snapshotResponse.getResult().toString());
                }
            }
            File actualReportDirectory = this.m_reportRequest.getActualReportDirectory();
            ServiceResponse createReportServiceResponse = sonargraphBuild.createReport(this.m_reportRequest);
            if (createReportServiceResponse.isFailure()) {
                logger.error(String.format("Creation of report '%s' failed: %s", this.m_reportRequest.getReportBaseName(), createReportServiceResponse.getStatusMessage()));
                ServiceResponse serviceResponse = createReportServiceResponse;
                return serviceResponse;
            }
            if (createReportServiceResponse.getStatusCode() == StatusCode.WARNINGS_EXIST) {
                logger.info(String.format("Creation of report '%s' finished with warnings: %s", this.m_reportRequest.getReportBaseName(), createReportServiceResponse.getStatusMessage()));
            } else if (createReportServiceResponse.getStatusCode() == StatusCode.ERRORS_EXIST) {
                logger.info(String.format("Creation of report '%s' finished with errors: %s", this.m_reportRequest.getReportBaseName(), createReportServiceResponse.getStatusMessage()));
            } else {
                logger.info(String.format("Report '%s' was successfully created", this.m_reportRequest.getReportBaseName()));
            }
            if (this.m_reportRequest.isPrepareForSonarQube()) {
                this.prepareForSonarQube(logger, systemDirectory, actualReportDirectory);
            }
            this.checkQualityGates(sonargraphBuild, logger);
            if (this.m_failSet != null) {
                ServiceResponse failResponse = sonargraphBuild.failIfExists(this.m_failSet);
                if (failResponse.isFailure()) {
                    ServiceResponse serviceResponse = failResponse;
                    return serviceResponse;
                }
                if (failResponse.getStatusCode() == StatusCode.WARNINGS_EXIST) {
                    logger.info(failResponse.getStatusMessage());
                }
            }
            if ((close = sonargraphBuild.close()).isFailure()) {
                ServiceResponse serviceResponse = close;
                return serviceResponse;
            }
            alreadyClosed = true;
            ServiceResponse serviceResponse = new ServiceResponse(StatusCode.OK, "Successfully executed interaction");
            return serviceResponse;
        }
        finally {
            ServiceResponse close;
            if (!alreadyClosed && (close = sonargraphBuild.close()).isFailure()) {
                logger.error("Failed to close system: " + close.getStatusMessage());
            }
        }
    }

    private void checkQualityGates(ISonargraphBuild sonargraphBuild, ILogger logger) {
        ServiceResponse qualityGateCheck = sonargraphBuild.checkQualityGates();
        if (qualityGateCheck.isFailure()) {
            logger.error(qualityGateCheck.getStatusMessage());
            if (qualityGateCheck.getResult() != null) {
                logger.error(qualityGateCheck.getResult().toString());
            }
        } else if (qualityGateCheck.getResult() != null) {
            logger.info(qualityGateCheck.getStatusMessage());
            logger.info(qualityGateCheck.getResult().toString());
        } else {
            logger.info(qualityGateCheck.getStatusMessage());
        }
    }

    private void prepareForSonarQube(ILogger logger, File systemDirectory, File actualReportDirectory) throws SonargraphBuildException {
        File xmlReportFile = this.determineXmlReportFile(actualReportDirectory, this.m_reportRequest.getReportFileName(), systemDirectory);
        if (xmlReportFile == null) {
            logger.error("Generated XML report cannot be found");
        } else if (!xmlReportFile.exists() || xmlReportFile.isDirectory()) {
            logger.error("Generated XML report cannot be found at " + xmlReportFile.getAbsolutePath());
        } else {
            for (File next : this.m_reportRequest.getReportDistributionDirectories()) {
                File targetDirectory = new File(next, SONARGRAPH_TARGET_DIR);
                if (!targetDirectory.mkdirs() && !targetDirectory.isDirectory()) {
                    logger.error(String.format("Failed to create directory: %s", targetDirectory.getAbsolutePath()));
                    continue;
                }
                this.distributeSonarQubeReportToDirectory(targetDirectory, xmlReportFile, logger);
            }
            if (!this.m_reportRequest.getReportFormat().toLowerCase().contains(ReportRequest.ReportFormat.XML.name().toLowerCase()) && !xmlReportFile.delete()) {
                logger.error("Failed to delete temporary XML report: " + xmlReportFile.getAbsolutePath());
            }
        }
    }

    private File determineXmlReportFile(File reportDirectory, String reportName, File systemDirectory) throws SonargraphBuildException {
        assert (reportDirectory != null) : "Parameter 'reportDirectory' of method 'determineXmlReportFile' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'determineXmlReportFile' must not be null";
        String xmlExtension = ReportRequest.ReportFormat.XML.name().toLowerCase();
        if (reportName != null && reportName.trim().length() > 0) {
            return new File(reportDirectory, reportName + "." + xmlExtension);
        }
        int endIndex = systemDirectory.getName().indexOf(SONARGRAPH_SYSTEM_DIR_SUFFIX);
        String systemName = systemDirectory.getName().substring(0, endIndex);
        File[] files = reportDirectory.listFiles((dir, name) -> name.startsWith(systemName) && name.endsWith(xmlExtension));
        if (files.length == 0) {
            throw new SonargraphBuildException("Failed to determine generated Sonargraph report file in directory " + String.valueOf(reportDirectory));
        }
        File lastReport = null;
        long lastModified = -1L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File next = fileArray[n2];
            long currentLastModified = next.lastModified();
            if (currentLastModified > lastModified) {
                lastModified = currentLastModified;
                lastReport = next;
            }
            ++n2;
        }
        if (lastReport == null) {
            throw new SonargraphBuildException("Failed to determine generated Sonargraph report file in directory " + String.valueOf(reportDirectory));
        }
        return lastReport;
    }

    private void distributeSonarQubeReportToDirectory(File targetBaseDir, File report, ILogger logger) throws SonargraphBuildException {
        assert (targetBaseDir != null) : "Parameter 'dir' of method 'distributeSonarQubeReportToDirectory' must not be null";
        assert (report != null) : "Parameter 'report' of method 'distributeSonarQubeReportToDirectory' must not be null";
        assert (logger != null) : "Parameter 'logger' of method 'distributeSonarQubeReportToDirectory' must not be null";
        if (!targetBaseDir.mkdirs() && !targetBaseDir.isDirectory()) {
            throw new SonargraphBuildException(String.format("Failed to create directory '%s'", targetBaseDir.getPath()));
        }
        Path target = Paths.get(targetBaseDir.getAbsolutePath(), SONARGRAPH_SONARQUBE_REPORT_FILENAME);
        Path src = Paths.get(report.getAbsolutePath(), new String[0]);
        try {
            Files.copy(src, target, StandardCopyOption.REPLACE_EXISTING);
            logger.info("Successfully copied Sonargraph report to " + String.valueOf(target));
        }
        catch (IOException ex) {
            String errorMsg = String.format("Failed to copy Sonargraph report '%s' to '%s'", src.toAbsolutePath(), target.toAbsolutePath());
            throw new SonargraphBuildException(errorMsg, ex);
        }
    }

    private void validateOpenRequest(StringBuilder errorMsg) {
        String qualityModelFile;
        String workspaceProfile;
        assert (errorMsg != null) : "Parameter 'errorMsg' of method 'validateOpenRequest' must not be null";
        if (this.m_dynamicSystemRequest == null) {
            File systemDirectory;
            String systemPath = this.m_openRequest.getSystemDirectory();
            if (systemPath == null) {
                errorMsg.append(String.format("Parameter '%s' must be specified.\n", Params.SYSTEM_DIRECTORY.getParameterName()));
                return;
            }
            if (!systemPath.trim().endsWith(SONARGRAPH_SYSTEM_DIR_SUFFIX)) {
                errorMsg.append(String.format("Parameter '%s' must end with '%s': %s\n", Params.SYSTEM_DIRECTORY.getParameterName(), SONARGRAPH_SYSTEM_DIR_SUFFIX, systemPath));
            }
            if ((systemDirectory = new File(systemPath)).getParentFile() == null) {
                Path adjustedPath = Paths.get(".", systemPath);
                systemDirectory = adjustedPath.toAbsolutePath().toFile();
                this.m_openRequest.setSystemDirectory(adjustedPath.toString());
            }
            if (!systemDirectory.isDirectory()) {
                errorMsg.append(String.format("Parameter '%s' is not a directory: %s\n", Params.SYSTEM_DIRECTORY.getParameterName(), systemDirectory));
            } else if (!systemDirectory.canRead()) {
                errorMsg.append(String.format("Parameter '%s' is not a readable directory: %s\n", Params.SYSTEM_DIRECTORY.getParameterName(), systemDirectory));
            }
        } else {
            if (this.m_openRequest.getSystemDirectory() != null) {
                this.m_client.info(String.format("Ignoring parameter '%s' for dynamic system creation", Params.SYSTEM_DIRECTORY.getParameterName()));
                this.m_openRequest.setSystemDirectory(null);
            }
            if (this.m_openRequest.getQualityModelFile() != null) {
                this.m_openRequest.setQualityModelFile(null);
            }
        }
        String virtualModel = this.m_openRequest.getVirtualModel();
        if (virtualModel != null && !virtualModel.equalsIgnoreCase("Parser") && !virtualModel.trim().endsWith(VIRTUAL_MODEL_EXTENSION)) {
            errorMsg.append(String.format("Parameter '%s' must end with '%s'\n", Params.VIRTUAL_MODEL.getParameterName(), VIRTUAL_MODEL_EXTENSION));
        }
        if ((workspaceProfile = this.m_openRequest.getWorkspaceProfile()) != null && workspaceProfile.trim().length() > 0) {
            if (!workspaceProfile.trim().endsWith(WORKSPACE_PROFILE_EXTENSION)) {
                errorMsg.append(String.format("Parameter '%s' must end with '%s'\n", Params.WORKSPACE_PROFILE.getParameterName(), WORKSPACE_PROFILE_EXTENSION));
            }
            if (this.m_openRequest.getSystemInfo() != null) {
                errorMsg.append(String.format("'%s' and 'overrideSonargraphWorkspace' cannot be set at the same time\n", Params.WORKSPACE_PROFILE.getParameterName()));
            }
        }
        if ((qualityModelFile = this.m_openRequest.getQualityModelFile()) != null) {
            if (!qualityModelFile.endsWith(QUALITY_MODEL_EXTENSION)) {
                errorMsg.append(String.format("Parameter '%s' must end with '%s'\n", Params.QUALITY_MODEL_FILE.getParameterName(), QUALITY_MODEL_EXTENSION));
            }
            if (!qualityModelFile.startsWith("Sonargraph:")) {
                File file = new File(qualityModelFile);
                if (!file.exists()) {
                    errorMsg.append(String.format("Parameter '%s' does not exist: %s\n", Params.QUALITY_MODEL_FILE.getParameterName(), qualityModelFile));
                } else if (!file.canRead()) {
                    errorMsg.append(String.format("Parameter '%s' is not a readable file: %s\n", Params.QUALITY_MODEL_FILE.getParameterName(), qualityModelFile));
                }
            }
        }
        String snapshotPath = this.m_openRequest.getSnapshotDirectory();
        boolean createSnapshot = true;
        if (snapshotPath == null || snapshotPath.trim().length() == 0) {
            String snapshotFileName = this.m_openRequest.getSnapshotFileName();
            boolean bl = createSnapshot = snapshotFileName != null && snapshotFileName.trim().length() > 0;
        }
        if (!createSnapshot && this.m_reportRequest.isCreateAndUploadSnapshot() && this.m_reportRequest.getUploadHostUrl() != null && !this.m_reportRequest.getUploadHostUrl().trim().isEmpty()) {
            createSnapshot = true;
        }
        if (createSnapshot) {
            File snapshotDirectory = snapshotPath == null ? this.m_client.getDefaultOutputDirectory() : new File(snapshotPath);
            if (!snapshotDirectory.mkdirs() && !snapshotDirectory.isDirectory()) {
                errorMsg.append(String.format("'snapshotDirectory' '%s' is not a directory or could not be created\n", snapshotDirectory));
            } else {
                try {
                    this.m_openRequest.setActualSnapshotDirectory(snapshotDirectory.getCanonicalFile());
                }
                catch (IOException ex) {
                    errorMsg.append(String.format("Failed to set '%s': %s\n", Params.SNAPSHOT_DIRECTORY.getParameterName(), ex.getMessage()));
                }
            }
        }
    }

    private void validateReportRequest(StringBuilder errorMsg, ILogger logger) {
        assert (this.m_reportRequest != null) : "Parameter 'm_reportRequest' of method 'validateReportRequest' must not be null";
        assert (errorMsg != null) : "Parameter 'errorMsg' of method 'validateReportRequest' must not be null";
        assert (logger != null) : "Parameter 'logger' of method 'validateReportRequest' must not be null";
        this.validateReportType(errorMsg);
        HashSet<ReportRequest.ReportFormat> formats = new HashSet<ReportRequest.ReportFormat>();
        String reportFormat = this.m_reportRequest.getReportFormat();
        Object actualReportFormat = null;
        if (reportFormat == null) {
            formats.add(ReportRequest.ReportFormat.HTML);
            reportFormat = ReportRequest.ReportFormat.HTML.name();
        }
        ArrayList<String> reasonForAddingXmlFormat = new ArrayList<String>();
        if (this.m_reportRequest.isPrepareForSonarQube()) {
            reasonForAddingXmlFormat.add("prepareForSonarQube");
        }
        if (this.m_reportRequest.getBaselineReportPath() != null) {
            reasonForAddingXmlFormat.add(Params.BASELINE_REPORT_PATH.getParameterName());
        }
        if (this.m_reportRequest.getUploadHostUrl() != null && !this.m_reportRequest.getUploadHostUrl().trim().isEmpty()) {
            reasonForAddingXmlFormat.add(Params.UPLOAD_HOST_URL.getParameterName());
        }
        if (reasonForAddingXmlFormat.size() > 0) {
            if (!reportFormat.toLowerCase().contains(ReportRequest.ReportFormat.XML.name().toLowerCase())) {
                logger.info(String.format("Adding report format '%s', because %s %s configured.", ReportRequest.ReportFormat.XML.name().toLowerCase(), reasonForAddingXmlFormat.stream().collect(Collectors.joining(", ")), reasonForAddingXmlFormat.size() == 1 ? "is" : "are"));
                actualReportFormat = reportFormat + ", " + ReportRequest.ReportFormat.XML.name().toLowerCase();
            } else {
                actualReportFormat = reportFormat;
            }
        } else {
            actualReportFormat = reportFormat;
        }
        formats.addAll(this.convertAndValidateReportFormats((String)actualReportFormat, errorMsg));
        if (this.m_reportRequest.getBaselineReportPath() != null) {
            logger.info("INFO: The new HTML diff report will be generated.");
            formats.add(ReportRequest.ReportFormat.HTML);
        }
        this.m_reportRequest.setActualReportFormats(formats);
        File actualDirectory = this.getActualReportDirectory(this.m_reportRequest);
        if (!actualDirectory.mkdirs() && !actualDirectory.isDirectory()) {
            errorMsg.append(String.format("Failed to create report directory: %s\n", actualDirectory.getAbsolutePath()));
        } else {
            try {
                this.m_reportRequest.setActualReportDirectory(actualDirectory.getCanonicalFile());
            }
            catch (IOException ex) {
                errorMsg.append(String.format("Invalid parameter '%s': %s\n", Params.REPORT_DIRECTORY.getParameterName(), ex.getMessage()));
            }
        }
        if (this.m_reportRequest.getUploadHostUrl() != null && this.m_reportRequest.getUploadHostUrl().trim().length() > 0) {
            String clientKey;
            if (!this.m_reportRequest.getUploadHostUrl().startsWith("http://") && !this.m_reportRequest.getUploadHostUrl().startsWith("https://")) {
                errorMsg.append(String.format("Invalid parameter '%s': %s. It must start with 'http://' or 'https://'\"", Params.UPLOAD_HOST_URL.getParameterName(), this.m_reportRequest.getUploadHostUrl()));
            }
            if ((clientKey = this.m_reportRequest.getClientKey()) == null || clientKey.length() == 0) {
                errorMsg.append(String.format("The parameter '%s' must not be empty, if '%s' is defined.\n", Params.CLIENT_KEY.getParameterName(), Params.UPLOAD_HOST_URL.getParameterName()));
            }
        }
        if (this.m_reportRequest.getTimestampAsString() != null && this.m_reportRequest.getTimestampAsString().trim().length() > 0) {
            Date actualTimestamp = this.parseDateAndTimeForUniversalTimezone(this.m_reportRequest.getTimestampAsString().trim());
            if (actualTimestamp == null) {
                errorMsg.append(String.format("Invalid parameter '%s': %s. It does not conform to ISO-8601 extended offset date-time format, e.g. '2011-12-03T10:15:30+01:00'\n", Params.TIMESTAMP.getParameterName(), this.m_reportRequest.getTimestampAsString()));
            } else {
                this.m_reportRequest.setActualTimestamp(actualTimestamp);
            }
        }
    }

    private File getActualReportDirectory(ReportRequest reportRequest) {
        return reportRequest.getReportDirectory() == null ? new File(this.m_client.getDefaultOutputDirectory(), SONARGRAPH_TARGET_DIR) : new File(reportRequest.getReportDirectory());
    }

    private Date parseDateAndTimeForUniversalTimezone(String date) {
        assert (date != null) : "'date' must not be null";
        assert (date.length() > 0) : "'date' must not be empty";
        try {
            TemporalAccessor ta = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(date);
            Instant instant = Instant.from(ta);
            return Date.from(instant);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set<ReportRequest.ReportFormat> convertAndValidateReportFormats(String reportFormat, StringBuilder errorMsg) {
        assert (errorMsg != null) : "Parameter 'errorMsg' of method 'convertAndValidateReportFormats' must not be null";
        if (reportFormat == null) {
            return Collections.emptySet();
        }
        HashSet<ReportRequest.ReportFormat> formats = new HashSet<ReportRequest.ReportFormat>();
        String[] stringArray = reportFormat.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            try {
                ReportRequest.ReportFormat format = ReportRequest.ReportFormat.valueOf(next.trim().toUpperCase());
                formats.add(format);
            }
            catch (Exception e) {
                errorMsg.append("Invalid value '" + next + "' in 'reportFormat'. Valid options are: " + String.join((CharSequence)", ", Arrays.stream(ReportRequest.ReportFormat.values()).map(Object::toString).collect(Collectors.toList())) + "\n");
            }
            ++n2;
        }
        return formats;
    }

    private void validateReportType(StringBuilder errorMsg) {
        if (this.m_reportRequest.getReportType() == null || this.m_reportRequest.getReportType().trim().length() == 0) {
            this.m_reportRequest.setActualReportType(ReportRequest.ReportType.STANDARD);
            return;
        }
        try {
            this.m_reportRequest.setActualReportType(ReportRequest.ReportType.valueOf(this.m_reportRequest.getReportType().trim().toUpperCase()));
        }
        catch (Exception e) {
            String validTypes = String.join((CharSequence)", ", Arrays.stream(ReportRequest.ReportType.values()).map(Object::toString).collect(Collectors.toList()));
            errorMsg.append(String.format("Invalid value '%s' for '%s'. Valid report types are: %s\n", this.m_reportRequest.getReportType(), Params.REPORT_TYPE.getParameterName(), validTypes));
        }
    }

    @Override
    public String getDescription() {
        return "Create Report";
    }
}

