/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModule;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModuleDependency;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractSystemExtension;
import com.hello2morrow.sonargraph.core.persistence.system.XsdRootPath;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;

public abstract class XmlAdditionalInfoProvider
implements IAdditionalFileInfoProvider {
    public static final XmlPersistenceContext CORE_PERSISTENT_CONTEXT = new XmlPersistenceContext("com.hello2morrow.sonargraph.core.persistence.system", CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, "com/hello2morrow/sonargraph/core/persistence/system/softwareSystem"));
    private final Installation m_installation;

    public XmlAdditionalInfoProvider(Installation installation) {
        assert (installation != null) : "Parameter 'installation' of method 'XmlAdditionalInfoProvider' must not be null";
        this.m_installation = installation;
    }

    protected final Installation getInstallation() {
        return this.m_installation;
    }

    public boolean canLoadSnapshot() {
        return true;
    }

    public boolean systemCanBeLoaded() {
        return true;
    }

    public boolean canCreateWorkspaceDependencies() {
        return true;
    }

    public boolean systemWasMigratedAndNeedsSave() {
        return false;
    }

    protected abstract XsdAbstractModule createXmlModule(Module.IModuleType var1);

    protected abstract XsdAbstractModuleDependency createWorkspaceDependency(Module var1, WorkspaceDependency var2);

    protected void getModuleDetailsFromXml(Installation installation, com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, Module module, XsdAbstractModule moduleXml, OperationResult result) {
        assert (installation != null) : "Parameter 'installation' of method 'getModuleDetailsFromXml' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addModuleDetailsFromXml' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addModuleDetailsFromXml' must not be null";
        assert (moduleXml != null) : "Parameter 'moduleXml' of method 'addModuleDetailsFromXml' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getModuleDetailsFromXml' must not be null";
        String description = moduleXml.getDescription();
        if (description != null) {
            module.setDescription(description);
        }
    }

    public void addModuleDetailsToXml(com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, Module module, SoftwareSystem systemXml, XsdAbstractModule moduleXml) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addModuleDetailsToXml' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addModuleDetailsToXml' must not be null";
        assert (systemXml != null) : "Parameter 'systemXml' of method 'addModuleDetailsToXml' must not be null";
        assert (moduleXml != null) : "Parameter 'moduleXml' of method 'addModuleDetailsToXml' must not be null";
    }

    public void getSystemDetailsFromXml(com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, XsdAbstractSystemExtension systemExtension, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getSystemDetailsFromXml' must not be null";
        assert (systemExtension != null) : "Parameter 'systemExtension' of method 'getSystemDetailsFromXml' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getSystemDetailsFromXml' must not be null";
    }

    protected void addSystemDetailsToXml(com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, SoftwareSystem systemXml) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addSystemDetailsToXml' must not be null";
        assert (systemXml != null) : "Parameter 'systemXml' of method 'addSystemDetailsToXml' must not be null";
    }

    public abstract WorkspaceDependency.IWorkspaceDependencyType getWorkspaceDependencyType(Class<? extends XsdAbstractModuleDependency> var1);

    public abstract Module.IModuleType getModuleType(Class<? extends XsdAbstractModule> var1);

    public void addInfoToXmlWorkspaceDependency(WorkspaceDependency dependency, XsdAbstractModuleDependency xsdDependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addInfoToXmlWorkspaceDependency' must not be null";
        assert (xsdDependency != null) : "Parameter 'xsdDependency' of method 'addInfoToXmlWorkspaceDependency' must not be null";
        assert (dependency.getAdditionalDependencyData() != null) : "AdditionalDependencyData must not be null";
        if (dependency.getAdditionalDependencyData().getVersion() != null && dependency.getAdditionalDependencyData().getVersion().trim().length() > 0) {
            xsdDependency.setVersion(dependency.getAdditionalDependencyData().getVersion().trim());
        }
    }

    protected void cleanup() {
    }

    protected WorkspaceDependency.AdditionalDependencyData createAdditionalDependencyData(WorkspaceDependency.IWorkspaceDependencyType workspaceDependencyType) {
        return new WorkspaceDependency.AdditionalDependencyData();
    }

    public WorkspaceDependency.AdditionalDependencyData getAdditionalDependencyData(XsdAbstractModuleDependency xsdDependency, WorkspaceDependency.IWorkspaceDependencyType workspaceDependencyType) {
        assert (xsdDependency != null) : "Parameter 'xsdDependency' of method 'getAdditionalDependencyData' must not be null";
        WorkspaceDependency.AdditionalDependencyData data = this.createAdditionalDependencyData(workspaceDependencyType);
        if (xsdDependency.getVersion() != null && xsdDependency.getVersion().trim().length() > 0) {
            data.setVersion(xsdDependency.getVersion());
        }
        if (xsdDependency.getLanguageOfEndpoint() != null && xsdDependency.getLanguageOfEndpoint().length() > 0) {
            data.setLanguageOfEndpoint(xsdDependency.getLanguageOfEndpoint());
        }
        return data;
    }

    public RootDirectoryPath getRootDirectoryPathFromXml(XsdRootPath xsdRootPath, com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, Module module) {
        assert (xsdRootPath != null) : "Parameter 'xsdRootPath' of method 'createRootDirectoryPath' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createRootDirectoryPath' must not be null";
        assert (module != null) : "Parameter 'module' of method 'createRootDirectoryPath' must not be null";
        TFile baseDir = softwareSystem.getUniqueExistingChild(Files.class).getBaseDirectory().getFile();
        TFile path = FileUtility.getAbsolutePath((TFile)baseDir, (String)xsdRootPath.getName());
        return module.createRootDirectoryPath(softwareSystem, module, path);
    }

    public void addRootDirectoryPathToXml(XsdAbstractModule xsdModule, Module module, RootDirectoryPath rootDirectoryPath) {
        assert (xsdModule != null) : "Parameter 'xsdModule' of method 'addRootDirectoryPathToXml' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addRootDirectoryPathToXml' must not be null";
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'createXsdRootDirectoryPath' must not be null";
        XsdRootPath xsdRootPath = new XsdRootPath();
        xsdRootPath.setName(rootDirectoryPath.getName());
        xsdModule.getRootPath().add(xsdRootPath);
    }

    public void getModuleDetailsFromXml(TFile baseDir, ModuleInfo module, XsdAbstractModule moduleXml) {
        assert (baseDir != null) : "Parameter 'baseDir' of method 'getModuleDetailsFromXml' must not be null";
        assert (module != null) : "Parameter 'module' of method 'getModuleDetailsFromXml' must not be null";
        assert (moduleXml != null) : "Parameter 'moduleXml' of method 'getModuleDetailsFromXml' must not be null";
    }
}

