/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system;

import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemPropertiesPersistenceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropertiesPersistenceProvider.class);
    private static final String PROP_FILE_NAME = "system.properties";

    private SystemPropertiesPersistenceProvider() {
    }

    public static void storeProperties(SoftwareSystem softwareSystem, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'storeProperties' must not be null";
        assert (result != null) : "Parameter 'result' of method 'storeProperties' must not be null";
        TFile hiddenDataDirectory = softwareSystem.getUniqueExistingChild(Files.class).getHiddenDataDirectory();
        TFile propFile = new TFile((File)hiddenDataDirectory, PROP_FILE_NAME);
        if (!softwareSystem.getSystemProperties().isEmpty()) {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (FileOutputStream out = new FileOutputStream((File)propFile);){
                    softwareSystem.getSystemProperties().store(out, "Private properties of this software system");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
                LOGGER.error("Failed to save software system properties to file '" + propFile.getNormalizedAbsolutePath() + "'", (Throwable)e);
            }
        } else if (propFile.canRead()) {
            try {
                propFile.rm();
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)e);
                LOGGER.error("Failed to remove file " + propFile.getNormalizedAbsolutePath(), (Throwable)e);
            }
        }
    }

    public static Properties readProperties(TFile directory) {
        assert (directory != null) : "Parameter 'directory' of method 'readProperties' must not be null";
        TFile systemPropertiesFile = new TFile((File)directory, PROP_FILE_NAME);
        Properties systemProps = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TFileInputStream input = new TFileInputStream((File)systemPropertiesFile);){
                systemProps.load((InputStream)input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return systemProps;
    }
}

