/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import de.schlichtherle.truezip.file.TFile;

public final class SystemDiffConfiguration {
    private final TFile m_systemBaseline;
    private final TFile m_localBaseline;
    private final boolean m_isSystemBaselineEnabled;
    private final boolean m_isLocalBaselineEnabled;

    public SystemDiffConfiguration(TFile systemBaseline, boolean isSystemBaselineEnabled, TFile localBaseline, boolean isLocalBaselineEnabled) {
        assert (!isSystemBaselineEnabled || systemBaseline != null) : "System baseline enabled but no system baseline specified";
        assert (!isLocalBaselineEnabled || localBaseline != null) : "Local baseline enabled but no local baseline specified";
        this.m_localBaseline = localBaseline;
        this.m_systemBaseline = systemBaseline;
        this.m_isSystemBaselineEnabled = isSystemBaselineEnabled;
        this.m_isLocalBaselineEnabled = isLocalBaselineEnabled;
    }

    public BaselineType getBaselineType() {
        if (this.m_isLocalBaselineEnabled) {
            return BaselineType.LOCAL;
        }
        if (this.m_isSystemBaselineEnabled) {
            return BaselineType.SYSTEM;
        }
        return null;
    }

    public TFile getActiveBaselineFile() {
        if (this.m_isLocalBaselineEnabled) {
            return this.m_localBaseline;
        }
        if (this.m_isSystemBaselineEnabled) {
            return this.m_systemBaseline;
        }
        return null;
    }

    public TFile getSystemBaseline() {
        return this.m_systemBaseline;
    }

    public boolean isSystemBaselineEnabled() {
        return this.m_isSystemBaselineEnabled;
    }

    public TFile getLocalBaseline() {
        return this.m_localBaseline;
    }

    public boolean isLocalBaselineEnabled() {
        return this.m_isLocalBaselineEnabled;
    }
}

