/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelVerifier
extends NamedElementVisitor
implements ProgrammingElement.IVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelVerifier.class);

    private boolean isReachableAndValid(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'isReachableAndValid' must not be null";
        NamedElement parent = namedElement.getParent();
        if (parent != null && parent.getChildren().contains(namedElement)) {
            return parent.isValid();
        }
        return false;
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element.isValid());
        super.visitNamedElement(element);
    }

    @Override
    public void visitProgrammingElement(ProgrammingElement element) {
        assert (element.isValid());
        for (ParserDependency dep : element.getOutgoingDependencies(new IParserDependencyType[0])) {
            if (this.isReachableAndValid(dep.getTo())) continue;
            LOGGER.error("Invalid dependency target: " + dep.getTo().toString());
            LOGGER.error("Source element: " + element.toString());
            assert (false) : "Dependency target '" + dep.getTo().getName() + "' is invalid";
        }
        for (ParserDependency dep : element.getIncomingDependencies(new IStandardEnumeration[0])) {
            if (this.isReachableAndValid(dep.getFrom())) continue;
            LOGGER.error("Invalid dependency source: " + dep.getFrom().toString());
            LOGGER.error("Target element: " + element.toString());
            assert (false) : "Dependency source '" + dep.getFrom().getName() + "' is invalid";
        }
        this.visitChildrenOf(element);
    }

    public static void assertModelConsistency(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'assertModelConsistency' must not be null";
        system.accept(new ModelVerifier());
    }
}

