/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IIssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.system.MetricProviders;
import com.hello2morrow.sonargraph.core.model.system.Notification;
import com.hello2morrow.sonargraph.core.model.system.Notifications;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.core.model.system.UnmodifiableRootModel;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class Installation
extends Root {
    public static final String NAME = "Installation";
    private static final IMetricDescriptor NO_DESCRIPTOR = new IMetricDescriptor(){

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean isFloat() {
            return false;
        }

        @Override
        public String getShortName() {
            return null;
        }

        @Override
        public IAnalyzerId getProvidingAnalyzerId() {
            return null;
        }

        @Override
        public NamedElement getNamedElement() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public IMetricId getMetricId() {
            return null;
        }

        @Override
        public IMetricLevel getLevel() {
            return null;
        }

        @Override
        public Language getLanguage() {
            return null;
        }

        @Override
        public String getFullyQualifiedName() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getId() {
            return "<NO-DESCRIPTOR>";
        }
    };
    private final Set<IProviderId> m_providers = new LinkedHashSet<IProviderId>();
    private final Set<IIssueId> m_issueIds = new LinkedHashSet<IIssueId>();
    private final Set<IIssueAffectedElementType> m_issueAffectedElementTypes = new LinkedHashSet<IIssueAffectedElementType>();
    private final Map<String, Map<String, IMetricDescriptor>> m_metricToLevelToDescriptor = Collections.synchronizedMap(new THashMap());
    private final Map<PluginProgrammingElementMetaData, Set<IProviderId>> m_pluginProgrammingElementMetaData = new LinkedHashMap<PluginProgrammingElementMetaData, Set<IProviderId>>(3);
    private final Map<PluginDependencyMetaData, Set<IProviderId>> m_pluginDependencyMetaData = new LinkedHashMap<PluginDependencyMetaData, Set<IProviderId>>(3);
    private final Version m_version;

    public Installation(Version version) {
        assert (version != null) : "Parameter 'version' of method 'Installation' must not be null";
        this.m_version = version;
        this.addChild(new InstallationModel(this));
        this.addChild(new Notifications(this));
        this.addChild(new MetricProviders(this));
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    public Version getVersion() {
        return this.m_version;
    }

    @Override
    public ElementWithIssues.IIssueManager getIssueManager() {
        return this.getUniqueExistingChild(InstallationModel.class);
    }

    @Override
    public VirtualModel getCurrentModel() {
        return this.getUniqueExistingChild(InstallationModel.class);
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (false) : "Store not supported";
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        assert (false) : "Retrieve not supported";
    }

    public synchronized void addProviderIds(Set<IProviderId> providers) {
        assert (providers != null) : "Parameter 'providers' of method 'addProviderIds' must not be null";
        this.m_providers.addAll(providers);
    }

    public synchronized void removeProviderIds(Set<IProviderId> providers) {
        assert (providers != null) : "Parameter 'providers' of method 'removeProviderIds' must not be null";
        this.m_providers.removeAll(providers);
    }

    public synchronized <T extends IProviderId> List<T> getProviderIds(Class<T> providerClass) {
        assert (providerClass != null) : "Parameter 'providerClass' of method 'getProviderIds' must not be null";
        ArrayList<IProviderId> issueProviderIds = new ArrayList<IProviderId>();
        for (IProviderId next : this.m_providers) {
            if (!providerClass.isAssignableFrom(next.getClass())) continue;
            issueProviderIds.add(next);
        }
        return issueProviderIds;
    }

    public synchronized void addIssueIds(Set<? extends IIssueId> issueIds) {
        assert (issueIds != null) : "Parameter 'issueIds' of method 'addIssueIds' must not be null";
        this.m_issueIds.addAll(issueIds);
    }

    public synchronized void removeIssueIds(Collection<? extends IIssueId> ids) {
        assert (ids != null) : "Parameter 'ids' of method 'removedIssueIds' must not be null";
        this.m_issueIds.removeAll(ids);
    }

    public synchronized IIssueId getFirstIssueId(Predicate<IIssueId> filter) {
        assert (filter != null) : "Parameter 'filter' of method 'getFirstIssueId' must not be null";
        return this.m_issueIds.stream().filter(filter).findFirst().orElse(null);
    }

    public synchronized void addPluginProgrammingElementMetaData(IProviderId providerId, Set<PluginProgrammingElementMetaData> metaData) {
        assert (providerId != null) : "Parameter 'providerId' of method 'addPluginProgrammingElementMetaData' must not be null";
        assert (metaData != null) : "Parameter 'metaData' of method 'addPluginProgrammingElementMetaData' must not be null";
        for (PluginProgrammingElementMetaData nextMetaData : metaData) {
            Set<IProviderId> nextProviders = this.m_pluginProgrammingElementMetaData.get(nextMetaData);
            if (nextProviders == null) {
                nextProviders = new LinkedHashSet<IProviderId>(2);
                this.m_pluginProgrammingElementMetaData.put(nextMetaData, nextProviders);
            }
            nextProviders.add(providerId);
        }
    }

    public synchronized void addPluginDependencyMetaData(IProviderId providerId, Set<PluginDependencyMetaData> metaData) {
        assert (providerId != null) : "Parameter 'providerId' of method 'addPluginDependencyMetaData' must not be null";
        assert (metaData != null) : "Parameter 'metaData' of method 'addPluginDependencyMetaData' must not be null";
        for (PluginDependencyMetaData nextMetaData : metaData) {
            Set<IProviderId> nextProviders = this.m_pluginDependencyMetaData.get(nextMetaData);
            if (nextProviders == null) {
                nextProviders = new LinkedHashSet<IProviderId>(2);
                this.m_pluginDependencyMetaData.put(nextMetaData, nextProviders);
            }
            nextProviders.add(providerId);
        }
    }

    public synchronized Set<IProviderId> getAvailableIssueProviderIds() {
        return new LinkedHashSet<IProviderId>(this.m_providers);
    }

    public synchronized Set<IIssueId> getAvailableIssueIds() {
        return new LinkedHashSet<IIssueId>(this.m_issueIds);
    }

    public synchronized void addAvailableIssueTypes(Set<IIssueAffectedElementType> issueAffectedElementTypes) {
        assert (issueAffectedElementTypes != null) : "Parameter 'issueAffectedElementTypes' of method 'addAvailableIssueTypes' must not be null";
        this.m_issueAffectedElementTypes.addAll(issueAffectedElementTypes);
    }

    public synchronized Collection<IIssueAffectedElementType> getAvailableIssueTypes() {
        return Collections.unmodifiableSet(this.m_issueAffectedElementTypes);
    }

    public Notifications getNotifications() {
        return this.getUniqueExistingChild(Notifications.class);
    }

    public List<Notification> getAllNotifications() {
        return this.getNotifications().getChildren(Notification.class);
    }

    public MetricProviders getMetricProviders() {
        return this.getUniqueExistingChild(MetricProviders.class);
    }

    public void metricDescriptorsChanged() {
        for (Map<String, IMetricDescriptor> nextLevelToDescriptor : this.m_metricToLevelToDescriptor.values()) {
            Iterator<Map.Entry<String, IMetricDescriptor>> nextIter = nextLevelToDescriptor.entrySet().iterator();
            while (nextIter.hasNext()) {
                Map.Entry<String, IMetricDescriptor> nextEntry = nextIter.next();
                if (nextEntry.getValue().isValid()) continue;
                nextIter.remove();
            }
        }
    }

    public IMetricDescriptor findMetricByIdAndLevel(String metricIdStandardName, String levelStandardName) {
        IMetricDescriptor found;
        assert (metricIdStandardName != null && metricIdStandardName.length() > 0) : "Parameter 'metricIdStandardName' of method 'findMetricByIdAndLevel' must not be empty";
        assert (levelStandardName != null && levelStandardName.length() > 0) : "Parameter 'levelStandardName' of method 'findMetricByIdAndLevel' must not be empty";
        THashMap levelToDescriptor = this.m_metricToLevelToDescriptor.get(metricIdStandardName);
        if (levelToDescriptor == null) {
            levelToDescriptor = new THashMap();
            this.m_metricToLevelToDescriptor.put(metricIdStandardName, (Map<String, IMetricDescriptor>)levelToDescriptor);
        }
        if ((found = levelToDescriptor.get(levelStandardName)) == null) {
            for (IMetricDescriptor nextMetricDescriptor : this.getUniqueExistingChild(MetricProviders.class).getChildrenRecursively(IMetricDescriptor.class, new Class[0])) {
                if (!nextMetricDescriptor.getMetricId().getStandardName().equals(metricIdStandardName) || !nextMetricDescriptor.getLevel().getStandardName().equals(levelStandardName)) continue;
                found = nextMetricDescriptor;
                levelToDescriptor.put(levelStandardName, found);
                break;
            }
            if (found == null) {
                found = NO_DESCRIPTOR;
                levelToDescriptor.put(levelStandardName, found);
            }
        }
        if (found == NO_DESCRIPTOR) {
            return null;
        }
        return found;
    }

    public void removeIssuesOfInvalidElements() {
        this.getUniqueExistingChild(InstallationModel.class).removeIssuesOfInvalidElements();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getDebugInfo() {
        void var2_11;
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        for (IProviderId iProviderId : this.m_providers) {
            builder.append("\n");
            builder.append("Provider: ").append(iProviderId.getDebugInfo());
        }
        for (IIssueId iIssueId : this.m_issueIds) {
            builder.append("\n");
            builder.append("Issue id: ").append(iIssueId.getDebugInfo());
        }
        for (Map.Entry entry : this.m_pluginProgrammingElementMetaData.entrySet()) {
            builder.append("\n");
            builder.append(((PluginProgrammingElementMetaData)entry.getKey()).getDebugInfo());
            builder.append("\n used by:");
            for (IProviderId nextProviderId : (Set)entry.getValue()) {
                builder.append(" ").append(nextProviderId.getStandardName());
            }
        }
        for (Map.Entry entry : this.m_pluginDependencyMetaData.entrySet()) {
            builder.append("\n");
            builder.append(((PluginDependencyMetaData)entry.getKey()).getDebugInfo());
            builder.append("\n used by:");
            for (IProviderId nextProviderId : (Set)entry.getValue()) {
                builder.append(" ").append(nextProviderId.getStandardName());
            }
        }
        boolean bl = false;
        for (Map.Entry<String, Map<String, IMetricDescriptor>> nextMetricToLevelToDescriptor : this.m_metricToLevelToDescriptor.entrySet()) {
            String nextMetricId = nextMetricToLevelToDescriptor.getKey();
            for (Map.Entry<String, IMetricDescriptor> nextLevelToDescriptor : nextMetricToLevelToDescriptor.getValue().entrySet()) {
                String nextLevel = nextLevelToDescriptor.getKey();
                IMetricDescriptor nextMetricDescriptor = nextLevelToDescriptor.getValue();
                builder.append("\n");
                builder.append("Cached metric descriptor: ").append(nextMetricId).append("|").append(nextLevel).append(": ").append(nextMetricDescriptor.getId()).append(" [Language=").append(nextMetricDescriptor.getLanguage()).append(", Analyzer=").append(nextMetricDescriptor.getProvidingAnalyzerId()).append("]");
                ++var2_11;
            }
        }
        if (var2_11 == false) {
            builder.append("\nNo cached metric descriptors");
        } else {
            builder.append("\n").append((int)var2_11).append(" cached metric descriptor(s)");
        }
        return builder.toString();
    }

    static final class InstallationModel
    extends UnmodifiableRootModel {
        InstallationModel(NamedElement parent) {
            super(parent);
        }

        @Override
        public boolean persist(ISnapshotProcessor.Mode mode) {
            return false;
        }

        @Override
        public void store(ISnapshotWriter writer) throws IOException {
            assert (false) : "Store not supported";
        }

        @Override
        public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
            assert (false) : "Retrieve not supported";
        }

        @Override
        public String getShortName() {
            return Installation.NAME;
        }

        @Override
        @Property
        public String getDescription() {
            return "Represents the unmodifiable installation model";
        }

        @Override
        public synchronized void refactoringsModified() {
            assert (false) : "No refactorings expected";
        }
    }
}

