/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.refactoring.ICollisionValidator;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringData;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MoveRefactoringData
extends RefactoringData {
    private final Map<Module, List<RootDirectoryPath>> m_availableTargetRootDirectories;
    private final List<String> m_availableMoveToParentNames;
    private final ITextValidator m_moveToParentNameValidator;
    private Module m_targetModule;
    private RootDirectoryPath m_targetRootDirectoryPath;
    private String m_targetParentName;

    public MoveRefactoringData(MoveRenameRefactoringInfo info, RootDirectoryPath targetRootDirectory, String moveToParentName, ICollisionValidator collisionValidator, String parentKind, String parentImageResourceName, String elementImageResourceName, Map<Module, List<RootDirectoryPath>> availableTargetRootDirectories, List<String> availableMoveToParentNames, ITextValidator moveToParentNameValidator) {
        super(info, targetRootDirectory, moveToParentName, collisionValidator, parentKind, parentImageResourceName, elementImageResourceName);
        assert (targetRootDirectory != null) : "Parameter 'targetRootDirectory' of method 'MoveRefactoringData' must not be null";
        assert (availableTargetRootDirectories != null && !availableTargetRootDirectories.isEmpty()) : "Parameter 'availableTargetRootDirectories' of method 'MoveRefactoringData' must not be empty";
        assert (availableMoveToParentNames != null && !availableMoveToParentNames.isEmpty()) : "Parameter 'availableMoveToParentNames' of method 'MoveRefactoringData' must not be empty";
        assert (moveToParentNameValidator != null) : "Parameter 'moveToParentNameValidator' of method 'MoveRenameRefactoringData' must not be null";
        this.m_availableTargetRootDirectories = availableTargetRootDirectories;
        this.m_availableMoveToParentNames = availableMoveToParentNames;
        this.m_moveToParentNameValidator = moveToParentNameValidator;
        this.m_targetRootDirectoryPath = targetRootDirectory;
        this.m_targetParentName = moveToParentName;
        this.m_targetModule = targetRootDirectory.getParent(Module.class, new Class[0]);
        assert (this.m_targetModule != null) : "Parameter 'm_targetModule' of method 'MoveRefactoringData' must not be null";
        List<RootDirectoryPath> targetRootDirectories = this.m_availableTargetRootDirectories.get(this.m_targetModule);
        assert (targetRootDirectories != null) : "'targetRootDirectories' of method 'MoveRefactoringData' must not be null";
        assert (targetRootDirectories.contains(this.m_targetRootDirectoryPath)) : this.m_targetRootDirectoryPath.getIdentifyingPath() + " not found in available root directory paths";
        for (Map.Entry<Module, List<RootDirectoryPath>> nextEntry : availableTargetRootDirectories.entrySet()) {
            assert (!nextEntry.getValue().isEmpty()) : "No available target root directories for module: " + String.valueOf(nextEntry.getKey());
        }
        assert (this.m_availableMoveToParentNames.contains(this.m_targetParentName)) : "Move to parent name not found in available: " + this.m_targetParentName;
    }

    @Override
    public final List<String> getAvailableTargetModules() {
        List<String> modules = this.m_availableTargetRootDirectories.keySet().stream().map(Module::getName).collect(Collectors.toList());
        Collections.sort(modules);
        return modules;
    }

    @Override
    public final List<String> getAvailableTargetRootDirectories(String moduleName) {
        List targetRootDirectoriesInModule = this.m_availableTargetRootDirectories.entrySet().stream().filter(entry -> ((Module)entry.getKey()).getName().equals(moduleName)).map(entry -> (List)entry.getValue()).findFirst().orElse(Collections.emptyList());
        if (targetRootDirectoriesInModule.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> identifyingPaths = targetRootDirectoriesInModule.stream().map(RootDirectoryPath::getIdentifyingPath).collect(Collectors.toList());
        Collections.sort(identifyingPaths);
        return identifyingPaths;
    }

    private List<RootDirectoryPath> getAvailableTargetRootDirectoriesAsElements(String moduleName) {
        if (moduleName == null || moduleName.trim().isEmpty()) {
            return Collections.emptyList();
        }
        List<RootDirectoryPath> targetRootDirectoriesInModule = this.m_availableTargetRootDirectories.entrySet().stream().filter(entry -> ((Module)entry.getKey()).getName().equals(moduleName)).map(entry -> (List)entry.getValue()).findFirst().orElse(Collections.emptyList());
        if (targetRootDirectoriesInModule.isEmpty()) {
            return targetRootDirectoriesInModule;
        }
        Collections.sort(targetRootDirectoriesInModule, (r1, r2) -> r1.getIdentifyingPath().compareTo(r2.getIdentifyingPath()));
        return targetRootDirectoriesInModule;
    }

    @Override
    public final List<String> getAvailableTargetParentNames() {
        ArrayList<String> targetParentNames = new ArrayList<String>(this.m_availableMoveToParentNames);
        Collections.sort(targetParentNames);
        return targetParentNames;
    }

    @Override
    public final String getTargetModule() {
        return this.m_targetModule != null ? this.m_targetModule.getName() : null;
    }

    @Override
    public final RootDirectoryPath getTargetRootDirectory() {
        return this.m_targetRootDirectoryPath;
    }

    @Override
    public final ValidationResult setTargetModule(String moduleName) {
        if (moduleName == null) {
            ValidationResult result = new ValidationResult(this.m_targetModule != null);
            result.addError("Missing target module");
            return result;
        }
        this.m_targetModule = this.m_availableTargetRootDirectories.keySet().stream().filter(m -> m.getName().equals(moduleName)).findFirst().orElse(null);
        List<RootDirectoryPath> availableTargetRootDirectories = this.getAvailableTargetRootDirectoriesAsElements(moduleName);
        RootDirectoryPath previousTargetRootDirectoryPath = this.m_targetRootDirectoryPath;
        RootDirectoryPath rootDirectoryPath = this.m_targetRootDirectoryPath = availableTargetRootDirectories.isEmpty() ? null : availableTargetRootDirectories.get(0);
        if (this.m_targetRootDirectoryPath == null) {
            ValidationResult result = new ValidationResult(this.m_targetRootDirectoryPath != previousTargetRootDirectoryPath);
            result.addError("Missing root directory");
            return result;
        }
        return this.validateCollision();
    }

    @Override
    public ValidationResult setTargetRootDirectoryPath(String rootPath) {
        String trimmedPath;
        String string = trimmedPath = rootPath != null ? rootPath.trim() : null;
        if (trimmedPath == null || trimmedPath.trim().isEmpty()) {
            ValidationResult result = new ValidationResult(this.m_targetRootDirectoryPath != null);
            this.m_targetRootDirectoryPath = null;
            result.addError("Missing root directory");
            return result;
        }
        List<RootDirectoryPath> paths = this.m_availableTargetRootDirectories.get(this.m_targetModule);
        if (paths != null) {
            RootDirectoryPath changed = paths.stream().filter(r -> r.getIdentifyingPath().equals(trimmedPath)).findFirst().orElse(null);
            ValidationResult result = new ValidationResult(changed != this.m_targetRootDirectoryPath);
            this.m_targetRootDirectoryPath = changed;
            if (this.m_targetRootDirectoryPath == null) {
                result.addError("Missing root directory");
                return result;
            }
            return this.validateCollision();
        }
        ValidationResult result = new ValidationResult(this.m_targetRootDirectoryPath != null);
        result.addError("Specified root does not exist in module");
        return result;
    }

    @Override
    public final ValidationResult setTargetRootDirectoryPath(RootDirectoryPath rootDirectoryPath) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'setTargetRootDirectory' must not be null";
        Module module = rootDirectoryPath.getParent(Module.class, new Class[0]);
        assert (module != null) : "Parameter 'module' of method 'setTargetRootDirectory' must not be null";
        List<RootDirectoryPath> availableTargetRootDirectoryPaths = this.getAvailableTargetRootDirectoriesAsElements(module.getName());
        assert (availableTargetRootDirectoryPaths != null) : "Parameter 'availableTargetRootDirectoryPaths' of method 'setTargetRootDirectory' must not be null";
        assert (availableTargetRootDirectoryPaths.contains(rootDirectoryPath)) : "Not in available target root directory paths: " + String.valueOf(rootDirectoryPath);
        this.m_targetModule = module;
        this.m_targetRootDirectoryPath = rootDirectoryPath;
        return this.validateCollision();
    }

    @Override
    public final ITextValidator getTargetParentNameValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString;
                String string = newInputString = newInput != null ? newInput.trim() : null;
                if (MoveRefactoringData.this.m_availableMoveToParentNames.contains(newInputString)) {
                    return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInputString));
                }
                return MoveRefactoringData.this.m_moveToParentNameValidator.isValid(currentInput, newInputString);
            }
        };
    }

    @Override
    public ITextValidator getModuleNameValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString = newInput != null ? newInput.trim() : null;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInputString));
                if (newInputString == null || newInputString.isEmpty()) {
                    result.addError("Must not be empty");
                } else if (!MoveRefactoringData.this.getAvailableTargetModules().contains(newInputString)) {
                    result.addError("Module '" + newInputString + "' does not exist");
                }
                return result;
            }
        };
    }

    @Override
    public ITextValidator getTargetRootDirectoryValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString = newInput != null ? newInput.trim() : null;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInputString));
                if (newInputString == null || newInputString.isEmpty()) {
                    result.addError("Must not be empty");
                } else if (!MoveRefactoringData.this.getAvailableTargetRootDirectories(MoveRefactoringData.this.getTargetModule()).contains(newInputString)) {
                    result.addError("Directory '" + newInputString + "' does not exist");
                }
                return result;
            }
        };
    }

    @Override
    public String getModuleForName(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        return this.getAvailableTargetModules().stream().filter(m -> m.equals(name)).findFirst().orElse(null);
    }

    @Override
    public final ValidationResult setTargetParentName(String targetParentName) {
        this.m_targetParentName = targetParentName;
        return this.validateCollision();
    }

    @Override
    public boolean hasBeenModified() {
        return this.getOriginalRootDirectory() != this.m_targetRootDirectoryPath || !this.getOriginalParentName().equals(this.m_targetParentName);
    }

    @Override
    public boolean hasValidData() {
        return super.hasValidData() && this.m_targetModule != null && this.m_targetParentName != null && this.m_moveToParentNameValidator.isValid(this.getOriginalParentName(), this.m_targetParentName).isSuccess() && this.m_targetRootDirectoryPath != null;
    }

    @Override
    public String getTargetParentName() {
        return this.m_targetParentName;
    }

    @Override
    protected boolean useTargetNameForCollisionCheck() {
        return false;
    }
}

