/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileAccess;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectoryPath;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class SoftwareSystemFilesDirectory
extends SoftwareSystemDirectoryPath
implements IBaseDirectory,
ISoftwareSystemDefinitionElement {
    public static final boolean isOutOfSync(IModifiableFile modifiableFile) {
        return modifiableFile != null && modifiableFile.existsOnDisk() && (!modifiableFile.getFile().exists() || modifiableFile.getTimestamp() != modifiableFile.getFile().lastModified());
    }

    public static void removeFile(TFile file, boolean recursively, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'removeFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'removeFile' must not be null";
        try {
            if (recursively) {
                file.rm_r();
            } else {
                file.rm();
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)e);
        }
    }

    private static List<TFile> getContainedDirectories(TFile directory) {
        assert (directory != null) : "Parameter 'directory' of method 'getContainedDirectories' must not be null";
        TFile[] containedDirectories = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && file.isDirectory();
            }
        });
        if (containedDirectories != null && containedDirectories.length > 0) {
            return new ArrayList<TFile>(Arrays.asList(containedDirectories));
        }
        return Collections.emptyList();
    }

    private static List<TFile> getContainedFiles(final IModifiableFileAccess fileAccess, TFile directory, final String[] extensions) {
        assert (fileAccess != null) : "Parameter 'fileAccess' of method 'getContainedFiles' must not be null";
        assert (directory != null) : "Parameter 'directory' of method 'getContainedScriptFiles' must not be null";
        assert (extensions != null) : "Parameter 'extensions' of method 'getContainedFiles' must not be null";
        TFile[] containedFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                if (fileName != null && fileName.length() > 0) {
                    String[] stringArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String nextExtension = stringArray[n2];
                        if (fileName.endsWith(nextExtension) && fileAccess.accept(fileName)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        });
        if (containedFiles != null && containedFiles.length > 0) {
            return new ArrayList<TFile>(Arrays.asList(containedFiles));
        }
        return Collections.emptyList();
    }

    private static final boolean isOutOfSync(IModifiableFileAccess fileAccess, SoftwareSystemDirectoryPath directoryPath, String[] extensions) {
        assert (fileAccess != null) : "Parameter 'fileAccess' of method 'isOutOfSync' must not be null";
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'isOutOfSync' must not be null";
        assert (extensions != null) : "Parameter 'extensions' of method 'isOutOfSync' must not be null";
        TFile directoryFile = directoryPath.getFile();
        if (!directoryFile.exists()) {
            return true;
        }
        List<TFile> containedFiles = SoftwareSystemFilesDirectory.getContainedFiles(fileAccess, directoryFile, extensions);
        List<IModifiableFile> modifiableFiles = fileAccess.getModifiableFiles(directoryPath);
        for (IModifiableFile next : modifiableFiles) {
            if (SoftwareSystemFilesDirectory.isOutOfSync(next)) {
                return true;
            }
            TFile nextFile = next.getFile();
            Iterator<TFile> containedFileIterator = containedFiles.iterator();
            while (containedFileIterator.hasNext()) {
                TFile nextContained = containedFileIterator.next();
                if (!FileUtility.areEqual((TFile)nextFile, (TFile)nextContained)) continue;
                containedFileIterator.remove();
            }
        }
        if (!containedFiles.isEmpty()) {
            return true;
        }
        List<TFile> containedDirectories = SoftwareSystemFilesDirectory.getContainedDirectories(directoryFile);
        List<SoftwareSystemDirectoryPath> directoryPaths = directoryPath.getChildren(SoftwareSystemDirectoryPath.class);
        if (containedDirectories.size() != directoryPaths.size()) {
            return true;
        }
        for (SoftwareSystemDirectoryPath next : directoryPaths) {
            if (SoftwareSystemFilesDirectory.isOutOfSync(fileAccess, next, extensions)) {
                return true;
            }
            TFile nextDirectoryFile = next.getFile();
            Iterator<TFile> containedDirectoryIterator = containedDirectories.iterator();
            while (containedDirectoryIterator.hasNext()) {
                TFile nextContained = containedDirectoryIterator.next();
                if (!FileUtility.areEqual((TFile)nextDirectoryFile, (TFile)nextContained)) continue;
                containedDirectoryIterator.remove();
            }
        }
        return false;
    }

    public SoftwareSystemFilesDirectory(NamedElement parent, String relPath) {
        super(parent, relPath);
    }

    public SoftwareSystemFilesDirectory(NamedElement parent, TFile file) {
        super(parent, file);
    }

    @Override
    public boolean contributesToIdentifyingPath() {
        return false;
    }

    @Override
    public final String getImageResourceName() {
        return DirectoryPath.class.getSimpleName();
    }

    @Override
    public final TFile getDirectoryFile() {
        return this.getFile();
    }

    public final void reallocate() {
        super.resetFile();
        this.getFile();
    }

    public boolean isOutOfSync(IModifiableFileAccess fileAccess, String[] ... extensions) {
        boolean existsOnDisc;
        assert (fileAccess != null) : "Parameter 'fileAccess' of method 'isOutOfSync' must not be null";
        assert (extensions != null) : "Parameter 'extensions' of method 'isOutOfSync' must not be null";
        TFile file = this.getFile();
        boolean bl = existsOnDisc = file != null && file.exists();
        if (this.correspondingFileExists() != existsOnDisc) {
            return true;
        }
        ArrayList<String> allExtensions = new ArrayList<String>();
        String[][] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String[] nextExtensions = stringArray[n2];
            allExtensions.addAll(Arrays.asList(nextExtensions));
            ++n2;
        }
        if (existsOnDisc) {
            return SoftwareSystemFilesDirectory.isOutOfSync(fileAccess, this, allExtensions.toArray(new String[allExtensions.size()]));
        }
        return false;
    }

    public boolean isOutOfSync(String[] ... extensions) {
        assert (extensions != null) : "Parameter 'extensions' of method 'isOutOfSync' must not be null";
        return this.isOutOfSync(new IModifiableFileAccess(){}, extensions);
    }

    public final void removeAll(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'removeAll' must not be null";
        TFile directory = this.getDirectoryFile();
        if (directory.exists()) {
            for (IModifiablePath next : this.getChildren(IModifiablePath.class)) {
                next.remove();
            }
            TFile[] files = directory.listFiles();
            if (files != null) {
                TFile[] tFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    TFile nextFile = tFileArray[n2];
                    if (nextFile.isDirectory()) {
                        try {
                            nextFile.rm_r();
                        }
                        catch (IOException e) {
                            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)e);
                        }
                    } else {
                        try {
                            nextFile.rm();
                        }
                        catch (IOException e) {
                            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

