/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;

public final class TransferAvailability {
    private final ArchitecturalViewFile m_file;
    private final ExplorationViewRepresentation m_representation;
    private final boolean m_architectureTransferIsPossible;
    private final boolean m_createIgnoreViolationResolutionsIsPossible;
    private final boolean m_refactoringTransferIsPossible;
    private final String m_warningInfo;

    public TransferAvailability(ArchitecturalViewFile file, ExplorationViewRepresentation representation, boolean architectureTransferIsPossible, boolean createIgnoreViolationResolutionsIsPossible, boolean refactoringTransferIsPossible, String warningInfo) {
        assert (file != null) : "Parameter 'file' of method 'TransferAvailability' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'TransferAvailability' must not be null";
        assert (architectureTransferIsPossible || refactoringTransferIsPossible) : "At least 1 transfer possibility expected";
        assert (warningInfo != null) : "Parameter 'warningInfo' of method 'TransferAvailability' must not be null";
        assert (!createIgnoreViolationResolutionsIsPossible || architectureTransferIsPossible) : "If createIgnoreViolationResolutionsIsPossible is 'true' also architectureTransferIsPossible must be 'true'";
        this.m_file = file;
        this.m_representation = representation;
        this.m_architectureTransferIsPossible = architectureTransferIsPossible;
        this.m_createIgnoreViolationResolutionsIsPossible = createIgnoreViolationResolutionsIsPossible;
        this.m_refactoringTransferIsPossible = refactoringTransferIsPossible;
        this.m_warningInfo = warningInfo;
    }

    public ArchitecturalViewFile getFile() {
        return this.m_file;
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public boolean isArchitectureTransferPossible() {
        return this.m_architectureTransferIsPossible;
    }

    public boolean isCreateIgnoreViolationResolutionsPossible() {
        return this.m_createIgnoreViolationResolutionsIsPossible;
    }

    public boolean isRefactoringTransferPossible() {
        return this.m_refactoringTransferIsPossible;
    }

    public String getWarningInfo() {
        return this.m_warningInfo;
    }
}

