/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.ISourceElementProvider;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IProvidesSourceElementCount;
import com.hello2morrow.sonargraph.core.model.explorationview.ImageSupport;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class ProgrammingElementNode
extends ArchitecturalViewNode
implements IProgrammingElementNode,
ISourceElementProvider,
IProvidesSourceElementCount {
    private final NamedElement m_underlyingElement;
    private final Collection<ProgrammingElement> m_programmingElements;

    public ProgrammingElementNode(ArchitecturalViewElement parent, PresentationMode presentationMode, boolean isReadOnly, NamedElement underlying, Collection<ProgrammingElement> all) {
        super(parent, presentationMode, isReadOnly);
        assert (underlying != null) : "Parameter 'underlying' of method 'ProgrammingElementNode' must not be null";
        assert (all != null && !all.isEmpty()) : "Parameter 'all' of method 'ProgrammingElementNode' must not be empty";
        this.m_underlyingElement = underlying;
        this.m_programmingElements = all;
        this.setIsLazyExpandable(true);
        this.updateDepth();
    }

    @Override
    public final ArchitecturalViewNode copy(ArchitecturalViewElement parent) {
        assert (false) : "Not supported";
        return null;
    }

    @Override
    public final NamedElement getSourceElement() {
        return this.getFirstUnderlyingElement();
    }

    @Override
    public final boolean supportsAutoExpand() {
        return false;
    }

    @Override
    public final NamedElement getFirstUnderlyingElement() {
        return this.m_underlyingElement;
    }

    @Override
    public final Language getLanguage() {
        return this.getFirstUnderlyingElement().getLanguage();
    }

    @Override
    public final List<NamedElement> getUnderlyingElements() {
        return Collections.singletonList(this.m_underlyingElement);
    }

    @Override
    public final String getShortName() {
        return this.getFirstUnderlyingElement().getShortName();
    }

    @Override
    public final String getName() {
        return this.getFirstUnderlyingElement().getName();
    }

    @Override
    public final String getImageResourceName() {
        return this.getFirstUnderlyingElement().getImageResourceName();
    }

    @Override
    public final ImageDecoratorInfo getImageResourceDecoratorInfo() {
        return ImageSupport.getImageResourceDecoratorInfo(this, this.isReadOnly());
    }

    @Override
    public final boolean isExternal() {
        return this.getFirstUnderlyingElement().isExternal();
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        return this.getFirstUnderlyingElement().getFullyQualifiedNamePart();
    }

    @Override
    public final Collection<ProgrammingElement> getProgrammingElements() {
        return Collections.unmodifiableCollection(this.m_programmingElements);
    }

    protected abstract ProgrammingElement getProgrammingElementForPresentationNameCreation();

    @Override
    public final String getPresentationName(boolean shortName) {
        int genericParameters;
        ProgrammingElement programmingElement = this.getProgrammingElementForPresentationNameCreation();
        if (programmingElement instanceof IRoutine) {
            int numberOfParameters = ((IRoutine)((Object)programmingElement)).getNumberOfParameters();
            int genericParameters2 = ((IRoutine)((Object)programmingElement)).getNumberOfGenericTypeParameters();
            if (numberOfParameters > 0 || genericParameters2 > 0) {
                StringBuilder builder = new StringBuilder(programmingElement.getRawPresentationName(shortName));
                builder.append("(");
                int i = 0;
                while (i < numberOfParameters) {
                    builder.append(".");
                    ++i;
                }
                builder.append(")");
                if (genericParameters2 > 0) {
                    builder.append(" <");
                    i = 0;
                    while (i < genericParameters2) {
                        builder.append(".");
                        ++i;
                    }
                    builder.append(">");
                }
                return builder.toString();
            }
            return programmingElement.getRawPresentationName(shortName) + "()";
        }
        if (programmingElement instanceof IType && (genericParameters = ((IType)((Object)programmingElement)).getNumberOfGenericTypeParameters()) > 0) {
            StringBuilder builder = new StringBuilder(programmingElement.getRawPresentationName(shortName));
            builder.append("<");
            int i = 0;
            while (i < genericParameters) {
                builder.append(".");
                ++i;
            }
            builder.append(">");
            return builder.toString();
        }
        return programmingElement.getRawPresentationName(shortName);
    }

    @Override
    public final ArchitecturalViewNode getArchitecturalViewNode() {
        return this;
    }

    @Override
    public final int getSourceElementCount() {
        int sourceElementCount = 0;
        if (!this.isExternal()) {
            for (ProgrammingElement next : this.m_programmingElements) {
                int sec = next.getSourceElementCount();
                if (sec == -1) continue;
                sourceElementCount += sec;
            }
        }
        return sourceElementCount;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitProgrammingElementNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitProgrammingElementNode(ProgrammingElementNode var1);
    }
}

