/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArchitecturalViewFindingProperties {
    private final ExplorationViewRepresentation m_representation;
    private final ITextValidator m_nameValidator;
    private final List<ArchitecturalViewNode.ArchitecturalViewDependency> m_dependencies;
    private String m_name;
    private String m_description;
    private boolean m_ignoreViolations;

    public ArchitecturalViewFindingProperties(String name, String description, boolean ignoreViolations, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, ITextValidator nameValidator, ExplorationViewRepresentation representation) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ArchitecturalViewFindingProperties' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'ArchitecturalViewFindingProperties' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'ArchitecturalViewFindingProperties' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'ArchitecturalViewFocusRequest' must not be null";
        assert (nameValidator != null) : "Parameter 'nameValidator' of method 'ArchitecturalViewFindingProperties' must not be null";
        this.m_name = name;
        this.m_description = description;
        this.m_ignoreViolations = ignoreViolations;
        this.m_dependencies = new ArrayList<ArchitecturalViewNode.ArchitecturalViewDependency>(dependencies);
        this.m_representation = representation;
        this.m_nameValidator = nameValidator;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean ignoreViolations() {
        return this.m_ignoreViolations;
    }

    public void setName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
        this.m_name = name;
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    public void setIgnoreViolations(boolean ignoreViolations) {
        this.m_ignoreViolations = ignoreViolations;
    }

    public List<ArchitecturalViewNode.ArchitecturalViewDependency> getDependencies() {
        return Collections.unmodifiableList(this.m_dependencies);
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public ITextValidator getNameValidator() {
        return this.m_nameValidator;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.getClass().getSimpleName()).append("] ").append(this.m_name).append(" (").append(this.m_description).append("):");
        for (ArchitecturalViewNode.ArchitecturalViewDependency next : this.m_dependencies) {
            builder.append("\n");
            builder.append(next.getFrom().getRelativePath()).append(" -> ").append(next.getTo().getRelativePath());
        }
        return builder.toString();
    }
}

